/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.mixin;

import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.entity.BalmPlayer;
import net.blay09.mods.balm.api.event.DigSpeedEvent;
import net.blay09.mods.balm.api.event.LivingDamageEvent;
import net.blay09.mods.balm.api.event.PlayerAttackEvent;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_4050;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1657.class})
public class PlayerMixin
implements BalmPlayer {
    private class_4050 forcedPose;

    @ModifyVariable(method={"actuallyHurt(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/damagesource/DamageSource;F)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;setAbsorptionAmount(F)V"), argsOnly=true)
    private float actuallyHurt(float damageAmount, class_3218 level, class_1282 damageSource) {
        LivingDamageEvent event = new LivingDamageEvent((class_1309)((class_1657)this), damageSource, damageAmount);
        Balm.getEvents().fireEvent(event);
        if (event.isCanceled()) {
            return 0.0f;
        }
        return event.getDamageAmount();
    }

    @Inject(method={"getDestroySpeed(Lnet/minecraft/world/level/block/state/BlockState;)F"}, at={@At(value="RETURN")}, cancellable=true)
    private void getDestroySpeed(class_2680 state, CallbackInfoReturnable<Float> callbackInfo) {
        class_1657 player = (class_1657)this;
        float digSpeed = callbackInfo.getReturnValueF();
        DigSpeedEvent event = new DigSpeedEvent(player, state, digSpeed);
        Balm.getEvents().fireEvent(event);
        if (event.isCanceled()) {
            callbackInfo.setReturnValue((Object)Float.valueOf(-1.0f));
        } else if (event.getSpeedOverride() != null) {
            callbackInfo.setReturnValue((Object)event.getSpeedOverride());
        }
    }

    @Inject(method={"attack(Lnet/minecraft/world/entity/Entity;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void attack(class_1297 entity, CallbackInfo callbackInfo) {
        class_1657 player = (class_1657)this;
        PlayerAttackEvent event = new PlayerAttackEvent(player, entity);
        Balm.getEvents().fireEvent(event);
        if (event.isCanceled()) {
            callbackInfo.cancel();
        }
    }

    @Inject(method={"updatePlayerPose()V"}, at={@At(value="HEAD")}, cancellable=true)
    public void updatePlayerPose(CallbackInfo callbackInfo) {
        if (this.forcedPose != null) {
            ((class_1657)this).method_18380(this.forcedPose);
            callbackInfo.cancel();
        }
    }

    @Override
    public class_4050 getForcedPose() {
        return this.forcedPose;
    }

    @Override
    public void setForcedPose(class_4050 pose) {
        this.forcedPose = pose;
    }
}

