/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.world.level.block.entity;

import java.util.function.Consumer;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class BalmBlockEntityUtils {
    public static void sync(BlockEntity blockEntity) {
        Level level = blockEntity.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.getChunkSource().blockChanged(blockEntity.getBlockPos());
        }
    }

    public static Packet<ClientGamePacketListener> createUpdatePacket(BlockEntity blockEntity) {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)blockEntity, BlockEntity::getUpdateTag);
    }

    public static CompoundTag createUpdateTag(HolderLookup.Provider registries, Consumer<CompoundTag> outputConsumer) {
        CompoundTag output = new CompoundTag();
        outputConsumer.accept(output);
        return output;
    }
}

