/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.forge.event;

import com.mojang.brigadier.ParseResults;
import net.blay09.mods.balm.api.event.BreakBlockEvent;
import net.blay09.mods.balm.api.event.ChunkLoadingEvent;
import net.blay09.mods.balm.api.event.ChunkTrackingEvent;
import net.blay09.mods.balm.api.event.CommandEvent;
import net.blay09.mods.balm.api.event.CropGrowEvent;
import net.blay09.mods.balm.api.event.EntityAddedEvent;
import net.blay09.mods.balm.api.event.EventPriority;
import net.blay09.mods.balm.api.event.ItemCraftedEvent;
import net.blay09.mods.balm.api.event.LevelLoadingEvent;
import net.blay09.mods.balm.api.event.LivingDamageEvent;
import net.blay09.mods.balm.api.event.LivingDeathEvent;
import net.blay09.mods.balm.api.event.LivingFallEvent;
import net.blay09.mods.balm.api.event.LivingHealEvent;
import net.blay09.mods.balm.api.event.PlayerAttackEvent;
import net.blay09.mods.balm.api.event.PlayerChangedDimensionEvent;
import net.blay09.mods.balm.api.event.PlayerLoginEvent;
import net.blay09.mods.balm.api.event.PlayerLogoutEvent;
import net.blay09.mods.balm.api.event.PlayerRespawnEvent;
import net.blay09.mods.balm.api.event.TickPhase;
import net.blay09.mods.balm.api.event.TickType;
import net.blay09.mods.balm.api.event.TossItemEvent;
import net.blay09.mods.balm.api.event.UseBlockEvent;
import net.blay09.mods.balm.api.event.UseItemEvent;
import net.blay09.mods.balm.api.event.server.ServerStartedEvent;
import net.blay09.mods.balm.api.event.server.ServerStartingEvent;
import net.blay09.mods.balm.api.event.server.ServerStoppedEvent;
import net.blay09.mods.balm.forge.event.ForgeBalmEvents;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.server.ServerLifecycleHooks;

public class ForgeBalmCommonEvents {
    public static void registerEvents(ForgeBalmEvents events) {
        events.registerTickEvent(TickType.Server, TickPhase.Start, handler -> MinecraftForge.EVENT_BUS.addListener(orig -> {
            if (orig.phase == TickEvent.Phase.START) {
                handler.handle(ServerLifecycleHooks.getCurrentServer());
            }
        }));
        events.registerTickEvent(TickType.Server, TickPhase.End, handler -> MinecraftForge.EVENT_BUS.addListener(orig -> {
            if (orig.phase == TickEvent.Phase.END) {
                handler.handle(ServerLifecycleHooks.getCurrentServer());
            }
        }));
        events.registerTickEvent(TickType.ServerLevel, TickPhase.Start, handler -> MinecraftForge.EVENT_BUS.addListener(orig -> {
            if (orig.phase == TickEvent.Phase.START && orig.side == LogicalSide.SERVER) {
                handler.handle(orig.level);
            }
        }));
        events.registerTickEvent(TickType.ServerLevel, TickPhase.End, handler -> MinecraftForge.EVENT_BUS.addListener(orig -> {
            if (orig.phase == TickEvent.Phase.END && orig.side == LogicalSide.SERVER) {
                handler.handle(orig.level);
            }
        }));
        events.registerTickEvent(TickType.ServerPlayer, TickPhase.Start, handler -> MinecraftForge.EVENT_BUS.addListener(orig -> {
            if (orig.phase == TickEvent.Phase.START && orig.side == LogicalSide.SERVER) {
                handler.handle((ServerPlayer)orig.player);
            }
        }));
        events.registerTickEvent(TickType.ServerPlayer, TickPhase.End, handler -> MinecraftForge.EVENT_BUS.addListener(orig -> {
            if (orig.phase == TickEvent.Phase.END && orig.side == LogicalSide.SERVER) {
                handler.handle((ServerPlayer)orig.player);
            }
        }));
        events.registerTickEvent(TickType.Entity, TickPhase.Start, handler -> MinecraftForge.EVENT_BUS.addListener(orig -> handler.handle((Entity)orig.getEntity())));
        events.registerTickEvent(TickType.Entity, TickPhase.End, handler -> MinecraftForge.EVENT_BUS.addListener(orig -> handler.handle((Entity)orig.getEntity())));
        events.registerEvent(ServerStartingEvent.class, priority -> MinecraftForge.EVENT_BUS.addListener(ForgeBalmEvents.toForge(priority), orig -> {
            ServerStartingEvent event = new ServerStartingEvent(orig.getServer());
            events.fireEventHandlers((EventPriority)((Object)priority), event);
        }));
        events.registerEvent(ServerStartedEvent.class, priority -> MinecraftForge.EVENT_BUS.addListener(ForgeBalmEvents.toForge(priority), orig -> {
            ServerStartedEvent event = new ServerStartedEvent(orig.getServer());
            events.fireEventHandlers((EventPriority)((Object)priority), event);
        }));
        events.registerEvent(ServerStoppedEvent.class, priority -> MinecraftForge.EVENT_BUS.addListener(ForgeBalmEvents.toForge(priority), orig -> {
            ServerStoppedEvent event = new ServerStoppedEvent(orig.getServer());
            events.fireEventHandlers((EventPriority)((Object)priority), event);
        }));
        events.registerEvent(UseBlockEvent.class, priority -> MinecraftForge.EVENT_BUS.addListener(ForgeBalmEvents.toForge(priority), orig -> {
            UseBlockEvent event = new UseBlockEvent(orig.getEntity(), orig.getLevel(), orig.getHand(), orig.getHitVec());
            events.fireEventHandlers((EventPriority)((Object)priority), event);
            if (event.isCanceled()) {
                orig.setCancellationResult(event.getInteractionResult());
                orig.setCanceled(true);
            }
        }));
        events.registerEvent(UseItemEvent.class, priority -> MinecraftForge.EVENT_BUS.addListener(ForgeBalmEvents.toForge(priority), orig -> {
            UseItemEvent event = new UseItemEvent(orig.getEntity(), orig.getLevel(), orig.getHand());
            events.fireEventHandlers((EventPriority)((Object)priority), event);
            if (event.isCanceled()) {
                orig.setCancellationResult(event.getInteractionResult());
                orig.setCanceled(true);
            }
        }));
        events.registerEvent(PlayerLoginEvent.class, priority -> MinecraftForge.EVENT_BUS.addListener(ForgeBalmEvents.toForge(priority), orig -> {
            PlayerLoginEvent event = new PlayerLoginEvent((ServerPlayer)orig.getEntity());
            events.fireEventHandlers((EventPriority)((Object)priority), event);
        }));
        events.registerEvent(PlayerLogoutEvent.class, priority -> MinecraftForge.EVENT_BUS.addListener(ForgeBalmEvents.toForge(priority), orig -> {
            PlayerLogoutEvent event = new PlayerLogoutEvent((ServerPlayer)orig.getEntity());
            events.fireEventHandlers((EventPriority)((Object)priority), event);
        }));
        events.registerEvent(BreakBlockEvent.class, priority -> MinecraftForge.EVENT_BUS.addListener(ForgeBalmEvents.toForge(priority), orig -> {
            BlockEntity blockEntity = orig.getLevel().getBlockEntity(orig.getPos());
            BreakBlockEvent event = new BreakBlockEvent((Level)orig.getLevel(), orig.getPlayer(), orig.getPos(), orig.getState(), blockEntity);
            events.fireEventHandlers((EventPriority)((Object)priority), event);
            if (event.isCanceled()) {
                orig.setCanceled(true);
            }
        }));
        events.registerEvent(PlayerRespawnEvent.class, priority -> MinecraftForge.EVENT_BUS.addListener(ForgeBalmEvents.toForge(priority), orig -> {
            PlayerRespawnEvent event = new PlayerRespawnEvent((ServerPlayer)orig.getEntity(), (ServerPlayer)orig.getEntity());
            events.fireEventHandlers((EventPriority)((Object)priority), event);
        }));
        events.registerEvent(LivingFallEvent.class, priority -> MinecraftForge.EVENT_BUS.addListener(ForgeBalmEvents.toForge(priority), orig -> {
            LivingFallEvent event = new LivingFallEvent(orig.getEntity());
            events.fireEventHandlers((EventPriority)((Object)priority), event);
            if (event.getFallDamageOverride() != null) {
                orig.setDamageMultiplier(0.0f);
                event.getEntity().hurt(event.getEntity().level().damageSources().fall(), event.getFallDamageOverride().floatValue());
            }
            if (event.isCanceled()) {
                orig.setCanceled(true);
            }
        }));
        events.registerEvent(LivingDamageEvent.class, priority -> MinecraftForge.EVENT_BUS.addListener(ForgeBalmEvents.toForge(priority), orig -> {
            LivingDamageEvent event = new LivingDamageEvent(orig.getEntity(), orig.getSource(), orig.getAmount());
            events.fireEventHandlers((EventPriority)((Object)priority), event);
            orig.setAmount(event.getDamageAmount());
            if (event.isCanceled()) {
                orig.setCanceled(true);
            }
        }));
        events.registerEvent(CropGrowEvent.Pre.class, priority -> MinecraftForge.EVENT_BUS.addListener(ForgeBalmEvents.toForge(priority), orig -> {
            LevelAccessor patt0$temp = orig.getLevel();
            if (patt0$temp instanceof Level) {
                Level level = (Level)patt0$temp;
                CropGrowEvent.Pre event = new CropGrowEvent.Pre(level, orig.getPos(), orig.getState());
                events.fireEventHandlers((EventPriority)((Object)priority), event);
                if (event.isCanceled()) {
                    orig.setResult(Event.Result.DENY);
                }
            }
        }));
        events.registerEvent(CropGrowEvent.Post.class, priority -> MinecraftForge.EVENT_BUS.addListener(ForgeBalmEvents.toForge(priority), orig -> {
            LevelAccessor patt0$temp = orig.getLevel();
            if (patt0$temp instanceof Level) {
                Level level = (Level)patt0$temp;
                CropGrowEvent.Post event = new CropGrowEvent.Post(level, orig.getPos(), orig.getState());
                events.fireEventHandlers((EventPriority)((Object)priority), event);
            }
        }));
        events.registerEvent(ChunkTrackingEvent.Start.class, priority -> MinecraftForge.EVENT_BUS.addListener(ForgeBalmEvents.toForge(priority), orig -> {
            ChunkTrackingEvent.Start event = new ChunkTrackingEvent.Start(orig.getLevel(), orig.getPlayer(), orig.getPos());
            events.fireEventHandlers((EventPriority)((Object)priority), event);
        }));
        events.registerEvent(ChunkTrackingEvent.Stop.class, priority -> MinecraftForge.EVENT_BUS.addListener(ForgeBalmEvents.toForge(priority), orig -> {
            ChunkTrackingEvent.Stop event = new ChunkTrackingEvent.Stop(orig.getLevel(), orig.getPlayer(), orig.getPos());
            events.fireEventHandlers((EventPriority)((Object)priority), event);
        }));
        events.registerEvent(TossItemEvent.class, priority -> MinecraftForge.EVENT_BUS.addListener(ForgeBalmEvents.toForge(priority), orig -> {
            TossItemEvent event = new TossItemEvent(orig.getPlayer(), orig.getEntity().getItem());
            events.fireEventHandlers((EventPriority)((Object)priority), event);
            if (event.isCanceled()) {
                orig.setCanceled(true);
            }
        }));
        events.registerEvent(PlayerAttackEvent.class, priority -> MinecraftForge.EVENT_BUS.addListener(ForgeBalmEvents.toForge(priority), orig -> {
            PlayerAttackEvent event = new PlayerAttackEvent(orig.getEntity(), orig.getTarget());
            events.fireEventHandlers((EventPriority)((Object)priority), event);
            if (event.isCanceled()) {
                orig.setCanceled(true);
            }
        }));
        events.registerEvent(LivingHealEvent.class, priority -> MinecraftForge.EVENT_BUS.addListener(ForgeBalmEvents.toForge(priority), orig -> {
            LivingHealEvent event = new LivingHealEvent(orig.getEntity(), orig.getAmount());
            events.fireEventHandlers((EventPriority)((Object)priority), event);
            if (event.isCanceled()) {
                orig.setCanceled(true);
            }
        }));
        events.registerEvent(PlayerChangedDimensionEvent.class, priority -> MinecraftForge.EVENT_BUS.addListener(ForgeBalmEvents.toForge(priority), orig -> {
            PlayerChangedDimensionEvent event = new PlayerChangedDimensionEvent((ServerPlayer)orig.getEntity(), (ResourceKey<Level>)orig.getFrom(), (ResourceKey<Level>)orig.getTo());
            events.fireEventHandlers((EventPriority)((Object)priority), event);
        }));
        events.registerEvent(ItemCraftedEvent.class, priority -> MinecraftForge.EVENT_BUS.addListener(ForgeBalmEvents.toForge(priority), orig -> {
            ItemCraftedEvent event = new ItemCraftedEvent(orig.getEntity(), orig.getCrafting(), orig.getInventory());
            events.fireEventHandlers((EventPriority)((Object)priority), event);
        }));
        events.registerEvent(CommandEvent.class, priority -> MinecraftForge.EVENT_BUS.addListener(ForgeBalmEvents.toForge(priority), orig -> {
            CommandEvent event = new CommandEvent((ParseResults<CommandSourceStack>)orig.getParseResults());
            events.fireEventHandlers((EventPriority)((Object)priority), event);
            if (event.isCanceled()) {
                orig.setCanceled(true);
            }
        }));
        events.registerEvent(LivingDeathEvent.class, priority -> MinecraftForge.EVENT_BUS.addListener(ForgeBalmEvents.toForge(priority), orig -> {
            LivingDeathEvent event = new LivingDeathEvent(orig.getEntity(), orig.getSource());
            events.fireEventHandlers((EventPriority)((Object)priority), event);
            if (event.isCanceled()) {
                orig.setCanceled(true);
            }
        }));
        events.registerEvent(EntityAddedEvent.class, priority -> MinecraftForge.EVENT_BUS.addListener(ForgeBalmEvents.toForge(priority), orig -> {
            EntityAddedEvent event = new EntityAddedEvent(orig.getEntity(), orig.getLevel());
            events.fireEventHandlers((EventPriority)((Object)priority), event);
            if (event.isCanceled()) {
                orig.setCanceled(true);
            }
        }));
        events.registerEvent(ChunkLoadingEvent.Load.class, priority -> MinecraftForge.EVENT_BUS.addListener(ForgeBalmEvents.toForge(priority), orig -> {
            ChunkLoadingEvent.Load event = new ChunkLoadingEvent.Load(orig.getLevel(), orig.getChunk());
            events.fireEventHandlers((EventPriority)((Object)priority), event);
        }));
        events.registerEvent(ChunkLoadingEvent.Unload.class, priority -> MinecraftForge.EVENT_BUS.addListener(ForgeBalmEvents.toForge(priority), orig -> {
            ChunkLoadingEvent.Unload event = new ChunkLoadingEvent.Unload(orig.getLevel(), orig.getChunk());
            events.fireEventHandlers((EventPriority)((Object)priority), event);
        }));
        events.registerEvent(LevelLoadingEvent.Load.class, priority -> MinecraftForge.EVENT_BUS.addListener(ForgeBalmEvents.toForge(priority), orig -> {
            LevelLoadingEvent.Load event = new LevelLoadingEvent.Load(orig.getLevel());
            events.fireEventHandlers((EventPriority)((Object)priority), event);
        }));
        events.registerEvent(LevelLoadingEvent.Unload.class, priority -> MinecraftForge.EVENT_BUS.addListener(ForgeBalmEvents.toForge(priority), orig -> {
            LevelLoadingEvent.Unload event = new LevelLoadingEvent.Unload(orig.getLevel());
            events.fireEventHandlers((EventPriority)((Object)priority), event);
        }));
    }
}

