/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.api;

import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import net.blay09.mods.balm.api.BalmEnvironment;
import net.blay09.mods.balm.api.BalmHooks;
import net.blay09.mods.balm.api.BalmProxy;
import net.blay09.mods.balm.api.BalmRegistries;
import net.blay09.mods.balm.api.BalmRuntimeLoadContext;
import net.blay09.mods.balm.api.block.BalmBlockEntities;
import net.blay09.mods.balm.api.block.BalmBlocks;
import net.blay09.mods.balm.api.capability.BalmCapabilities;
import net.blay09.mods.balm.api.command.BalmCommands;
import net.blay09.mods.balm.api.compat.BalmModSupport;
import net.blay09.mods.balm.api.component.BalmComponents;
import net.blay09.mods.balm.api.config.BalmConfig;
import net.blay09.mods.balm.api.entity.BalmEntities;
import net.blay09.mods.balm.api.event.BalmEvents;
import net.blay09.mods.balm.api.item.BalmItems;
import net.blay09.mods.balm.api.loot.BalmLootTables;
import net.blay09.mods.balm.api.menu.BalmMenus;
import net.blay09.mods.balm.api.module.BalmModule;
import net.blay09.mods.balm.api.network.BalmNetworking;
import net.blay09.mods.balm.api.particle.BalmParticles;
import net.blay09.mods.balm.api.permission.BalmPermissions;
import net.blay09.mods.balm.api.proxy.ModProxy;
import net.blay09.mods.balm.api.proxy.PlatformProxy;
import net.blay09.mods.balm.api.proxy.SidedProxy;
import net.blay09.mods.balm.api.recipe.BalmRecipes;
import net.blay09.mods.balm.api.resources.BalmResources;
import net.blay09.mods.balm.api.resources.ModResource;
import net.blay09.mods.balm.api.resources.ModResourceVisitor;
import net.blay09.mods.balm.api.sound.BalmSounds;
import net.blay09.mods.balm.api.stats.BalmStats;
import net.blay09.mods.balm.api.world.BalmWorldGen;
import net.blay09.mods.balm.core.BalmRegistrar;
import net.blay09.mods.balm.core.BalmRegistrars;
import net.blay09.mods.balm.core.component.BalmDataComponentTypeRegistrar;
import net.blay09.mods.balm.core.particles.BalmParticleTypeRegistrar;
import net.blay09.mods.balm.loader.BalmPlatform;
import net.blay09.mods.balm.server.packs.resources.BalmResourceConditionRegistrar;
import net.blay09.mods.balm.server.packs.resources.BalmResourceReloadListenerRegistrar;
import net.blay09.mods.balm.stats.BalmCustomStatRegistrar;
import net.blay09.mods.balm.world.entity.BalmEntityTypeRegistrar;
import net.blay09.mods.balm.world.inventory.BalmMenuTypeRegistrar;
import net.blay09.mods.balm.world.item.BalmCreativeModeTabRegistrar;
import net.blay09.mods.balm.world.item.BalmItemRegistrar;
import net.blay09.mods.balm.world.item.crafting.BalmRecipeTypeRegistrar;
import net.blay09.mods.balm.world.level.block.BalmBlockRegistrar;
import net.blay09.mods.balm.world.level.block.entity.BalmBlockEntityTypeRegistrar;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;

public interface BalmRuntime<TLoadContext extends BalmRuntimeLoadContext> {
    public BalmConfig getConfig();

    public BalmEvents getEvents();

    public BalmWorldGen getWorldGen();

    @Deprecated
    default public BalmBlocks getBlocks() {
        return BalmBlocks.LEGACY;
    }

    @Deprecated
    default public BalmBlockEntities getBlockEntities() {
        return BalmBlockEntities.LEGACY;
    }

    @Deprecated
    default public BalmItems getItems() {
        return BalmItems.LEGACY;
    }

    @Deprecated
    default public BalmMenus getMenus() {
        return BalmMenus.LEGACY;
    }

    public void menuTypes(String var1, Consumer<BalmMenuTypeRegistrar> var2);

    @Deprecated
    public BalmMenuTypeRegistrar menuTypes(String var1);

    public BalmNetworking getNetworking();

    public BalmHooks getHooks();

    @Deprecated
    default public BalmRegistries getRegistries() {
        return BalmRegistries.LEGACY;
    }

    @Deprecated
    default public BalmSounds getSounds() {
        return BalmSounds.LEGACY;
    }

    @Deprecated
    default public BalmEntities getEntities() {
        return BalmEntities.LEGACY;
    }

    public void entityTypes(String var1, Consumer<BalmEntityTypeRegistrar> var2);

    @Deprecated
    public BalmEntityTypeRegistrar entityTypes(String var1);

    public BalmCapabilities getCapabilities();

    public BalmCommands getCommands();

    public BalmLootTables getLootTables();

    @Deprecated
    default public BalmStats getStats() {
        return BalmStats.LEGACY;
    }

    @Deprecated
    default public BalmRecipes getRecipes() {
        return BalmRecipes.LEGACY;
    }

    public BalmModSupport getModSupport();

    @Deprecated
    default public BalmParticles getParticles() {
        return BalmParticles.LEGACY;
    }

    public void particleTypes(String var1, Consumer<BalmParticleTypeRegistrar> var2);

    public void customStats(String var1, Consumer<BalmCustomStatRegistrar> var2);

    public BalmPermissions getPermissions();

    @Deprecated
    default public boolean isModLoaded(String modId) {
        return this.platform().isModLoaded(modId);
    }

    @Deprecated
    default public String getModName(String modId) {
        return this.platform().getModName(modId);
    }

    public <TProxy> SidedProxy<TProxy> sidedProxy(String var1, String var2);

    @Deprecated
    default public void initializeMod(String modId, TLoadContext context, Runnable initializer) {
        this.initializeMod(modId, context, (BalmRegistrars registrars) -> initializer.run());
    }

    public void initializeMod(String var1, TLoadContext var2, Consumer<BalmRegistrars> var3);

    public void initializeIfLoaded(String var1, String var2);

    @Deprecated
    default public void addServerReloadListener(ResourceLocation identifier, Function<HolderLookup.Provider, PreparableReloadListener> reloadListener) {
        this.resourceReloadListeners(identifier.getNamespace(), registrar -> registrar.register(identifier.getPath(), reloadListener));
    }

    @Deprecated
    default public void addServerReloadListener(ResourceLocation identifier, Consumer<ResourceManager> reloadListener) {
        this.resourceReloadListeners(identifier.getNamespace(), registrar -> registrar.register(identifier.getPath(), reloadListener));
    }

    @Deprecated
    default public BalmComponents getComponents() {
        return BalmComponents.LEGACY;
    }

    public <T> PlatformProxy<T> platformProxy();

    public <T> ModProxy<T> modProxy();

    @Deprecated
    default public String getPlatform() {
        return this.platform().name();
    }

    default public void initializeModule(BalmModule module) {
        String modId = module.getId().getNamespace();
        module.registerConfig(this.getConfig());
        module.registerResources(this.getResources());
        this.resourceConditions(modId, module::registerResourceConditions);
        module.registerAdditional(this.getRegistries());
        module.registerAdditional(this.registrar());
        module.registerComponents(this.getComponents());
        this.dataComponentTypes(modId, module::registerDataComponentTypes);
        module.registerBlocks(this.getBlocks().scoped(modId));
        this.blocks(modId, module::registerBlocks);
        module.registerBlockEntities(this.getBlockEntities());
        this.blockEntityTypes(modId, module::registerBlockEntityTypes);
        module.registerItems(this.getItems().scoped(modId));
        this.items(modId, module::registerItems);
        this.creativeModeTabs(modId, module::registerCreativeModeTabs);
        module.registerEntities(this.getEntities());
        this.entityTypes(modId, module::registerEntityTypes);
        module.registerWorldGen(this.getWorldGen());
        module.registerNetworking(this.getNetworking());
        module.registerMenus(this.getMenus());
        this.menuTypes(modId, module::registerMenuTypes);
        module.registerCapabilities(this.getCapabilities());
        module.registerCommands(this.getCommands());
        module.registerRecipes(this.getRecipes());
        this.recipeTypes(modId, module::registerRecipeTypes);
        module.registerLootTables(this.getLootTables());
        module.registerStats(this.getStats());
        this.customStats(modId, module::registerCustomStats);
        module.registerSounds(this.getSounds());
        module.registerSoundEvents(this.registrar().scoped(Registries.SOUND_EVENT, modId));
        module.registerPermissions(this.getPermissions());
        module.registerParticles(this.getParticles());
        this.particleTypes(modId, module::registerParticleTypes);
        this.resourceReloadListeners(modId, module::registerReloadListeners);
        module.registerEvents(this.getEvents());
        module.initialize();
    }

    public BalmProxy getProxy();

    public boolean isReady();

    public void onRuntimeAvailable(Runnable var1);

    @Deprecated
    default public void registerModule(BalmModule module) {
        this.registerModule(new BalmRegistrars(this), module);
    }

    public void registerModule(BalmRegistrars var1, BalmModule var2);

    @Deprecated
    default public BalmResources getResources() {
        return BalmResources.LEGACY;
    }

    @Deprecated
    default public BalmEnvironment getEnvironment() {
        return this.platform().physicalSide();
    }

    @Deprecated
    default public boolean isDevelopmentEnvironment() {
        return this.platform().isDevelopmentEnvironment();
    }

    @Deprecated
    default public List<String> getLoadedPrimaryModIds() {
        return this.platform().loadedPrimaryModIds();
    }

    @Deprecated
    default public void visitModResources(String modId, String path, ModResourceVisitor visitor) {
        this.platform().visitModResources(modId, path, visitor);
    }

    @Deprecated
    default public Optional<ModResource> lookupModResource(String modId, String path) {
        return this.platform().lookupModResource(modId, path);
    }

    public BalmRegistrar registrar();

    default public <T> BalmRegistrar.Scoped<T> registrar(ResourceKey<? extends Registry<T>> registryKey, String namespace) {
        return this.registrar().scoped(registryKey, namespace);
    }

    public void blocks(String var1, Consumer<BalmBlockRegistrar> var2);

    public void items(String var1, Consumer<BalmItemRegistrar> var2);

    public void recipeTypes(String var1, Consumer<BalmRecipeTypeRegistrar> var2);

    @Deprecated
    public BalmRecipeTypeRegistrar recipeTypes(String var1);

    public void dataComponentTypes(String var1, Consumer<BalmDataComponentTypeRegistrar> var2);

    @Deprecated
    public BalmCreativeModeTabRegistrar creativeModeTabs(String var1);

    public void creativeModeTabs(String var1, Consumer<BalmCreativeModeTabRegistrar> var2);

    @Deprecated
    public BalmBlockEntityTypeRegistrar blockEntityTypes(String var1);

    default public void blockEntityTypes(String namespace, Consumer<BalmBlockEntityTypeRegistrar> initializer) {
        initializer.accept(this.blockEntityTypes(namespace));
    }

    public BalmPlatform platform();

    public void resourceReloadListeners(String var1, Consumer<BalmResourceReloadListenerRegistrar> var2);

    public void resourceConditions(String var1, Consumer<BalmResourceConditionRegistrar> var2);

    @Deprecated
    public BalmParticleTypeRegistrar particleTypes(String var1);
}

