/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.neoforge.world;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.MapCodec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import net.blay09.mods.balm.api.DeferredObject;
import net.blay09.mods.balm.api.world.BalmWorldGen;
import net.blay09.mods.balm.api.world.BiomeModifier;
import net.blay09.mods.balm.api.world.BiomePredicate;
import net.blay09.mods.balm.neoforge.DeferredRegisters;
import net.blay09.mods.balm.neoforge.world.BalmBiomeModifier;
import net.blay09.mods.balm.neoforge.world.NeoForgeBiomeModificationBuilder;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.common.world.ModifiableBiomeInfo;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

public class NeoForgeBalmWorldGen
implements BalmWorldGen {
    public static final MapCodec<BalmBiomeModifier> BALM_BIOME_MODIFIER_CODEC = MapCodec.unit((Object)BalmBiomeModifier.INSTANCE);
    private static final List<Pair<BiomePredicate, BiomeModifier>> biomeModifiers = Collections.synchronizedList(new ArrayList());

    public static void initializeBalmBiomeModifiers(IEventBus modBus) {
        DeferredRegister registry = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIER_SERIALIZERS, (String)"balm");
        registry.register("balm", () -> BALM_BIOME_MODIFIER_CODEC);
        registry.register(modBus);
    }

    @Override
    public <T extends Feature<?>> DeferredObject<T> registerFeature(ResourceLocation identifier, Supplier<T> supplier) {
        DeferredRegister register = DeferredRegisters.get(Registries.FEATURE, identifier.getNamespace());
        DeferredHolder registryObject = register.register(identifier.getPath(), supplier);
        return new DeferredObject(identifier, registryObject, () -> ((DeferredHolder)registryObject).isBound());
    }

    @Override
    public <T extends PlacementModifierType<?>> DeferredObject<T> registerPlacementModifier(ResourceLocation identifier, Supplier<T> supplier) {
        DeferredRegister register = DeferredRegisters.get(Registries.PLACEMENT_MODIFIER_TYPE, identifier.getNamespace());
        DeferredHolder registryObject = register.register(identifier.getPath(), supplier);
        return new DeferredObject(identifier, registryObject, () -> ((DeferredHolder)registryObject).isBound());
    }

    @Override
    public <T extends PoiType> DeferredObject<T> registerPoiType(ResourceLocation identifier, Supplier<T> supplier) {
        DeferredRegister register = DeferredRegisters.get(Registries.POINT_OF_INTEREST_TYPE, identifier.getNamespace());
        DeferredHolder registryObject = register.register(identifier.getPath(), supplier);
        return new DeferredObject(identifier, registryObject, () -> ((DeferredHolder)registryObject).isBound());
    }

    @Override
    public void modifyBiome(ResourceLocation id, BiomePredicate predicate, BiomeModifier modifier) {
        biomeModifiers.add((Pair<BiomePredicate, BiomeModifier>)Pair.of((Object)predicate, (Object)modifier));
    }

    public void modifyBiome(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
        if (phase == BiomeModifier.Phase.ADD) {
            NeoForgeBiomeModificationBuilder modificationBuilder = new NeoForgeBiomeModificationBuilder(builder);
            for (Pair<BiomePredicate, BiomeModifier> biomeModifierPair : biomeModifiers) {
                if (!((BiomePredicate)biomeModifierPair.getFirst()).test(biome)) continue;
                ((BiomeModifier)biomeModifierPair.getSecond()).modifyBiome(biome, modificationBuilder);
            }
        }
    }
}

