/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.forge.client.rendering;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.blay09.mods.balm.api.DeferredObject;
import net.blay09.mods.balm.api.client.rendering.BalmModels;
import net.blay09.mods.balm.common.NamespaceResolver;
import net.blay09.mods.balm.common.StaticNamespaceResolver;
import net.blay09.mods.balm.forge.ModBusEventRegister;
import net.blay09.mods.balm.forge.ModBusEventRegisters;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.eventbus.api.bus.BusGroup;

public record ForgeBalmModels(NamespaceResolver namespaceResolver) implements BalmModels
{
    @Override
    public DeferredObject<BlockStateModel> loadModel(final ResourceLocation identifier) {
        final Registrations registrations = this.getActiveRegistrations();
        DeferredObject<BlockStateModel> deferredModel = new DeferredObject<BlockStateModel>(this, identifier){

            @Override
            public BlockStateModel resolve() {
                ModelManager modelManager = Minecraft.getInstance().getModelManager();
                StateDefinition<Block, BlockState> stateDefinition = registrations.extraStateDefinitions.get(identifier);
                return modelManager.getBlockModelShaper().getBlockModel((BlockState)stateDefinition.any());
            }

            @Override
            public boolean canResolve() {
                return registrations.extraStateDefinitions.containsKey(identifier);
            }
        };
        registrations.extraModels.add(identifier);
        return deferredModel;
    }

    private Registrations getActiveRegistrations() {
        return ModBusEventRegisters.getRegistrations(this.namespaceResolver.getDefaultNamespace(), Registrations.class);
    }

    @Override
    public BalmModels scoped(String modId) {
        return new ForgeBalmModels(new StaticNamespaceResolver(modId));
    }

    public static class Registrations
    implements ModBusEventRegister {
        public final List<ResourceLocation> extraModels = new ArrayList<ResourceLocation>();
        public final Map<ResourceLocation, StateDefinition<Block, BlockState>> extraStateDefinitions = new HashMap<ResourceLocation, StateDefinition<Block, BlockState>>();

        private void onRegisterAdditionalModels(ModelEvent.RegisterModelStateDefinitions event) {
            this.extraModels.forEach(it -> {
                StateDefinition stateDefinition = new StateDefinition.Builder((Object)Blocks.AIR).create(Block::defaultBlockState, BlockState::new);
                event.register(it, stateDefinition);
                this.extraStateDefinitions.put((ResourceLocation)it, (StateDefinition<Block, BlockState>)stateDefinition);
            });
        }

        @Override
        public void register(BusGroup busGroup) {
            ModelEvent.RegisterModelStateDefinitions.BUS.addListener(this::onRegisterAdditionalModels);
        }
    }
}

