/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.forge.event;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.blay09.mods.balm.api.event.BalmEvents;
import net.blay09.mods.balm.api.event.EventPriority;
import net.blay09.mods.balm.api.event.TickPhase;
import net.blay09.mods.balm.api.event.TickType;
import org.jetbrains.annotations.Nullable;

public class ForgeBalmEvents
implements BalmEvents {
    private final Table<Class<?>, EventPriority, Consumer<EventPriority>> eventInitializers = HashBasedTable.create();
    private final Map<Class<?>, Consumer<?>> eventDispatchers = new HashMap();
    private final Table<Class<?>, EventPriority, List<Consumer<?>>> eventHandlers = HashBasedTable.create();
    private final Table<TickType<?>, TickPhase, Consumer<?>> tickEventInitializers = HashBasedTable.create();

    public static byte toForge(EventPriority priority) {
        return switch (priority) {
            default -> throw new MatchException(null, null);
            case EventPriority.Lowest -> -127;
            case EventPriority.Low -> -64;
            case EventPriority.Normal -> 0;
            case EventPriority.High -> 64;
            case EventPriority.Highest -> 127;
        };
    }

    public void registerEvent(Class<?> eventClass, Consumer<EventPriority> initializer) {
        this.registerEvent(eventClass, initializer, null);
    }

    public void registerEvent(Class<?> eventClass, Consumer<EventPriority> initializer, @Nullable Consumer<?> dispatcher) {
        for (EventPriority priority : EventPriority.values()) {
            this.eventInitializers.put(eventClass, (Object)priority, initializer);
        }
        if (dispatcher != null) {
            this.eventDispatchers.put(eventClass, dispatcher);
        }
    }

    public <T> void fireEventHandlers(EventPriority priority, T event) {
        List handlers = (List)this.eventHandlers.get(event.getClass(), (Object)priority);
        if (handlers != null) {
            handlers.forEach(handler -> this.fireEventHandler((Consumer)handler, event));
        }
    }

    private <T> void fireEventHandler(Consumer<T> handler, Object event) {
        handler.accept(event);
    }

    @Override
    public <T> void onEvent(Class<T> eventClass, Consumer<T> handler, EventPriority priority) {
        ArrayList<Consumer<T>> consumers;
        Consumer initializer = (Consumer)this.eventInitializers.remove(eventClass, (Object)priority);
        if (initializer != null) {
            initializer.accept(priority);
        }
        if ((consumers = (ArrayList<Consumer<T>>)this.eventHandlers.get(eventClass, (Object)priority)) == null) {
            consumers = new ArrayList<Consumer<T>>();
            this.eventHandlers.put(eventClass, (Object)priority, consumers);
        }
        consumers.add(handler);
    }

    @Override
    public <T> void fireEvent(T event) {
        Consumer<?> handler = this.eventDispatchers.get(event.getClass());
        if (handler != null) {
            handler.accept(event);
        } else {
            for (EventPriority priority : EventPriority.values) {
                this.fireEventHandlers(priority, event);
            }
        }
    }

    @Override
    public <T> void onTickEvent(TickType<T> type, TickPhase phase, T handler) {
        Consumer initializer = (Consumer)this.tickEventInitializers.get(type, (Object)phase);
        initializer.accept(handler);
    }

    public <T> void registerTickEvent(TickType<?> type, TickPhase phase, Consumer<T> initializer) {
        this.tickEventInitializers.put(type, (Object)phase, initializer);
    }
}

