/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.forge.network;

import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.ChannelBuilder;
import net.minecraftforge.network.SimpleChannel;

public class NetworkChannels {
    private static final Map<String, SimpleChannel> channels = new ConcurrentHashMap<String, SimpleChannel>();
    private static final Map<String, Integer> networkVersions = new ConcurrentHashMap<String, Integer>();
    private static final Set<String> clientOnlyMods = Sets.newConcurrentHashSet();
    private static final Set<String> serverOnlyMods = Sets.newConcurrentHashSet();

    public static SimpleChannel get(String modId) {
        return channels.computeIfAbsent(modId, key -> {
            ResourceLocation channelName = ResourceLocation.fromNamespaceAndPath((String)key, (String)"network");
            ChannelBuilder builder = ChannelBuilder.named((ResourceLocation)channelName);
            Integer networkVersion = networkVersions.get(modId);
            if (networkVersion != null) {
                builder = builder.networkProtocolVersion(networkVersion.intValue());
            }
            if (serverOnlyMods.contains(modId)) {
                builder = builder.optionalClient();
            }
            if (clientOnlyMods.contains(modId)) {
                builder = builder.optionalServer();
            }
            return builder.simpleChannel();
        });
    }

    public static void allowClientOnly(String modId) {
        clientOnlyMods.add(modId);
    }

    public static void allowServerOnly(String modId) {
        serverOnlyMods.add(modId);
    }

    public static void defineNetworkVersion(String modId, String version) {
        try {
            int networkVersion = Integer.parseInt(version);
            networkVersions.put(modId, networkVersion);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("Invalid network version for mod " + modId + ": Versions must be integers for Forge compatibility.");
        }
    }
}

