/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import net.minecraft.class_5819;

public interface NumberProvider {
    public static final Map<String, MapCodec<? extends NumberProvider>> CODECS = Map.of("constant", Constant.CODEC, "uniform", Uniform.CODEC);
    public static final Codec<NumberProvider> CODEC = Codec.STRING.dispatch(NumberProvider::type, CODECS::get);

    public static Constant constant(float value) {
        return new Constant(value);
    }

    public static Uniform uniform(float min, float max) {
        return new Uniform(min, max);
    }

    public float getFloat(class_5819 var1);

    default public int getInt(class_5819 random) {
        return Math.round(this.getFloat(random));
    }

    public String type();

    public MapCodec<? extends NumberProvider> codec();

    public record Constant(float value) implements NumberProvider
    {
        public static MapCodec<Constant> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.FLOAT.fieldOf("value").forGetter(Constant::value)).apply((Applicative)instance, Constant::new));

        @Override
        public float getFloat(class_5819 random) {
            return this.value;
        }

        @Override
        public String type() {
            return "constant";
        }

        @Override
        public MapCodec<? extends NumberProvider> codec() {
            return CODEC;
        }

        public Constant mul(float scale) {
            return new Constant(this.value * scale);
        }
    }

    public record Uniform(float min, float max) implements NumberProvider
    {
        public static MapCodec<Uniform> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.FLOAT.fieldOf("min").forGetter(Uniform::min), (App)Codec.FLOAT.fieldOf("max").forGetter(Uniform::max)).apply((Applicative)instance, Uniform::new));

        @Override
        public float getFloat(class_5819 random) {
            return this.min + random.method_43057() * (this.max - this.min);
        }

        @Override
        public String type() {
            return "uniform";
        }

        @Override
        public MapCodec<? extends NumberProvider> codec() {
            return CODEC;
        }

        public Uniform mul(float scale) {
            return this.mul(scale, scale);
        }

        public Uniform mul(float minScale, float maxScale) {
            return new Uniform(this.min * minScale, this.max * maxScale);
        }
    }
}

