/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.neoforge.client;

import java.util.ArrayList;
import java.util.List;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.client.keymappings.BalmKeyMappings;
import net.blay09.mods.balm.api.client.rendering.BalmModels;
import net.blay09.mods.balm.api.client.rendering.BalmRenderers;
import net.blay09.mods.balm.api.client.screen.BalmScreens;
import net.blay09.mods.balm.common.BalmLoadContexts;
import net.blay09.mods.balm.common.LegacyNamespaceResolver;
import net.blay09.mods.balm.common.NamespaceResolver;
import net.blay09.mods.balm.common.client.CommonBalmClientRuntime;
import net.blay09.mods.balm.neoforge.ModBusEventRegisters;
import net.blay09.mods.balm.neoforge.NeoForgeLoadContext;
import net.blay09.mods.balm.neoforge.client.keymappings.NeoForgeBalmKeyMappings;
import net.blay09.mods.balm.neoforge.client.rendering.NeoForgeBalmModels;
import net.blay09.mods.balm.neoforge.client.rendering.NeoForgeBalmRenderers;
import net.blay09.mods.balm.neoforge.client.screen.NeoForgeBalmScreens;
import net.blay09.mods.balm.neoforge.event.NeoForgeBalmClientEvents;
import net.blay09.mods.balm.neoforge.event.NeoForgeBalmEvents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.neoforge.client.event.AddClientReloadListenersEvent;

public class NeoForgeBalmClientRuntime
extends CommonBalmClientRuntime<NeoForgeLoadContext> {
    private final NamespaceResolver legacyNamespaceResolver = new LegacyNamespaceResolver(() -> ModLoadingContext.get().getActiveNamespace());
    private final BalmRenderers renderers = new NeoForgeBalmRenderers(this.legacyNamespaceResolver);
    private final BalmScreens screens = new NeoForgeBalmScreens(this.legacyNamespaceResolver);
    private final BalmKeyMappings keyMappings = new NeoForgeBalmKeyMappings(this.legacyNamespaceResolver);
    private final BalmModels models = new NeoForgeBalmModels(this.legacyNamespaceResolver);

    public NeoForgeBalmClientRuntime() {
        NeoForgeBalmClientEvents.registerEvents((NeoForgeBalmEvents)Balm.getEvents());
    }

    @Override
    public BalmRenderers getRenderers() {
        return this.renderers;
    }

    @Override
    public BalmScreens getScreens() {
        return this.screens;
    }

    @Override
    public BalmModels getModels() {
        return this.models;
    }

    @Override
    public BalmKeyMappings getKeyMappings() {
        return this.keyMappings;
    }

    @Override
    public void initializeMod(String modId, NeoForgeLoadContext context, Runnable initializer) {
        BalmLoadContexts.register(modId, context);
        initializer.run();
        IEventBus modEventBus = context.modBus();
        ModBusEventRegisters.register(modId, modEventBus);
    }

    @Override
    public void addResourceReloadListener(ResourceLocation identifier, PreparableReloadListener reloadListener) {
        this.getActiveRegistrations().reloadListeners.add(new ReloadListenerRegistration(identifier, reloadListener));
    }

    private Registrations getActiveRegistrations() {
        return ModBusEventRegisters.getRegistrations(this.legacyNamespaceResolver.getDefaultNamespace(), Registrations.class);
    }

    public static class Registrations {
        public final List<ReloadListenerRegistration> reloadListeners = new ArrayList<ReloadListenerRegistration>();

        @SubscribeEvent
        public void addClientReloadListeners(AddClientReloadListenersEvent event) {
            for (ReloadListenerRegistration reloadListener : this.reloadListeners) {
                event.addListener(reloadListener.identifier(), reloadListener.listener());
            }
        }
    }

    public record ReloadListenerRegistration(ResourceLocation identifier, PreparableReloadListener listener) {
    }
}

