/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.neoforge.energy;

import net.blay09.mods.balm.api.energy.EnergyStorage;
import net.neoforged.neoforge.transfer.energy.EnergyHandler;
import net.neoforged.neoforge.transfer.transaction.SnapshotJournal;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;

public final class NeoForgeEnergyStorage
implements EnergyHandler {
    private final EnergyStorage energyStorage;
    private final EnergyJournal energyJournal = new EnergyJournal();

    public NeoForgeEnergyStorage(EnergyStorage energyStorage) {
        this.energyStorage = energyStorage;
    }

    public long getAmountAsLong() {
        return this.energyStorage.getEnergy();
    }

    public long getCapacityAsLong() {
        return this.energyStorage.getCapacity();
    }

    public int insert(int amount, TransactionContext context) {
        this.energyJournal.updateSnapshots(context);
        return this.energyStorage.fill(amount, false);
    }

    public int extract(int amount, TransactionContext context) {
        this.energyJournal.updateSnapshots(context);
        return this.energyStorage.drain(amount, false);
    }

    private class EnergyJournal
    extends SnapshotJournal<Integer> {
        private EnergyJournal() {
        }

        protected Integer createSnapshot() {
            return NeoForgeEnergyStorage.this.energyStorage.getEnergy();
        }

        protected void revertToSnapshot(Integer snapshot) {
            NeoForgeEnergyStorage.this.energyStorage.setEnergy(snapshot);
        }
    }
}

