/*
 * Decompiled with CFR 0.152.
 */
package net.sashakyotoz.common.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerWorldEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;
import net.sashakyotoz.UnseenWorld;
import net.sashakyotoz.common.config.ConfigEntries;
import net.sashakyotoz.common.config.WorldConfigController;
import net.sashakyotoz.common.items.custom.ChimericRockbreakerHammerItem;
import net.sashakyotoz.common.items.custom.EclipsebaneItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigController
implements ServerWorldEvents.Load {
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private static List<DataItem> DATA_LIST;
    public static Map CONFIG;

    public void onWorldLoad(MinecraftServer server, class_3218 world) {
        WorldConfigController.data.put(0, WorldConfigController.loadData(world));
        DATA_LIST = ConfigController.loadGrippingManaConfig();
    }

    public static List<DataItem> getDataList() {
        return Objects.requireNonNullElseGet(DATA_LIST, List::of);
    }

    public static List<DataItem> loadGrippingManaConfig() {
        try {
            Path configPath = FabricLoader.getInstance().getConfigDir().resolve("unseen_world/uw-compatibility-config.json");
            if (!Files.exists(configPath, new LinkOption[0])) {
                Files.createDirectories(configPath.getParent(), new FileAttribute[0]);
                Files.writeString(configPath, (CharSequence)ConfigController.getCompatibilityConfig(), new OpenOption[0]);
            }
            String json = Files.readString(configPath);
            ModConfig config = (ModConfig)gson.fromJson(json, ModConfig.class);
            ArrayList<DataItem> spellItems = new ArrayList<DataItem>();
            for (ModEntry modEntry : config.entries()) {
                for (ItemEntry itemEntry : modEntry.items()) {
                    class_2960 itemIdentifier = new class_2960(modEntry.modId(), itemEntry.itemId());
                    class_1792 item = (class_1792)class_7923.field_41178.method_10223(itemIdentifier);
                    DataItem spellItem = ConfigController.getDataItem(modEntry, itemEntry, item);
                    spellItems.add(spellItem);
                }
            }
            UnseenWorld.log("Loaded %s compatibility-config".formatted("unseen_world"));
            return spellItems;
        }
        catch (Exception e) {
            return List.of();
        }
    }

    public static void loadConfig() {
        try {
            Path configPath = FabricLoader.getInstance().getConfigDir().resolve("unseen_world/uw-config.json");
            if (!Files.exists(configPath, new LinkOption[0])) {
                Files.createDirectories(configPath.getParent(), new FileAttribute[0]);
                Files.writeString(configPath, (CharSequence)ConfigController.getEntriesConfig(), new OpenOption[0]);
            }
            String json = Files.readString(configPath);
            CONFIG = (Map)gson.fromJson(json, Map.class);
            ConfigEntries.reload();
        }
        catch (Exception e) {
            UnseenWorld.log("Failed to load %s config".formatted("unseen_world"));
        }
    }

    @NotNull
    private static DataItem getDataItem(ModEntry modEntry, ItemEntry itemEntry, class_1792 item) {
        class_2960 spellIconIdentifier = new class_2960(itemEntry.spellIcon());
        DataItem dataItem = itemEntry.compatibilityType.equals(Type.EFFECT_REMOVER.type) && itemEntry.effectToRemove() != null ? new DataItem(item, itemEntry.compatibilityType(), spellIconIdentifier, itemEntry.manaCost(), new class_2960(modEntry.modId(), itemEntry.effectToRemove()), null) : new DataItem(item, itemEntry.compatibilityType(), spellIconIdentifier, itemEntry.manaCost(), null, itemEntry.actionToPerform());
        return dataItem;
    }

    public static DataItem getDataToStack(class_1799 stack) {
        if (stack.method_31574(class_1802.field_8162)) {
            return null;
        }
        if (ConfigController.getDataList().stream().anyMatch(data -> data.item().equals(stack.method_7909()))) {
            return ConfigController.getDataList().stream().filter(data -> data.item().equals(stack.method_7909())).findAny().get();
        }
        return null;
    }

    private static String getCompatibilityConfig() {
        return "{\n   \"entries\": [\n     {\n       \"modId\": \"sortilege\",\n       \"items\": [\n         {\n           \"itemId\": \"gripcrystal_staff\",\n           \"compatibilityType\": \"spell\",\n           \"spellIcon\": \"unseen_world:textures/gui/gripcrystal_abilities/staff_aura.png\",\n           \"manaCost\": 6,\n           \"actionToPerform\": [\n             \"/execute at @s run summon area_effect_cloud ~ ~ ~ {Particle:\\\"unseen_world:gripping_crystal\\\",Color:2333625,Radius:3,RadiusPerTick:-0.2,Duration:60,Effects:[{Duration:80,ShowParticles:1b,ShowIcon:1}]}\",\n             \"/execute at @s run effect give @e[distance=..9,type=!minecraft:player] minecraft:weakness 5 2 true\",\n             \"/execute at @s run effect give @e[distance=..6,type=!minecraft:player] minecraft:levitation 4 2 true\",\n             \"/execute at @s run tp @e[distance=..6,type=!minecraft:player] ^ ^ ^5\",\n             \"damageAll _8_5\",\n             \"/playsound minecraft:block.amethyst_block.break player @p ~ ~ ~ 2 1.5\"\n           ]\n         },\n         {\n           \"itemId\": \"netherite_staff\",\n           \"compatibilityType\": \"spell\",\n           \"spellIcon\": \"unseen_world:textures/gui/gripcrystal_abilities/staff_aura.png\",\n           \"manaCost\": 2,\n           \"actionToPerform\": [\n             \"/execute at @s run summon area_effect_cloud ~ ~ ~ {Particle:\\\"unseen_world:gripping_crystal\\\",Color:2333625,Radius:3,RadiusPerTick:-0.2,Duration:60,Effects:[{Duration:80,ShowParticles:1b,ShowIcon:1}]}\",\n             \"/execute at @s run effect give @e[distance=..9,type=!minecraft:player] minecraft:weakness 5 2 true\",\n             \"/execute at @s run tp @e[distance=..6,type=!minecraft:player] ^ ^ ^3\",\n             \"damageAll _7_4\",\n             \"/playsound minecraft:block.amethyst_block.break player @p ~ ~ ~ 2 1.25\"\n           ]\n         }\n       ]\n     },\n     {\n       \"modId\": \"minecells\",\n       \"items\": [\n         {\n           \"itemId\": \"cursed_sword\",\n           \"compatibilityType\": \"effect_remover\",\n           \"spellIcon\": \"unseen_world:textures/gui/gripcrystal_abilities/gripcrystal_shield.png\",\n           \"manaCost\": 1,\n           \"effectToRemove\": \"cursed\"\n         }\n       ]\n     },\n     {\n       \"modId\": \"deeperdarker\",\n       \"items\": [\n         {\n           \"itemId\": \"sonorous_staff\",\n           \"compatibilityType\": \"spell\",\n           \"spellIcon\": \"unseen_world:textures/gui/gripcrystal_abilities/sonorous_whirlwind.png\",\n           \"manaCost\": 4,\n           \"actionToPerform\": [\n             \"/execute at @s anchored eyes run particle minecraft:sonic_boom ^ ^ ^5\",\n             \"/execute at @s anchored eyes run particle minecraft:sonic_boom ^5 ^ ^\",\n             \"/execute at @s anchored eyes run particle minecraft:sonic_boom ^-5 ^ ^\",\n             \"/execute at @s anchored eyes run particle minecraft:sonic_boom ^ ^ ^-5\",\n             \"damageAll _8_5\",\n             \"/playsound minecraft:block.sculk_shrieker.break player @p ~ ~ ~ 2 1.5\"\n           ]\n         }\n       ]\n     }\n   ]\n }\n";
    }

    private static String getEntriesConfig() {
        return "{\n    \"mobs\":{\n        \"animate_death_for_mobs\": true,\n        \"render_gripping_on_mobs\": true,\n        \"spawn_gripping_particles\": true,\n        \"remove_gripping_naturally\": true,\n        \"violeger_patrol_spawns_in\": 9000\n    },\n    \"gameplay\":{\n        \"do_abyssal_armor_save_from_void\": true,\n        \"key_handler_block_cooldown\": 24000,\n        \"x_gripping_mana_texture_offset\": 0,\n        \"y_gripping_mana_texture_offset\": 0\n    },\n    \"technic\":{\n        \"do_logging_only_in_dev\": true\n    }\n}\n";
    }

    public static boolean canHandleGripcrystalAbility(class_1799 stack) {
        ChimericRockbreakerHammerItem hammerItem;
        EclipsebaneItem eclipsebaneItem;
        class_1792 class_17922 = stack.method_7909();
        return class_17922 instanceof EclipsebaneItem && (eclipsebaneItem = (EclipsebaneItem)class_17922).getItemPhase(stack).equals("light_ray") || (class_17922 = stack.method_7909()) instanceof ChimericRockbreakerHammerItem && (hammerItem = (ChimericRockbreakerHammerItem)class_17922).getItemPhase(stack).equals("heavy_winding") || ConfigController.getDataToStack(stack) != null;
    }

    public static List<Integer> getIntegers(String s) {
        ArrayList<Integer> ints = new ArrayList<Integer>();
        Pattern pattern = Pattern.compile("_(\\d+)");
        Matcher matcher = pattern.matcher(s);
        while (matcher.find()) {
            ints.add(Integer.valueOf(matcher.group(1)));
            if (ints.size() < 2) continue;
            break;
        }
        return ints;
    }

    static {
        CONFIG = new TreeMap();
    }

    public record ModConfig(List<ModEntry> entries) {
    }

    public record ModEntry(String modId, List<ItemEntry> items) {
    }

    public record ItemEntry(String itemId, String compatibilityType, String spellIcon, int manaCost, @Nullable String effectToRemove, @Nullable List<String> actionToPerform) {
    }

    public record DataItem(class_1792 item, String compatibilityType, class_2960 spellIcon, int manaCost, @Nullable class_2960 effectToRemove, @Nullable List<String> actionToPerform) {
    }

    public static enum Type {
        SPELL("spell"),
        EFFECT_REMOVER("effect_remover");

        public final String type;

        private Type(String type) {
            this.type = type;
        }
    }
}

