/*
 * Decompiled with CFR 0.152.
 */
package net.sashakyotoz.common.config;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import net.minecraft.class_3218;
import net.minecraft.class_5218;
import net.sashakyotoz.UnseenWorld;
import net.sashakyotoz.common.config.ChimericDarknessData;

public class WorldConfigController {
    private static final Gson gson = new Gson();
    public static final HashMap<Integer, ChimericDarknessData> data = new HashMap();

    public static ChimericDarknessData loadData(class_3218 world) {
        Path pathToWorld = world.method_8503().method_27050(class_5218.field_24188).resolve("chimeric_darkness_controller.json");
        if (Files.exists(pathToWorld, new LinkOption[0])) {
            try {
                String jsonString = new String(Files.readAllBytes(pathToWorld));
                JsonObject jsonObject = JsonParser.parseString((String)jsonString).getAsJsonObject();
                if (jsonObject != null) {
                    return new ChimericDarknessData(jsonObject.get("are_stars_liberated").getAsBoolean(), jsonObject.get("are_sun_liberated").getAsBoolean(), jsonObject.get("are_galactic_liberated").getAsBoolean());
                }
                WorldConfigController.createController(world);
            }
            catch (IOException e) {
                WorldConfigController.createController(world);
            }
        } else {
            WorldConfigController.createController(world);
        }
        return null;
    }

    public static void updateSave(class_3218 world) {
        data.put(0, WorldConfigController.loadData(world));
    }

    public static void saveController(class_3218 world, boolean starsUnlock, boolean sunUnlock, boolean galacticUnlock) {
        Path pathToWorld = world.method_8503().method_27050(class_5218.field_24188);
        try {
            if (!Files.exists(pathToWorld, new LinkOption[0])) {
                WorldConfigController.createController(world);
            }
            Path dataFile = pathToWorld.resolve("chimeric_darkness_controller.json");
            JsonObject mainObject = new JsonObject();
            mainObject.addProperty("are_stars_liberated", Boolean.valueOf(starsUnlock));
            mainObject.addProperty("are_sun_liberated", Boolean.valueOf(sunUnlock));
            mainObject.addProperty("are_galactic_liberated", Boolean.valueOf(galacticUnlock));
            Files.write(dataFile, gson.toJson((JsonElement)mainObject).getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            WorldConfigController.createController(world);
        }
    }

    public static void createController(class_3218 world) {
        Path pathToWorld = world.method_8503().method_27050(class_5218.field_24188);
        try {
            if (!Files.exists(pathToWorld, new LinkOption[0])) {
                Files.createDirectories(pathToWorld, new FileAttribute[0]);
            }
            Path dataFile = pathToWorld.resolve("chimeric_darkness_controller.json");
            JsonObject mainObject = new JsonObject();
            mainObject.addProperty("are_stars_liberated", Boolean.valueOf(false));
            mainObject.addProperty("are_sun_liberated", Boolean.valueOf(false));
            mainObject.addProperty("are_galactic_liberated", Boolean.valueOf(false));
            Files.write(dataFile, gson.toJson((JsonElement)mainObject).getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            UnseenWorld.log("Failed to create chimeric_darkness_controller.json");
        }
    }
}

