/*
 * Decompiled with CFR 0.152.
 */
package net.sashakyotoz.common.entities.bosses;

import java.util.List;
import net.minecraft.class_1259;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1400;
import net.minecraft.class_1409;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2604;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2945;
import net.minecraft.class_3213;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5709;
import net.minecraft.class_5716;
import net.minecraft.class_7094;
import net.minecraft.class_8111;
import net.sashakyotoz.api.entity_data.IGrippingEntity;
import net.sashakyotoz.api.entity_data.data.GrippingData;
import net.sashakyotoz.api.multipart_entity.EntityPart;
import net.sashakyotoz.api.multipart_entity.MultipartEntity;
import net.sashakyotoz.client.particles.custom.effects.WindVibrationParticleEffect;
import net.sashakyotoz.common.blocks.ModBlocks;
import net.sashakyotoz.common.config.ChimericDarknessData;
import net.sashakyotoz.common.config.WorldConfigController;
import net.sashakyotoz.common.entities.ai.bosses_goals.WarriorMovementGoal;
import net.sashakyotoz.common.entities.bosses.BossLikePathfinderMob;
import net.sashakyotoz.common.entities.bosses.parts.WarriorPartEntity;
import net.sashakyotoz.utils.ActionsUtils;

public class WarriorOfChimericDarkness
extends BossLikePathfinderMob
implements MultipartEntity {
    public final class_7094 spawn = new class_7094();
    public final class_7094 death = new class_7094();
    public final class_7094 dash = new class_7094();
    public final class_7094 hammerAttack = new class_7094();
    public final class_7094 shieldStriking = new class_7094();
    public final class_7094 heavyHammerAttack = new class_7094();
    public static final class_2941<WarriorPose> WARRIOR_POSE = class_2941.method_43240(WarriorPose.class);
    protected static final class_2940<WarriorPose> PHASE = class_2945.method_12791(WarriorOfChimericDarkness.class, WARRIOR_POSE);
    private final class_3213 bossBar = new class_3213((class_2561)class_2561.method_43471((String)"entity.unseen_world.warrior_of_chimeric_darkness"), class_1259.class_1260.field_5783, class_1259.class_1261.field_5796);
    private final WarriorPartEntity[] parts;
    public final WarriorPartEntity body;
    public final WarriorPartEntity backCrack;
    private class_2338 pos;
    private int timeOfAbility = 0;

    public WarriorOfChimericDarkness(class_1299<? extends BossLikePathfinderMob> entityType, class_1937 world) {
        super(entityType, world);
        this.field_6194 = 50;
        this.pos = this.method_24515().method_10069(this.field_5974.method_43048(7) - 3, 0, this.field_5974.method_43048(7) - 3);
        this.method_49477(1.5f);
        this.setPhase();
        class_1409 mobNavigation = (class_1409)this.method_5942();
        mobNavigation.method_6354(true);
        mobNavigation.method_46645(true);
        this.body = new WarriorPartEntity(this, "body", 0.6f, 0.8f);
        this.backCrack = new WarriorPartEntity(this, "backCrack", 0.6f, 0.8f);
        this.parts = new WarriorPartEntity[]{this.body, this.backCrack};
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(PHASE, (Object)WarriorPose.SPAWNING);
    }

    @Override
    public class_3213 bossInfo() {
        return this.bossBar;
    }

    public void method_6078(class_1282 damageSource) {
        this.field_6213 = -20;
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 world = (class_3218)class_19372;
            ChimericDarknessData data = WorldConfigController.data.get(0);
            WorldConfigController.saveController(world, true, data.sunUnlock(), data.galacticUnlock());
            WorldConfigController.updateSave(world);
        }
        this.updateTranslocatone(this.method_37908(), this.method_24515());
        super.method_6078(damageSource);
    }

    protected void method_6108() {
        super.method_6108();
        if (this.field_6213 == -2) {
            this.setWarriorPose(WarriorPose.DYING);
        }
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 350.0).method_26868(class_5134.field_23724, 12.0).method_26868(class_5134.field_23725, 4.0).method_26868(class_5134.field_23721, 10.0).method_26868(class_5134.field_23718, 1.0).method_26868(class_5134.field_23719, 0.25);
    }

    public void method_5674(class_2940<?> data) {
        if (PHASE.equals(data)) {
            switch (this.getWarriorPose().ordinal()) {
                case 10: {
                    this.spawn.method_41322(this.field_6012);
                    this.setWarriorPose(WarriorPose.IDLING);
                    break;
                }
                case 9: {
                    this.death.method_41322(this.field_6012);
                    break;
                }
                case 4: {
                    this.dash.method_41322(this.field_6012);
                    this.queueServerWork(5, () -> {
                        this.method_18800(this.getXVector(2.0, this.method_36454()), 0.5, this.getZVector(2.0, this.method_36454()));
                        this.queueServerWork(10, () -> {
                            if (this.method_5968() != null && this.method_5968().method_5858((class_1297)this) < 7.0) {
                                this.method_5783(class_3417.field_14927, 2.0f, 2.0f);
                                this.method_5968().method_18800(this.getXVector(-2.0, this.method_36454()), 0.375, this.getZVector(-2.0, this.method_36454()));
                            }
                        });
                    });
                    break;
                }
                case 2: {
                    this.hammerAttack.method_41322(this.field_6012);
                    this.queueServerWork(12, () -> {
                        class_1937 patt0$temp;
                        if (this.method_5968() != null && this.method_5968().method_5858((class_1297)this) < 5.0) {
                            this.method_6121((class_1297)this.method_5968());
                        }
                        if ((patt0$temp = this.method_37908()) instanceof class_3218) {
                            class_3218 world = (class_3218)patt0$temp;
                            world.method_14199((class_2394)class_2398.field_22247, this.method_23317(), this.method_23318() + 1.5, this.method_23321(), 12, this.getXVector(1.0, this.method_36454()), 0.25, this.getZVector(1.0, this.method_36454()), 1.0);
                        }
                    });
                    break;
                }
                case 3: {
                    this.heavyHammerAttack.method_41322(this.field_6012);
                    this.method_5993().method_6233();
                    this.queueServerWork(18, () -> {
                        this.hitNearbyMobs(10.0f, 7);
                        if (!ActionsUtils.isModLoaded("sodium")) {
                            this.provokeEarthquake(3);
                        }
                        this.method_5783(class_3417.field_14927, 2.5f, 2.5f);
                    });
                    break;
                }
                case 8: {
                    this.shieldStriking.method_41322(this.field_6012);
                    this.method_5942().method_6340();
                    this.queueServerWork(10, () -> {
                        this.method_5783(class_3417.field_14727, 2.5f, 2.5f);
                        if (this.method_5968() != null) {
                            this.method_5951((class_1297)this.method_5968(), 45.0f, 45.0f);
                            class_1937 patt0$temp = this.method_37908();
                            if (patt0$temp instanceof class_3218) {
                                class_3218 world = (class_3218)patt0$temp;
                                for (int i = 0; i < 3; ++i) {
                                    world.method_14199((class_2394)new WindVibrationParticleEffect((class_5716)new class_5709((class_1297)this.method_5968(), 0.1f + (float)i / 5.0f), 20), this.method_23317(), this.method_23318() + (double)((float)i / 5.0f), this.method_23321(), 3, 0.0, 0.0, 0.0, 0.0);
                                }
                            }
                            float scaling = 0.0f;
                            for (int i1 = 0; i1 < 7; ++i1) {
                                class_2338 pos = this.method_37908().method_17742(new class_3959(this.method_33571(), this.method_33571().method_1019(this.method_5828(1.0f).method_1021((double)scaling)), class_3959.class_3960.field_17559, class_3959.class_242.field_1348, (class_1297)this)).method_17777();
                                if (!this.method_37908().method_8320(new class_2338(pos.method_10263(), pos.method_10264(), pos.method_10260())).method_26225()) {
                                    scaling += 1.0f;
                                }
                                class_2338 pos1 = this.method_37908().method_17742(new class_3959(this.method_33571(), this.method_33571().method_1019(this.method_5828(1.0f).method_1021((double)scaling)), class_3959.class_3960.field_17559, class_3959.class_242.field_1348, (class_1297)this)).method_17777();
                                List entities = this.method_37908().method_8390(class_1309.class, new class_238(pos1.method_46558(), pos1.method_46558()).method_1014(1.5), class_1309::method_5863);
                                for (class_1309 entity : entities) {
                                    if (entity == this) continue;
                                    entity.method_5643(this.method_48923().method_48830(), 10.0f);
                                    entity.method_6092(new class_1293(class_1294.field_5909, 160, 1));
                                }
                            }
                        }
                    });
                }
            }
        }
        super.method_5674(data);
    }

    public void method_6007() {
        super.method_6007();
        float f14 = this.method_5791() * ((float)Math.PI / 180);
        float f1 = class_3532.method_15374((float)f14);
        float f15 = class_3532.method_15362((float)f14);
        class_243[] vec3ds = new class_243[this.parts.length];
        for (int s = 0; s < this.parts.length; ++s) {
            vec3ds[s] = new class_243(this.parts[s].method_23317(), this.parts[s].method_23318(), this.parts[s].method_23321());
        }
        this.movePart(this.body, f1 * -1.25f, 1.75, -f15 * -1.25f);
        this.movePart(this.backCrack, f1 * 1.1f, 1.5, -f15 * 1.1f);
        for (int ac = 0; ac < this.parts.length; ++ac) {
            this.parts[ac].field_6014 = vec3ds[ac].field_1352;
            this.parts[ac].field_6036 = vec3ds[ac].field_1351;
            this.parts[ac].field_5969 = vec3ds[ac].field_1350;
            this.parts[ac].field_6038 = vec3ds[ac].field_1352;
            this.parts[ac].field_5971 = vec3ds[ac].field_1351;
            this.parts[ac].field_5989 = vec3ds[ac].field_1350;
        }
    }

    public WarriorPartEntity[] getBodyParts() {
        return this.parts;
    }

    private void movePart(WarriorPartEntity partEntity, double dx, double dy, double dz) {
        partEntity.method_5814(this.method_23317() + dx, this.method_23318() + dy, this.method_23321() + dz);
    }

    @Override
    public EntityPart[] getParts() {
        return this.parts;
    }

    public void method_31471(class_2604 packet) {
        super.method_31471(packet);
        WarriorPartEntity[] bodyParts = this.getBodyParts();
        for (int i = 0; i < bodyParts.length; ++i) {
            bodyParts[i].method_5838(i + packet.method_11167());
        }
    }

    protected void method_5959() {
        super.method_5959();
        this.field_6201.method_6277(4, (class_1352)new WarriorMovementGoal(this));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_1657.class, false));
        this.field_6185.method_6277(2, (class_1352)new class_1361((class_1308)this, class_1657.class, 32.0f));
    }

    public boolean method_49108() {
        return super.method_49108() && !this.isInWarriorPose(WarriorPose.SPINNING);
    }

    public void setPhase() {
        switch (this.getWarriorPose().ordinal()) {
            case 0: {
                this.setWarriorPose(WarriorPose.HAMMER_ATTACKING);
                break;
            }
            case 2: {
                this.setWarriorPose(WarriorPose.SHIELDED_WALK);
                break;
            }
            case 7: {
                this.setWarriorPose(WarriorPose.DASHING);
                break;
            }
            case 4: {
                this.setWarriorPose(WarriorPose.BLASTING);
                break;
            }
            case 6: {
                this.setWarriorPose(WarriorPose.HEAVY_HAMMER_ATTACKING);
                break;
            }
            case 3: {
                this.setWarriorPose(WarriorPose.SPINNING);
                break;
            }
            case 1: {
                this.setWarriorPose(WarriorPose.EROFLAMING);
                break;
            }
            case 5: {
                this.setWarriorPose(WarriorPose.SHIELDED_STRIKING);
                break;
            }
            case 8: 
            case 10: {
                this.setWarriorPose(WarriorPose.IDLING);
            }
        }
        this.pos = this.method_24515().method_10069(this.field_5974.method_43048(7) - 3, 0, this.field_5974.method_43048(7) - 3);
    }

    private void updateTranslocatone(class_1937 world, class_2338 pos) {
        int radius = 9;
        int height = 7;
        for (int y = -height; y < height; ++y) {
            block1: for (int x = -radius; x < radius; ++x) {
                for (int z = -radius; z < radius; ++z) {
                    class_2338 pos1 = pos.method_10069(x, y, z);
                    if (!world.method_8320(pos1).method_27852(ModBlocks.GLACIEMITE_TRANSLOCATONE)) continue;
                    world.method_8501(pos1, (class_2680)world.method_8320(pos1).method_11657((class_2769)class_2741.field_12522, (Comparable)Boolean.valueOf(false)));
                    continue block1;
                }
            }
        }
    }

    protected void method_5632(double x, double y, double z) {
        if (!this.isInWarriorPose(WarriorPose.BLASTING)) {
            super.method_5632(x, y, z);
        }
    }

    public boolean method_5810() {
        return super.method_5810() && !this.isInWarriorPose(WarriorPose.BLASTING) && !this.isInWarriorPose(WarriorPose.SHIELDED_STRIKING);
    }

    @Override
    public void method_5773() {
        super.method_5773();
        if (this.timeOfAbility > 0) {
            --this.timeOfAbility;
        }
        if (this.method_5968() != null) {
            if (this.method_5858((class_1297)this.method_5968()) < 4.0 && !this.isInWarriorPose(WarriorPose.HAMMER_ATTACKING)) {
                this.method_5962().method_6243(-1.0f, 0.0f);
            }
            if (this.timeOfAbility <= 0 && !this.isInWarriorPose(WarriorPose.DYING)) {
                this.setPhase();
            }
            if (this.isInWarriorPose(WarriorPose.BLASTING)) {
                this.field_6189.method_6340();
                class_1937 class_19372 = this.method_37908();
                if (class_19372 instanceof class_3218) {
                    class_3218 world = (class_3218)class_19372;
                    world.method_14199((class_2394)class_2398.field_22247, this.method_23317() + this.getXVector(1.0, this.method_36454()), this.method_23318(), this.method_23321() + this.getZVector(1.0, this.method_36454()), 3, 0.0, 0.0, 0.0, 0.5);
                }
                for (int i = -3; i < 3; ++i) {
                    if (i % 2 != 0) continue;
                    class_1937 class_19373 = this.method_37908();
                    if (class_19373 instanceof class_3218) {
                        class_3218 world = (class_3218)class_19373;
                        world.method_14199((class_2394)class_2398.field_22446, (double)(this.pos.method_10263() + i), (double)this.pos.method_10264() + 0.25, (double)(this.pos.method_10260() + i), 9, 0.0, 1.0, 0.0, 1.0);
                    }
                    if (this.field_6012 % 5 != 0) continue;
                    List entities = this.method_37908().method_8390(class_1309.class, new class_238(this.pos, this.pos).method_1014(2.0), class_1309::method_5863);
                    for (class_1309 entity : entities) {
                        if (entity == this) continue;
                        entity.method_5643(this.method_48923().method_48834(), 8.0f);
                    }
                }
                if (this.field_6012 % 60 == 0) {
                    class_2338 class_23382 = this.pos = this.field_5974.method_43056() ? this.method_24515().method_10069(this.field_5974.method_43048(7) - 3, 0, this.field_5974.method_43048(7) - 3) : this.method_5968().method_24515().method_10084();
                }
            }
            if (this.method_5858((class_1297)this.method_5968()) < 9.0 && this.isInWarriorPose(WarriorPose.SPINNING) && this.field_6012 % 15 == 0) {
                this.method_6121((class_1297)this.method_5968());
            }
            if (this.method_5858((class_1297)this.method_5968()) < 5.0 && this.isInWarriorPose(WarriorPose.SHIELDED_WALK) && this.field_6012 % 5 == 0) {
                this.method_5968().method_18800(this.getXVector(-0.75, this.method_5968().method_36454()), (double)0.45f, this.getZVector(-0.75, this.method_5968().method_36454()));
            }
            if (this.field_6012 % 4 == 0 && this.isInWarriorPose(WarriorPose.EROFLAMING)) {
                class_1937 world = this.method_37908();
                if (world instanceof class_3218) {
                    class_3218 serverWorld = (class_3218)world;
                    class_243 eyePos = this.method_33571();
                    class_243 lookVec = this.method_5828(1.0f);
                    class_243 endPos = eyePos.method_1019(lookVec.method_1021(5.0));
                    int particleCount = 20;
                    class_243 step = endPos.method_1020(eyePos).method_1021(1.0 / (double)particleCount);
                    double radius = 0.5;
                    for (int j = 0; j < particleCount; ++j) {
                        class_243 basePos = eyePos.method_1019(step.method_1021((double)j));
                        double angle = (double)(this.field_6012 % 360) + (double)j * Math.PI / 10.0;
                        double offsetX = radius * Math.cos(angle);
                        double offsetY = radius * Math.sin(angle);
                        class_243 perpendicular = lookVec.method_1036(new class_243(0.0, 1.0, 0.0)).method_1029();
                        class_243 particlePos = basePos.method_1019(perpendicular.method_1021(offsetX)).method_1031(0.0, offsetY, 0.0);
                        serverWorld.method_14199((class_2394)class_2398.field_22246, particlePos.field_1352, particlePos.field_1351, particlePos.field_1350, 1, 0.0, 0.0, 0.0, 1.0);
                    }
                }
                class_2338 center = world.method_17742(new class_3959(this.method_33571(), this.method_33571().method_1019(this.method_5828(1.0f).method_1021(this.field_6012 % 2 == 0 ? 6.0 : 2.5)), class_3959.class_3960.field_17559, class_3959.class_242.field_1348, (class_1297)this)).method_17777();
                List entities = world.method_8390(class_1309.class, new class_238(center.method_46558(), center.method_46558()).method_1014(3.0), class_1309::method_5863);
                for (class_1309 entity : entities) {
                    if (entity == this || entity.method_5753()) continue;
                    if (entity instanceof IGrippingEntity) {
                        IGrippingEntity entity1 = (IGrippingEntity)entity;
                        GrippingData.addGrippingSeconds(entity1, 2);
                    }
                    entity.method_5643(this.method_48923().method_48834(), 4.0f);
                }
            }
        }
    }

    @Override
    public boolean haveToDropLoot(class_1282 source) {
        return source.method_5529() instanceof class_1657;
    }

    public boolean method_5643(class_1282 source, float amount) {
        if ((double)this.field_5974.method_43057() > 0.875 && !this.isInWarriorPose(WarriorPose.SHIELDED_WALK) && !this.method_37908().method_8608() && source.method_49708(class_8111.field_42320)) {
            this.setWarriorPose(WarriorPose.SHIELDED_WALK);
        }
        if (this.isInWarriorPose(WarriorPose.SHIELDED_WALK) || this.isInWarriorPose(WarriorPose.EROFLAMING) || this.isInWarriorPose(WarriorPose.BLASTING)) {
            this.method_5783(class_3417.field_15150, 1.1f, 0.9f);
            return false;
        }
        if (this.method_5968() != null && this.isInWarriorPose(WarriorPose.SHIELDED_WALK)) {
            this.method_5968().method_5643(source, amount / 2.0f);
        }
        return super.method_5643(source, amount);
    }

    protected int method_23329(float fallDistance, float damageMultiplier) {
        return Math.round((float)super.method_23329(fallDistance, damageMultiplier) / 2.0f);
    }

    public void setWarriorPose(WarriorPose pose) {
        this.field_6011.method_12778(PHASE, (Object)pose);
        this.timeOfAbility = pose.getAbilityTime;
    }

    public WarriorPose getWarriorPose() {
        return (WarriorPose)((Object)this.field_6011.method_12789(PHASE));
    }

    public boolean isInWarriorPose(WarriorPose pose) {
        return this.getWarriorPose() == pose;
    }

    public static enum WarriorPose {
        IDLING(300),
        SPINNING(200),
        HAMMER_ATTACKING(50),
        HEAVY_HAMMER_ATTACKING(60),
        DASHING(40),
        EROFLAMING(120),
        BLASTING(280),
        SHIELDED_WALK(160),
        SHIELDED_STRIKING(60),
        DYING(500),
        SPAWNING(20);

        public final int getAbilityTime;

        private WarriorPose(int getAbilityTime) {
            this.getAbilityTime = getAbilityTime;
        }
    }
}

