/*
 * Decompiled with CFR 0.152.
 */
package net.sashakyotoz.common.entities.custom;

import java.util.Collection;
import java.util.UUID;
import java.util.function.DoubleSupplier;
import java.util.function.Predicate;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1295;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1338;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1376;
import net.minecraft.class_1394;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1538;
import net.minecraft.class_1548;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3489;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_3959;
import net.minecraft.class_4582;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5575;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.sashakyotoz.common.ModRegistry;
import net.sashakyotoz.common.entities.ai.EspyerIgniteGoal;
import net.sashakyotoz.common.entities.custom.SaberpardEntity;
import net.sashakyotoz.common.items.ModItems;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EspyerEntity
extends class_1588
implements class_4582 {
    private static final class_2940<Integer> FUSE_SPEED = class_2945.method_12791(EspyerEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> CHARGED = class_2945.method_12791(EspyerEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> IGNITED = class_2945.method_12791(EspyerEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> CONVERTING = class_2945.method_12791(EspyerEntity.class, (class_2941)class_2943.field_13323);
    private int conversionTimer;
    @Nullable
    private UUID converter;
    private int lastFuseTime;
    private int currentFuseTime;
    private int fuseTime = 30;
    private int explosionRadius = 3;

    public EspyerEntity(class_1299<? extends class_1588> entityType, class_1937 world) {
        super(entityType, world);
    }

    protected void method_5959() {
        this.field_6201.method_6277(1, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(2, (class_1352)new EspyerIgniteGoal(this));
        this.field_6201.method_6277(3, (class_1352)new class_1338((class_1314)this, SaberpardEntity.class, 8.0f, 1.0, 1.2));
        this.field_6201.method_6277(5, (class_1352)new class_1394((class_1314)this, 0.8));
        this.field_6201.method_6277(6, (class_1352)new class_1361((class_1308)this, class_1657.class, 24.0f));
        this.field_6201.method_6277(6, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(1, (class_1352)new class_1400((class_1308)this, class_1657.class, true));
        this.field_6185.method_6277(2, (class_1352)new class_1399((class_1314)this, new Class[0]));
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 22.0).method_26868(class_5134.field_23717, 24.0).method_26868(class_5134.field_23719, 0.25);
    }

    public boolean method_5747(float fallDistance, float damageMultiplier, class_1282 damageSource) {
        boolean bl = super.method_5747(fallDistance, damageMultiplier, damageSource);
        this.currentFuseTime += (int)(fallDistance * 1.5f);
        if (this.currentFuseTime > this.fuseTime - 5) {
            this.currentFuseTime = this.fuseTime - 5;
        }
        return bl;
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(FUSE_SPEED, (Object)-1);
        this.field_6011.method_12784(CHARGED, (Object)false);
        this.field_6011.method_12784(IGNITED, (Object)false);
        this.field_6011.method_12784(CONVERTING, (Object)false);
    }

    public boolean isConverting() {
        return (Boolean)this.method_5841().method_12789(CONVERTING);
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        if (((Boolean)this.field_6011.method_12789(CHARGED)).booleanValue()) {
            nbt.method_10556("powered", true);
        }
        nbt.method_10569("ConversionTime", this.isConverting() ? this.conversionTimer : -1);
        if (this.converter != null) {
            nbt.method_25927("ConversionPlayer", this.converter);
        }
        nbt.method_10575("Fuse", (short)this.fuseTime);
        nbt.method_10567("ExplosionRadius", (byte)this.explosionRadius);
        nbt.method_10556("ignited", this.isIgnited());
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        if (nbt.method_10573("ConversionTime", 99) && nbt.method_10550("ConversionTime") > -1) {
            this.setConverting(nbt.method_25928("ConversionPlayer") ? nbt.method_25926("ConversionPlayer") : null, nbt.method_10550("ConversionTime"));
        }
        this.field_6011.method_12778(CHARGED, (Object)nbt.method_10577("powered"));
        if (nbt.method_10573("Fuse", 99)) {
            this.fuseTime = nbt.method_10568("Fuse");
        }
        if (nbt.method_10573("ExplosionRadius", 99)) {
            this.explosionRadius = nbt.method_10571("ExplosionRadius");
        }
        if (nbt.method_10577("ignited")) {
            this.ignite();
        }
    }

    private void setConverting(@Nullable UUID uuid, int delay) {
        this.converter = uuid;
        this.conversionTimer = delay;
        this.method_5841().method_12778(CONVERTING, (Object)true);
        this.method_6016(class_1294.field_5912);
        this.method_6092(new class_1293(class_1294.field_38092, delay, Math.min(this.method_37908().method_8407().method_5461() - 1, 0)));
        this.method_37908().method_8421((class_1297)this, (byte)42);
    }

    public void method_5773() {
        if (this.method_5805()) {
            int i;
            this.lastFuseTime = this.currentFuseTime;
            if (this.isIgnited()) {
                this.setFuseSpeed(1);
            }
            if ((i = this.getFuseSpeed()) > 0 && this.currentFuseTime == 0) {
                this.method_5783(class_3417.field_15057, 1.0f, 0.5f);
                this.method_32876(class_5712.field_28727);
            }
            this.currentFuseTime += i;
            if (this.currentFuseTime < 0) {
                this.currentFuseTime = 0;
            }
            if (this.currentFuseTime >= this.fuseTime) {
                this.currentFuseTime = this.fuseTime;
                this.explode();
            }
            if (this.method_5968() != null && !this.isEntityLookingAtMe(this.method_5968(), 0.5, false, true, class_1309::method_5863, () -> ((EspyerEntity)this).method_23320(), () -> ((EspyerEntity)this).method_23318(), () -> (this.method_23320() + this.method_23318()) / 2.0)) {
                this.method_5942().method_6335((class_1297)this.method_5968(), 1.0);
            } else {
                this.method_5942().method_6340();
            }
            if (!this.method_37908().field_9236 && this.method_5805() && this.isConverting()) {
                --this.conversionTimer;
                if (this.conversionTimer <= 0) {
                    this.finishConversion((class_3218)this.method_37908());
                }
            }
        }
        super.method_5773();
    }

    private void finishConversion(class_3218 world) {
        class_1548 creeper = (class_1548)this.method_29243(class_1299.field_6046, false);
        creeper.method_5943((class_5425)world, world.method_8404(creeper.method_24515()), class_3730.field_16468, null, null);
        if (this.converter != null) {
            class_1657 player = world.method_18470(this.converter);
            if (player != null) {
                player.method_5706((class_1935)ModItems.GRIPCRYSTAL);
            }
            if (player instanceof class_3222) {
                class_3222 player1 = (class_3222)player;
                ModRegistry.CURED_GRIPCRYSTAL_ENTITY_CRITERION.trigger(player1, (class_1309)this, (class_1309)creeper);
            }
        }
        creeper.method_6092(new class_1293(class_1294.field_5912, 200, 0));
        if (!this.method_5701()) {
            world.method_45445((class_1297)this, this.method_24515(), class_3417.field_15192, class_3419.field_15254, 2.0f, 2.0f);
        }
    }

    public boolean isEntityLookingAtMe(class_1309 entity, double d, boolean bl, boolean visualShape, Predicate<class_1309> predicate, DoubleSupplier ... entityYChecks) {
        if (predicate.test(entity)) {
            class_243 vec3d = entity.method_5828(1.0f).method_1029();
            for (DoubleSupplier doubleSupplier : entityYChecks) {
                class_243 vec3d2 = new class_243(this.method_23317() - entity.method_23317(), doubleSupplier.getAsDouble() - entity.method_23320(), this.method_23321() - entity.method_23321());
                double e = vec3d2.method_1033();
                vec3d2 = vec3d2.method_1029();
                double f = vec3d.method_1026(vec3d2);
                double d2 = bl ? e : 1.0;
                if (!(f > 1.0 - d / d2)) continue;
                return this.canSee((class_1297)this, visualShape ? class_3959.class_3960.field_23142 : class_3959.class_3960.field_17558, class_3959.class_242.field_1348, doubleSupplier);
            }
        }
        return false;
    }

    public boolean canSee(class_1297 entity, class_3959.class_3960 shapeType, class_3959.class_242 fluidHandling, DoubleSupplier entityY) {
        if (entity.method_37908() != this.method_37908()) {
            return false;
        }
        class_243 vec3d = new class_243(this.method_23317(), this.method_23320(), this.method_23321());
        class_243 vec3d2 = new class_243(entity.method_23317(), entityY.getAsDouble(), entity.method_23321());
        if (vec3d2.method_1022(vec3d) > 128.0) {
            return false;
        }
        return this.method_37908().method_17742(new class_3959(vec3d, vec3d2, shapeType, fluidHandling, (class_1297)this)).method_17783() == class_239.class_240.field_1333;
    }

    protected class_3414 method_6011(class_1282 source) {
        return class_3417.field_15192;
    }

    protected class_3414 method_6002() {
        return class_3417.field_14907;
    }

    public int method_5850() {
        return this.method_5968() == null ? 3 : 3 + (int)(this.method_6032() - 1.0f);
    }

    public boolean method_6121(class_1297 target) {
        return true;
    }

    public boolean method_6872() {
        return (Boolean)this.field_6011.method_12789(CHARGED);
    }

    public float getClientFuseTime(float timeDelta) {
        return class_3532.method_16439((float)timeDelta, (float)this.lastFuseTime, (float)this.currentFuseTime) / (float)(this.fuseTime - 2);
    }

    public int getFuseSpeed() {
        return (Integer)this.field_6011.method_12789(FUSE_SPEED);
    }

    public void setFuseSpeed(int fuseSpeed) {
        this.field_6011.method_12778(FUSE_SPEED, (Object)fuseSpeed);
    }

    public void method_5800(class_3218 world, class_1538 lightning) {
        super.method_5800(world, lightning);
        this.field_6011.method_12778(CHARGED, (Object)true);
    }

    protected class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 itemStack = player.method_5998(hand);
        if (itemStack.method_31573(class_3489.field_41662)) {
            class_3414 soundEvent = itemStack.method_31574(class_1802.field_8814) ? class_3417.field_15013 : class_3417.field_15145;
            this.method_37908().method_43128(player, this.method_23317(), this.method_23318(), this.method_23321(), soundEvent, this.method_5634(), 1.0f, this.field_5974.method_43057() * 0.4f + 0.8f);
            if (!this.method_37908().field_9236) {
                this.ignite();
                if (!itemStack.method_7963()) {
                    itemStack.method_7934(1);
                } else {
                    itemStack.method_7956(1, (class_1309)player, playerx -> playerx.method_20236(hand));
                }
            }
            return class_1269.method_29236((boolean)this.method_37908().field_9236);
        }
        if (itemStack.method_31574(ModItems.GRIPTONITE)) {
            if (!player.method_31549().field_7477 && player instanceof class_3222) {
                class_3222 player1 = (class_3222)player;
                itemStack.method_7970(1, player1.method_6051(), player1);
            }
            if (!this.method_37908().field_9236) {
                this.setConverting(player.method_5667(), this.field_5974.method_43048(1201) + 600);
            }
            return class_1269.field_5812;
        }
        return super.method_5992(player, hand);
    }

    private void explode() {
        if (!this.method_37908().field_9236) {
            float f = this.method_6872() ? 2.0f : 1.0f;
            this.field_6272 = true;
            this.method_37908().method_8437((class_1297)this, this.method_23317(), this.method_23318(), this.method_23321(), (float)this.explosionRadius * f, class_1937.class_7867.field_40890);
            this.method_31472();
            this.spawnEffectsCloud();
        }
    }

    public static boolean canEspyerSpawn(class_1299<? extends class_1308> type, class_1936 world, class_3730 spawnReason, class_2338 pos, class_5819 random) {
        class_2338 blockPos = pos.method_10074();
        return spawnReason == class_3730.field_16469 || world.method_8320(blockPos).method_26170((class_1922)world, blockPos, type) && world.method_18023(class_5575.method_31795(EspyerEntity.class), new class_238(pos).method_1014(64.0), class_1309::method_5805).size() < 3 && blockPos.method_10264() < 32 && !world.method_8311(pos) && world.method_18458((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), 32.0);
    }

    private void spawnEffectsCloud() {
        Collection collection = this.method_6026();
        if (!collection.isEmpty()) {
            class_1295 areaEffectCloudEntity = this.getAreaEffectCloudEntity();
            for (class_1293 statusEffectInstance : collection) {
                areaEffectCloudEntity.method_5610(new class_1293(statusEffectInstance));
            }
            this.method_37908().method_8649((class_1297)areaEffectCloudEntity);
        }
    }

    @NotNull
    private class_1295 getAreaEffectCloudEntity() {
        class_1295 areaEffectCloudEntity = new class_1295(this.method_37908(), this.method_23317(), this.method_23318(), this.method_23321());
        areaEffectCloudEntity.method_5603(3.0f);
        areaEffectCloudEntity.method_5609(-0.5f);
        areaEffectCloudEntity.method_5595(10);
        areaEffectCloudEntity.method_5604(areaEffectCloudEntity.method_5605() / 2);
        areaEffectCloudEntity.method_5596(-areaEffectCloudEntity.method_5599() / (float)areaEffectCloudEntity.method_5605());
        return areaEffectCloudEntity;
    }

    public boolean isIgnited() {
        return (Boolean)this.field_6011.method_12789(IGNITED);
    }

    public void ignite() {
        this.field_6011.method_12778(IGNITED, (Object)true);
    }
}

