/*
 * Decompiled with CFR 0.152.
 */
package net.sashakyotoz.common.entities.custom;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Dynamic;
import java.util.UUID;
import java.util.function.IntFunction;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1352;
import net.minecraft.class_1391;
import net.minecraft.class_1429;
import net.minecraft.class_1452;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_3542;
import net.minecraft.class_3730;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_4095;
import net.minecraft.class_4140;
import net.minecraft.class_4148;
import net.minecraft.class_4149;
import net.minecraft.class_4209;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5575;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7988;
import net.minecraft.class_7995;
import net.sashakyotoz.common.ModRegistry;
import net.sashakyotoz.common.entities.ModEntities;
import net.sashakyotoz.common.entities.custom.brain.TuskhogBrain;
import net.sashakyotoz.common.items.ModItems;
import net.sashakyotoz.common.tags.ModTags;
import org.jetbrains.annotations.Nullable;

public class TuskhogEntity
extends class_1429
implements class_7988<Type> {
    private static final class_2940<Boolean> CONVERTING = class_2945.method_12791(TuskhogEntity.class, (class_2941)class_2943.field_13323);
    private int conversionTimer;
    @Nullable
    private UUID converter;
    private static final class_1856 TAMING_INGREDIENT = class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8429, class_1802.field_8209});
    private static final class_2940<Integer> TYPE = class_2945.method_12791(TuskhogEntity.class, (class_2941)class_2943.field_13327);
    public static final class_4048 LONG_JUMPING_DIMENSIONS = class_4048.method_18384((float)0.9f, (float)1.3f).method_18383(0.7f);
    protected static final ImmutableList<class_4149<? extends class_4148<? super TuskhogEntity>>> SENSORS = ImmutableList.of((Object)class_4149.field_18466, (Object)class_4149.field_18467, (Object)class_4149.field_22358, (Object)class_4149.field_25362, (Object)class_4149.field_18469, (Object)class_4149.field_30261);
    protected static final ImmutableList<class_4140<?>> MEMORY_MODULES = ImmutableList.of((Object)class_4140.field_18446, (Object)class_4140.field_18442, (Object)class_4140.field_18445, (Object)class_4140.field_19293, (Object)class_4140.field_18449, (Object)class_4140.field_22350, (Object)class_4140.field_18448, (Object)class_4140.field_30244, (Object)class_4140.field_30245, (Object)class_4140.field_28325, (Object)class_4140.field_25359, (Object)class_4140.field_28326, (Object[])new class_4140[]{class_4140.field_28327, class_4140.field_33483, class_4140.field_33484, class_4140.field_39408});
    private boolean preparingRam;
    private int headPitch;

    public TuskhogEntity(class_1299<? extends class_1429> entityType, class_1937 world) {
        super(entityType, world);
        this.method_5942().method_6354(true);
    }

    protected void method_5619() {
        if (this.method_6109()) {
            this.method_5996(class_5134.field_23721).method_6192(1.0);
        } else {
            this.method_5996(class_5134.field_23721).method_6192(2.0);
        }
    }

    protected void method_5959() {
        class_1391 temptGoal = new class_1391((class_1314)this, 0.6, TAMING_INGREDIENT, true);
        this.field_6201.method_6277(3, (class_1352)temptGoal);
    }

    protected int method_23329(float fallDistance, float damageMultiplier) {
        return super.method_23329(fallDistance, damageMultiplier) - 10;
    }

    protected class_3414 method_5994() {
        return class_3417.field_14615;
    }

    protected class_3414 method_6011(class_1282 source) {
        return class_3417.field_14750;
    }

    protected class_3414 method_6002() {
        return class_3417.field_29810;
    }

    protected void method_5712(class_2338 pos, class_2680 state) {
        this.method_5783(class_3417.field_29819, 0.15f, 1.0f);
    }

    @Nullable
    public TuskhogEntity createChild(class_3218 serverWorld, class_1296 passiveEntity) {
        TuskhogEntity tuskhog = (TuskhogEntity)ModEntities.TUSKHOG.method_5883((class_1937)serverWorld);
        if (tuskhog != null) {
            TuskhogBrain.resetLongJumpCooldown(tuskhog, serverWorld.method_8409());
        }
        return tuskhog;
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 10.0).method_26868(class_5134.field_23719, (double)0.2f).method_26868(class_5134.field_23721, 2.0);
    }

    protected class_4095.class_5303<TuskhogEntity> method_28306() {
        return class_4095.method_28311(MEMORY_MODULES, SENSORS);
    }

    protected class_4095<?> method_18867(Dynamic<?> dynamic) {
        return TuskhogBrain.create((class_4095<TuskhogEntity>)this.method_28306().method_28335(dynamic));
    }

    protected void method_5958() {
        this.method_37908().method_16107().method_15396("hogBrain");
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 world = (class_3218)class_19372;
            this.method_18868().method_19542(world, (class_1309)this);
        }
        this.method_37908().method_16107().method_15407();
        this.method_37908().method_16107().method_15396("hogActivityUpdate");
        TuskhogBrain.updateActivities(this);
        this.method_37908().method_16107().method_15407();
        super.method_5958();
    }

    public int method_5986() {
        return 15;
    }

    public class_4095<TuskhogEntity> method_18868() {
        return super.method_18868();
    }

    public void method_5847(float headYaw) {
        int i = this.method_5986();
        float f = class_3532.method_15381((float)this.field_6283, (float)headYaw);
        float g = class_3532.method_15363((float)f, (float)(-i), (float)i);
        super.method_5847(this.field_6283 + g);
    }

    public class_3414 method_18869(class_1799 stack) {
        return class_3417.field_33437;
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 itemStack = player.method_5998(hand);
        class_1269 actionResult = super.method_5992(player, hand);
        if (actionResult.method_23665() && this.method_6481(itemStack)) {
            this.method_37908().method_43129(null, (class_1297)this, this.method_18869(itemStack), class_3419.field_15254, 1.0f, class_3532.method_32750((class_5819)this.method_37908().field_9229, (float)0.8f, (float)1.2f));
        } else {
            if (itemStack.method_31574(ModItems.CRYSTIE_APPLE)) {
                if (this.method_6059(class_1294.field_5912)) {
                    if (!player.method_31549().field_7477) {
                        itemStack.method_7934(1);
                    }
                    if (!this.method_37908().field_9236) {
                        this.setConverting(player.method_5667(), this.field_5974.method_43048(2401) + 2400);
                    }
                    return class_1269.field_5812;
                }
                return class_1269.field_21466;
            }
            if (itemStack.method_31574(ModItems.GRIPTONITE)) {
                if (!player.method_31549().field_7477 && player instanceof class_3222) {
                    class_3222 player1 = (class_3222)player;
                    itemStack.method_7970(1, player1.method_6051(), player1);
                }
                if (!this.method_37908().field_9236) {
                    this.setConverting(player.method_5667(), this.field_5974.method_43048(1201) + 1200);
                }
                return class_1269.field_5812;
            }
        }
        return actionResult;
    }

    protected void method_18409() {
        super.method_18409();
        class_4209.method_19774((class_1309)this);
    }

    public class_4048 method_18377(class_4050 pose) {
        return pose == class_4050.field_30095 ? LONG_JUMPING_DIMENSIONS.method_18383(this.method_17825()) : super.method_18377(pose);
    }

    public void method_5711(byte status) {
        if (status == 58) {
            this.preparingRam = true;
        } else if (status == 59) {
            this.preparingRam = false;
        } else {
            super.method_5711(status);
        }
    }

    public void method_5773() {
        if (!this.method_37908().field_9236 && this.method_5805() && this.isConverting()) {
            --this.conversionTimer;
            if (this.conversionTimer <= 0) {
                this.finishConversion((class_3218)this.method_37908());
            }
        }
        super.method_5773();
    }

    private void finishConversion(class_3218 world) {
        class_1452 pig = (class_1452)this.method_29243(class_1299.field_6093, false);
        pig.method_5943((class_5425)world, world.method_8404(pig.method_24515()), class_3730.field_16468, null, null);
        if (this.converter != null) {
            class_1657 player = world.method_18470(this.converter);
            if (player != null) {
                player.method_5706((class_1935)ModItems.GRIPCRYSTAL);
            }
            if (player instanceof class_3222) {
                class_3222 player1 = (class_3222)player;
                ModRegistry.CURED_GRIPCRYSTAL_ENTITY_CRITERION.trigger(player1, (class_1309)this, (class_1309)pig);
            }
        }
        pig.method_6092(new class_1293(class_1294.field_5912, 200, 0));
        if (!this.method_5701()) {
            world.method_45445((class_1297)this, this.method_24515(), class_3417.field_16441, class_3419.field_15254, 3.0f, 2.0f);
        }
    }

    public void method_6007() {
        this.headPitch = this.preparingRam ? ++this.headPitch : (this.headPitch -= 2);
        this.headPitch = class_3532.method_15340((int)this.headPitch, (int)0, (int)20);
        super.method_6007();
    }

    public float getHeadPitch() {
        return (float)this.headPitch / 20.0f * 30.0f * ((float)Math.PI / 180);
    }

    private void setConverting(@Nullable UUID uuid, int delay) {
        this.converter = uuid;
        this.conversionTimer = delay;
        this.method_5841().method_12778(CONVERTING, (Object)true);
        this.method_6016(class_1294.field_5912);
        this.method_6092(new class_1293(class_1294.field_38092, delay, Math.min(this.method_37908().method_8407().method_5461() - 1, 0)));
        this.method_37908().method_8421((class_1297)this, (byte)42);
    }

    public boolean isConverting() {
        return (Boolean)this.method_5841().method_12789(CONVERTING);
    }

    public boolean method_6481(class_1799 stack) {
        return TAMING_INGREDIENT.method_8093(stack);
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(TYPE, (Object)0);
        this.field_6011.method_12784(CONVERTING, (Object)false);
    }

    public void setVariant(Type variant) {
        this.field_6011.method_12778(TYPE, (Object)variant.getId());
    }

    public Type getVariant() {
        return Type.fromId((Integer)this.field_6011.method_12789(TYPE));
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10582("Type", this.getVariant().method_15434());
        nbt.method_10569("ConversionTime", this.isConverting() ? this.conversionTimer : -1);
        if (this.converter != null) {
            nbt.method_25927("ConversionPlayer", this.converter);
        }
    }

    @Nullable
    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData, @Nullable class_2487 entityNbt) {
        class_6880 registryEntry = world.method_23753(this.method_24515());
        Type type = Type.fromBiome((class_6880<class_1959>)registryEntry);
        this.setVariant(type);
        if (this.field_5974.method_43056()) {
            this.method_5614(-24000);
        }
        this.method_5964(world.method_8409(), difficulty);
        return super.method_5943(world, difficulty, spawnReason, entityData, entityNbt);
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.setVariant(Type.byName(nbt.method_10558("Type")));
        if (nbt.method_10573("ConversionTime", 99) && nbt.method_10550("ConversionTime") > -1) {
            this.setConverting(nbt.method_25928("ConversionPlayer") ? nbt.method_25926("ConversionPlayer") : null, nbt.method_10550("ConversionTime"));
        }
    }

    public static boolean isValidNaturalSpawn(class_1299<? extends class_1429> type, class_1936 world, class_3730 spawnReason, class_2338 pos, class_5819 random) {
        return world.method_8320(pos.method_10074()).method_26164(class_3481.field_29822) && world.method_18023(class_5575.method_31795(TuskhogEntity.class), new class_238(pos).method_1014(64.0), class_1309::method_5805).size() < 4 && random.method_43048(4) == 1;
    }

    public static enum Type implements class_3542
    {
        WARM(0, "warm"),
        TEMPERATE(1, "temperate");

        public static final class_3542.class_7292<Type> CODEC;
        private static final IntFunction<Type> BY_ID;
        private final int id;
        private final String key;

        private Type(int id, String key) {
            this.id = id;
            this.key = key;
        }

        public String method_15434() {
            return this.key;
        }

        public int getId() {
            return this.id;
        }

        public static Type byName(String name) {
            return (Type)CODEC.method_47920(name, (Enum)TEMPERATE);
        }

        public static Type fromId(int id) {
            return BY_ID.apply(id);
        }

        public static Type fromBiome(class_6880<class_1959> biome) {
            return biome.method_40220(ModTags.Biomes.SPAWNS_WARM_TUSKHOG) ? WARM : TEMPERATE;
        }

        static {
            CODEC = class_3542.method_28140(Type::values);
            BY_ID = class_7995.method_47914(Type::getId, (Object[])Type.values(), (class_7995.class_7996)class_7995.class_7996.field_41664);
        }
    }
}

