/*
 * Decompiled with CFR 0.152.
 */
package net.sashakyotoz.common.items.custom;

import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3468;
import net.minecraft.class_3532;
import net.minecraft.class_5328;
import net.minecraft.class_5536;
import net.minecraft.class_5630;
import net.minecraft.class_5631;
import net.minecraft.class_5632;
import net.sashakyotoz.api.entity_data.IEntityDataSaver;
import net.sashakyotoz.api.entity_data.IGrippingEntity;
import net.sashakyotoz.api.entity_data.data.GripcrystalManaData;
import net.sashakyotoz.api.entity_data.data.GrippingData;
import net.sashakyotoz.common.items.ModItems;
import net.sashakyotoz.common.tags.ModTags;

public class GrippingBundleItem
extends class_1792 {
    public GrippingBundleItem(class_1792.class_1793 settings) {
        super(settings);
    }

    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        super.method_7888(stack, world, entity, slot, selected);
        if (entity instanceof class_3222) {
            class_3222 player = (class_3222)entity;
            if (player.field_6012 % 20 == 0) {
                IGrippingEntity entity1;
                int i = this.getGrippingModifier(stack);
                IEntityDataSaver keeper = (IEntityDataSaver)player;
                if (i < 0) {
                    if (entity instanceof IGrippingEntity && (entity1 = (IGrippingEntity)entity).getGrippingData() > 0) {
                        GrippingData.addGrippingSeconds(entity1, i);
                    } else {
                        GripcrystalManaData.removeMana(keeper, Math.abs(Math.round((float)i / 2.0f)));
                    }
                } else if (GripcrystalManaData.getMana(keeper) > 49 && entity instanceof IGrippingEntity && (entity1 = (IGrippingEntity)entity).getGrippingData() < 10) {
                    GrippingData.addGrippingSeconds(entity1, i);
                } else {
                    GripcrystalManaData.addMana(keeper, i);
                }
                if (entity instanceof IGrippingEntity && (entity1 = (IGrippingEntity)entity).getGrippingData() > 0 || GripcrystalManaData.getMana(keeper) < 48) {
                    this.decrementFirstStack(stack);
                }
            }
        }
    }

    private int getGrippingModifier(class_1799 stack) {
        if (this.getBundleOccupancy(stack) > 0) {
            class_1792 item = this.getBundledStacks(stack).toList().get(0).method_7909();
            if (item.method_7876().contains("gripcrystal")) {
                return item.method_7876().contains("granulated") ? 1 : 4;
            }
            if (item.method_7876().contains("griptonite")) {
                return item.method_7876().contains("granulated") ? -3 : -6;
            }
        }
        return 0;
    }

    public boolean method_31565(class_1799 stack, class_1735 slot, class_5536 clickType, class_1657 player) {
        if (clickType != class_5536.field_27014) {
            return false;
        }
        class_1799 itemStack = slot.method_7677();
        if (itemStack.method_7960()) {
            this.playRemoveOneSound((class_1297)player);
            this.removeFirstStack(stack).ifPresent(removedStack -> this.addToBundle(stack, slot.method_32756(removedStack)));
        } else if (itemStack.method_7909().method_31568()) {
            int i = (64 - this.getBundleOccupancy(stack)) / GrippingBundleItem.getItemOccupancy(itemStack);
            int j = this.addToBundle(stack, slot.method_32753(itemStack.method_7947(), i, player));
            if (j > 0) {
                this.playInsertSound((class_1297)player);
            }
        }
        return true;
    }

    public boolean method_31566(class_1799 stack, class_1799 otherStack, class_1735 slot, class_5536 clickType, class_1657 player, class_5630 cursorStackReference) {
        if (clickType == class_5536.field_27014 && slot.method_32754(player)) {
            if (otherStack.method_7960()) {
                this.removeFirstStack(stack).ifPresent(itemStack -> {
                    this.playRemoveOneSound((class_1297)player);
                    cursorStackReference.method_32332(itemStack);
                });
            } else {
                int i = this.addToBundle(stack, otherStack);
                if (i > 0) {
                    this.playInsertSound((class_1297)player);
                    otherStack.method_7934(i);
                }
            }
            return true;
        }
        return false;
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 itemStack = user.method_5998(hand);
        if (this.dropAllBundledItems(itemStack, user)) {
            this.playDropContentsSound((class_1297)user);
            user.method_7259(class_3468.field_15372.method_14956((Object)this));
            return class_1271.method_29237((Object)itemStack, (boolean)world.method_8608());
        }
        return class_1271.method_22431((Object)itemStack);
    }

    public boolean method_31567(class_1799 stack) {
        return this.getBundleOccupancy(stack) > 0;
    }

    public int method_31569(class_1799 stack) {
        return Math.min(1 + 12 * this.getBundleOccupancy(stack) / 64, 13);
    }

    public int method_31571(class_1799 stack) {
        return class_3532.method_15353((float)0.4f, (float)0.6f, (float)1.0f);
    }

    private int addToBundle(class_1799 bundle, class_1799 stack) {
        if (!stack.method_7960() && stack.method_7909().method_31568() && stack.method_31573(ModTags.Items.GRIPPING_BUNDLE_CAN_HANDLE)) {
            class_2487 nbtCompound = bundle.method_7948();
            if (!nbtCompound.method_10545("Items")) {
                nbtCompound.method_10566("Items", (class_2520)new class_2499());
            }
            int i = this.getBundleOccupancy(bundle);
            int j = GrippingBundleItem.getItemOccupancy(stack);
            int k = Math.min(stack.method_7947(), (64 - i) / j);
            if (k == 0) {
                return 0;
            }
            class_2499 nbtList = nbtCompound.method_10554("Items", 10);
            Optional<class_2487> optional = GrippingBundleItem.canMergeStack(stack, nbtList);
            if (optional.isPresent()) {
                class_2487 nbtCompound2 = optional.get();
                class_1799 itemStack = class_1799.method_7915((class_2487)nbtCompound2);
                itemStack.method_7933(k);
                itemStack.method_7953(nbtCompound2);
                nbtList.remove((Object)nbtCompound2);
                nbtList.method_10531(0, (class_2520)nbtCompound2);
            } else {
                class_1799 itemStack2 = stack.method_46651(k);
                class_2487 nbtCompound3 = new class_2487();
                itemStack2.method_7953(nbtCompound3);
                nbtList.method_10531(0, (class_2520)nbtCompound3);
            }
            return k;
        }
        return 0;
    }

    private static Optional<class_2487> canMergeStack(class_1799 stack, class_2499 items) {
        return stack.method_31574(ModItems.GRIPPING_BUNDLE) ? Optional.empty() : items.stream().filter(class_2487.class::isInstance).map(class_2487.class::cast).filter(item -> class_1799.method_31577((class_1799)class_1799.method_7915((class_2487)item), (class_1799)stack)).findFirst();
    }

    private static int getItemOccupancy(class_1799 stack) {
        return 64 / stack.method_7914();
    }

    private int getBundleOccupancy(class_1799 stack) {
        return this.getBundledStacks(stack).mapToInt(itemStack -> GrippingBundleItem.getItemOccupancy(itemStack) * itemStack.method_7947()).sum();
    }

    private Optional<class_1799> removeFirstStack(class_1799 stack) {
        class_2487 nbtCompound = stack.method_7948();
        if (!nbtCompound.method_10545("Items")) {
            return Optional.empty();
        }
        class_2499 nbtList = nbtCompound.method_10554("Items", 10);
        if (nbtList.isEmpty()) {
            return Optional.empty();
        }
        class_2487 nbtCompound2 = nbtList.method_10602(0);
        class_1799 itemStack = class_1799.method_7915((class_2487)nbtCompound2);
        nbtList.method_10536(0);
        if (nbtList.isEmpty()) {
            stack.method_7983("Items");
        }
        return Optional.of(itemStack);
    }

    private Optional<class_1799> decrementFirstStack(class_1799 stack) {
        class_2487 nbtCompound = stack.method_7948();
        if (!nbtCompound.method_10545("Items")) {
            return Optional.empty();
        }
        class_2499 nbtList = nbtCompound.method_10554("Items", 10);
        if (nbtList.isEmpty()) {
            return Optional.empty();
        }
        class_2487 nbtCompound2 = nbtList.method_10602(0);
        class_1799 itemStack = class_1799.method_7915((class_2487)nbtCompound2);
        if (itemStack.method_7947() > 1) {
            itemStack.method_7934(1);
            nbtList.method_10606(0, (class_2520)itemStack.method_7953(new class_2487()));
        } else {
            nbtList.method_10536(0);
        }
        if (nbtList.isEmpty()) {
            stack.method_7983("Items");
        }
        return Optional.of(itemStack);
    }

    private boolean dropAllBundledItems(class_1799 stack, class_1657 player) {
        class_2487 nbtCompound = stack.method_7948();
        if (!nbtCompound.method_10545("Items")) {
            return false;
        }
        if (player instanceof class_3222) {
            class_2499 nbtList = nbtCompound.method_10554("Items", 10);
            for (int i = 0; i < nbtList.size(); ++i) {
                class_2487 nbtCompound2 = nbtList.method_10602(i);
                class_1799 itemStack = class_1799.method_7915((class_2487)nbtCompound2);
                player.method_7328(itemStack, true);
            }
        }
        stack.method_7983("Items");
        return true;
    }

    private Stream<class_1799> getBundledStacks(class_1799 stack) {
        class_2487 nbtCompound = stack.method_7969();
        if (nbtCompound == null) {
            return Stream.empty();
        }
        class_2499 nbtList = nbtCompound.method_10554("Items", 10);
        return nbtList.stream().map(class_2487.class::cast).map(class_1799::method_7915);
    }

    public Optional<class_5632> method_32346(class_1799 stack) {
        class_2371 defaultedList = class_2371.method_10211();
        this.getBundledStacks(stack).forEach(arg_0 -> defaultedList.add(arg_0));
        return Optional.of(new class_5631(defaultedList, this.getBundleOccupancy(stack)));
    }

    public void method_7851(class_1799 stack, class_1937 world, List<class_2561> tooltip, class_1836 context) {
        tooltip.add((class_2561)class_2561.method_43469((String)"item.minecraft.bundle.fullness", (Object[])new Object[]{this.getBundleOccupancy(stack), 64}).method_27692(class_124.field_1080));
    }

    public void method_33261(class_1542 entity) {
        class_5328.method_33263((class_1542)entity, this.getBundledStacks(entity.method_6983()));
    }

    private void playRemoveOneSound(class_1297 entity) {
        entity.method_5783(class_3417.field_34377, 0.8f, 0.8f + entity.method_37908().method_8409().method_43057() * 0.4f);
    }

    private void playInsertSound(class_1297 entity) {
        entity.method_5783(class_3417.field_34376, 0.8f, 0.8f + entity.method_37908().method_8409().method_43057() * 0.4f);
    }

    private void playDropContentsSound(class_1297 entity) {
        entity.method_5783(class_3417.field_34375, 0.8f, 0.8f + entity.method_37908().method_8409().method_43057() * 0.4f);
    }
}

