/*
 * Decompiled with CFR 0.152.
 */
package net.sashakyotoz.common.world;

import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_2338;
import net.minecraft.class_5321;
import net.minecraft.class_5742;
import net.minecraft.class_5996;
import net.minecraft.class_6544;
import net.minecraft.class_6554;
import net.minecraft.class_6880;
import net.minecraft.class_6954;
import net.minecraft.class_8197;
import net.sashakyotoz.common.world.biomes.ModBiomes;

public class DarknessMultiNoiseBiomeSource
extends class_1966 {
    private static final MapCodec<class_6880<class_1959>> BIOME_CODEC = class_1959.field_24677.fieldOf("biome");
    public static final MapCodec<class_6544.class_6547<class_6880<class_1959>>> CUSTOM_CODEC = class_6544.class_6547.method_49497(BIOME_CODEC).fieldOf("biomes");
    private static final MapCodec<class_6880<class_8197>> PRESET_CODEC = class_8197.field_42987.fieldOf("preset").withLifecycle(Lifecycle.stable());
    public static final Codec<DarknessMultiNoiseBiomeSource> CODEC = Codec.mapEither(CUSTOM_CODEC, PRESET_CODEC).xmap(DarknessMultiNoiseBiomeSource::new, source -> source.biomeEntries).codec();
    private final Either<class_6544.class_6547<class_6880<class_1959>>, class_6880<class_8197>> biomeEntries;

    private DarknessMultiNoiseBiomeSource(Either<class_6544.class_6547<class_6880<class_1959>>, class_6880<class_8197>> biomeEntries) {
        this.biomeEntries = biomeEntries;
    }

    public static DarknessMultiNoiseBiomeSource create(class_6544.class_6547<class_6880<class_1959>> biomeEntries) {
        return new DarknessMultiNoiseBiomeSource((Either<class_6544.class_6547<class_6880<class_1959>>, class_6880<class_8197>>)Either.left(biomeEntries));
    }

    public static DarknessMultiNoiseBiomeSource create(class_6880<class_8197> biomeEntries) {
        return new DarknessMultiNoiseBiomeSource((Either<class_6544.class_6547<class_6880<class_1959>>, class_6880<class_8197>>)Either.right(biomeEntries));
    }

    private class_6544.class_6547<class_6880<class_1959>> getBiomeEntries() {
        return (class_6544.class_6547)this.biomeEntries.map(entries -> entries, parameterListEntry -> ((class_8197)parameterListEntry.comp_349()).method_49507());
    }

    protected Stream<class_6880<class_1959>> method_49494() {
        return this.getBiomeEntries().method_38128().stream().map(Pair::getSecond);
    }

    protected Codec<? extends class_1966> method_28442() {
        return CODEC;
    }

    public class_6880<class_1959> method_38109(int x, int y, int z, class_6544.class_6552 noise) {
        class_6880<class_1959> candidate = this.getBiomeAtPoint(noise.method_40444(x, y, z));
        int y1 = class_5742.method_33101((int)y);
        if (y1 < 32) {
            if (y1 < -48) {
                return this.registryEntryFromKey(ModBiomes.DEEP_GLACIEMITE_CAVES, candidate);
            }
            class_6544.class_6553 sampled = noise.method_40444(x, y1, z);
            float temperature = class_6544.method_38666((long)sampled.comp_112());
            if (temperature > 0.0f) {
                return this.registryEntryFromKey(ModBiomes.TANZANITE_CAVES, candidate);
            }
            return this.registryEntryFromKey(ModBiomes.SHINY_CAVERNS, candidate);
        }
        return candidate;
    }

    private class_6880<class_1959> registryEntryFromKey(class_5321<class_1959> key, class_6880<class_1959> fallback) {
        return Optional.of((class_6880)this.getBiomeEntries().method_38128().stream().filter(noiseHypercubeRegistryEntryPair -> ((class_6880)noiseHypercubeRegistryEntryPair.getSecond()).method_40225(key)).findFirst().get().getSecond()).orElse(fallback);
    }

    @class_5996
    public class_6880<class_1959> getBiomeAtPoint(class_6544.class_6553 point) {
        return (class_6880)this.getBiomeEntries().method_39529(point);
    }

    public void method_38114(List<String> info, class_2338 pos, class_6544.class_6552 noiseSampler) {
        int i = class_5742.method_33100((int)pos.method_10263());
        int j = class_5742.method_33100((int)pos.method_10264());
        int k = class_5742.method_33100((int)pos.method_10260());
        class_6544.class_6553 noiseValuePoint = noiseSampler.method_40444(i, j, k);
        float f = class_6544.method_38666((long)noiseValuePoint.comp_114());
        float g = class_6544.method_38666((long)noiseValuePoint.comp_115());
        float h = class_6544.method_38666((long)noiseValuePoint.comp_112());
        float l = class_6544.method_38666((long)noiseValuePoint.comp_113());
        float m = class_6544.method_38666((long)noiseValuePoint.comp_117());
        double d = class_6954.method_41546((float)m);
        class_6554 vanillaBiomeParameters = new class_6554();
        info.add("Biome builder PV: " + class_6554.method_38179((double)d) + " C: " + vanillaBiomeParameters.method_38188((double)f) + " E: " + vanillaBiomeParameters.method_38193((double)g) + " T: " + vanillaBiomeParameters.method_38197((double)h) + " H: " + vanillaBiomeParameters.method_38201((double)l));
    }
}

