/*
 * Decompiled with CFR 0.152.
 */
package net.sashakyotoz.common.world.carvers.custom;

import com.mojang.serialization.Codec;
import java.util.function.Function;
import net.minecraft.class_1923;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2939;
import net.minecraft.class_5819;
import net.minecraft.class_5873;
import net.minecraft.class_6350;
import net.minecraft.class_6643;
import net.minecraft.class_6880;
import net.sashakyotoz.common.world.carvers.custom.configs.SpiralCaveCarverConfig;

public class SpiralCaveCarver
extends class_2939<SpiralCaveCarverConfig> {
    public static final class_2939<SpiralCaveCarverConfig> INSTANCE = new SpiralCaveCarver(SpiralCaveCarverConfig.CODEC);

    public SpiralCaveCarver(Codec<SpiralCaveCarverConfig> configCodec) {
        super(configCodec);
    }

    public boolean carve(class_5873 context, SpiralCaveCarverConfig config, class_2791 chunk, Function<class_2338, class_6880<class_1959>> posToBiome, class_5819 random, class_6350 aquiferSampler, class_1923 pos, class_6643 mask) {
        double baseRadius = Math.max(1.0, (double)config.radius());
        int length = Math.max(1, config.length());
        double turnRate = config.turnRate();
        double radiusVar = config.radiusVariance();
        int vSpread = Math.max(1, config.verticalSpread());
        int chunkWorldX = pos.field_9181 << 4;
        int chunkWorldZ = pos.field_9180 << 4;
        double centerY = Math.max(10, chunk.method_31605());
        double startX = (double)chunkWorldX + 8.0;
        double startZ = (double)chunkWorldZ + 8.0;
        boolean carvedAny = false;
        for (int step = 0; step < length; ++step) {
            double angle = (double)step * turnRate;
            double r = baseRadius + (random.method_43058() - 0.5) * radiusVar;
            double advance = (double)step * 1.0;
            double forwardZ = 1.0;
            double offsetX = Math.cos(angle) * r;
            double offsetZ = Math.sin(angle) * r;
            double pointX = startX + advance + offsetX;
            double pointZ = startZ + forwardZ + offsetZ;
            int cx = (int)Math.floor(pointX);
            int cz = (int)Math.floor(pointZ);
            int intRadius = (int)Math.ceil(r + 1.5);
            for (int dx = -intRadius; dx <= intRadius; ++dx) {
                for (int dz = -intRadius; dz <= intRadius; ++dz) {
                    double nx = (double)dx + (pointX - (double)cx);
                    double nz = (double)dz + (pointZ - (double)cz);
                    double horizDistSq = nx * nx + nz * nz;
                    if (!(horizDistSq <= r * r + 0.9)) continue;
                    for (int dy = -vSpread; dy <= vSpread; ++dy) {
                        class_2338 posBlock;
                        int wy = (int)centerY + dy;
                        int wx = cx + dx;
                        int wz = cz + dz;
                        int localX = wx & 0xF;
                        int localZ = wz & 0xF;
                        if (wy < 1 || wy > 254 || mask.method_38868(localX, wy, localZ) || !this.canReplaceBlock(chunk, posBlock = new class_2338(wx, wy, wz))) continue;
                        chunk.method_12010(posBlock, class_2246.field_10124.method_9564(), false);
                        mask.method_38865(localX, wy, localZ);
                        carvedAny = true;
                    }
                }
            }
        }
        return carvedAny;
    }

    private boolean canReplaceBlock(class_2791 chunk, class_2338 pos) {
        if (!chunk.method_12004().equals((Object)new class_1923(pos.method_10263() >> 4, pos.method_10260() >> 4))) {
            return false;
        }
        class_2680 state = chunk.method_8320(pos);
        return !state.method_27852(class_2246.field_9987) && state.method_26227().method_15769();
    }

    public boolean shouldCarve(SpiralCaveCarverConfig config, class_5819 random) {
        return random.method_43057() <= config.field_13738;
    }
}

