/*
 * Decompiled with CFR 0.152.
 */
package net.sashakyotoz.mixin.client;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_5607;
import net.minecraft.class_583;
import net.minecraft.class_630;
import net.sashakyotoz.UnseenWorld;
import net.sashakyotoz.api.entity_data.IModelPartsAccessor;
import net.sashakyotoz.utils.ModelPartUtils;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={class_583.class})
public class EntityModelMixin<T extends class_1297>
implements IModelPartsAccessor {
    @Unique
    private List<class_630> modelParts;
    @Unique
    private boolean triedCollect = false;
    @Unique
    private boolean usedStatic;
    @Unique
    private String staticMethodName;

    @Override
    public List<class_630> getAllModelParts() {
        if (!this.triedCollect) {
            this.triedCollect = true;
            UnseenWorld.log("[ModelParts] Start collecting for %s".formatted(this.getClass().getSimpleName()));
            this.collectParts();
            Object[] objectArray = new Object[2];
            objectArray[0] = this.modelParts != null && !this.modelParts.isEmpty() ? (this.usedStatic ? "static:" + this.staticMethodName + "()" : "fields") : "NONE";
            objectArray[1] = this.modelParts == null ? 0 : this.modelParts.size();
            UnseenWorld.log("[ModelParts] Done. Path=%s, count=%d".formatted(objectArray));
        }
        return this.modelParts != null ? this.modelParts : List.of();
    }

    @Unique
    private void collectParts() {
        Class<?> cls = this.getClass();
        for (Method m : cls.getDeclaredMethods()) {
            if (!Modifier.isStatic(m.getModifiers()) || m.getParameterCount() != 0 || !class_5607.class.isAssignableFrom(m.getReturnType())) continue;
            try {
                m.setAccessible(true);
                class_5607 data = (class_5607)m.invoke(null, new Object[0]);
                this.modelParts = ModelPartUtils.collectAllModelParts(data);
                this.usedStatic = true;
                this.staticMethodName = m.getName();
                return;
            }
            catch (IllegalAccessException | InvocationTargetException data) {
                // empty catch block
            }
        }
        this.usedStatic = false;
        this.staticMethodName = null;
        this.modelParts = new ArrayList<class_630>();
        for (Class<?> walk = cls; walk != null && class_583.class.isAssignableFrom(walk); walk = walk.getSuperclass()) {
            for (Field f : walk.getDeclaredFields()) {
                if (!class_630.class.isAssignableFrom(f.getType())) continue;
                try {
                    f.setAccessible(true);
                    class_630 p = (class_630)f.get(this);
                    if (p == null || this.modelParts.contains(p)) continue;
                    this.modelParts.add(p);
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
        }
    }
}

