/*
 * Decompiled with CFR 0.152.
 */
package dev.mineland.item_interactions_mod.CarriedInteractions;

import dev.mineland.item_interactions_mod.CarriedInteractions.Particles.BaseParticle;
import dev.mineland.item_interactions_mod.CarriedInteractions.Spawners.GuiParticleSpawner;
import dev.mineland.item_interactions_mod.GlobalDirt;
import dev.mineland.item_interactions_mod.ItemInteractionsConfig;
import dev.mineland.item_interactions_mod.ItemInteractionsMod;
import dev.mineland.item_interactions_mod.SpawnerRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class GuiParticleSpawnersLogic {
    private static final List<Slot> slots = new ArrayList<Slot>();

    public static void reset() {
        slots.clear();
    }

    public static boolean checkAndTick(GuiGraphics guiGraphics, Slot slot, boolean dead, int leftPos, int topPos, int initialSlotCount) {
        if (!GlobalDirt.shouldTickParticles || GlobalDirt.dontUpdateTimer) {
            return false;
        }
        int slotCount = initialSlotCount;
        while (slots.size() <= GlobalDirt.slotCount) {
            slots.add(null);
        }
        if (slots.get(slotCount) != slot) {
            if (slotCount - 1 >= 0 && slots.get(slotCount - 1) == slot) {
                --GlobalDirt.slotCount;
            } else if (slotCount + 1 < slots.size() && slots.get(slotCount + 1) == slot) {
                ++GlobalDirt.slotCount;
            }
            slotCount = GlobalDirt.slotCount;
        }
        slots.set(slotCount, slot);
        while (GlobalDirt.slotSpawners.size() <= slotCount) {
            GlobalDirt.slotSpawners.add(null);
        }
        try {
            ItemStack slotItem = slot.getItem();
            List<GuiParticleSpawner> itemGuiParticleSpawnerList = SpawnerRegistry.get(slotItem);
            List<ResourceLocation> currentSpawnersList = GlobalDirt.slotSpawners.getIdList(slotCount);
            List<ResourceLocation> itemSpawnersIdList = SpawnerRegistry.getList(slotItem);
            if (ItemInteractionsConfig.debugDraws) {
                guiGraphics.submitOutline(slot.x, slot.y, 16, 16, -1);
            }
            if (itemGuiParticleSpawnerList.isEmpty() && currentSpawnersList.isEmpty()) {
                return false;
            }
            if (itemGuiParticleSpawnerList.isEmpty()) {
                if (ItemInteractionsConfig.debugDraws) {
                    guiGraphics.fill(slot.x, slot.y, slot.x + 16, slot.y + 16, -65536);
                }
                GlobalDirt.slotSpawners.set(slotCount, new ArrayList<GuiParticleSpawner>());
                return false;
            }
            int globalX = slot.x + leftPos + 8;
            int globalY = slot.y + topPos + 8;
            if (currentSpawnersList.isEmpty() || !new HashSet<ResourceLocation>(currentSpawnersList).containsAll(itemSpawnersIdList)) {
                if (ItemInteractionsConfig.debugDraws) {
                    guiGraphics.fill(slot.x, slot.y, slot.x + 16, slot.y + 16, currentSpawnersList.isEmpty() ? -16711936 : -256);
                }
                GlobalDirt.slotSpawners.set(slotCount, itemGuiParticleSpawnerList, GlobalDirt.isInventoryScrolling && GlobalDirt.inventoryJustOpened ? "onIdle" : "onPut");
                GlobalDirt.slotSpawners.tick(slotCount, GlobalDirt.spawnerTickDelta, guiGraphics, globalX, globalY, 0.0f, 0.0f);
                GlobalDirt.slotSpawners.setState(slotCount, "onIdle");
                return false;
            }
            if (ItemInteractionsConfig.debugDraws) {
                guiGraphics.fill(slot.x, slot.y, slot.x + 16, slot.y + 16, -2147418368);
            }
            GlobalDirt.slotSpawners.tick(slotCount, GlobalDirt.spawnerTickDelta, guiGraphics, globalX, globalY, 0.0f, 0.0f);
            return false;
        }
        catch (Exception e) {
            if (!dead) {
                ItemInteractionsMod.warnMessage("Error! \n" + String.valueOf(e), new Object[0]);
            }
            return true;
        }
    }

    public static void mainLogic(GuiGraphics guiGraphics) {
        ArrayList<BaseParticle> shouldDelete = new ArrayList<BaseParticle>();
        if (GlobalDirt.shouldTickParticles && ItemInteractionsConfig.enableGuiParticles && !GlobalDirt.dontUpdateTimer) {
            if (GlobalDirt.carriedItem == null || GlobalDirt.carriedItem.isEmpty() || SpawnerRegistry.get(GlobalDirt.carriedItem).isEmpty()) {
                GlobalDirt.carriedGuiParticleSpawner.clear();
            } else if (GlobalDirt.carriedItem != null && !GlobalDirt.carriedItem.isEmpty()) {
                double x = GlobalDirt.lastMouseX + (double)(ItemInteractionsConfig.getAnimationSetting().itemPos.x() * 16.0f);
                double y = GlobalDirt.lastMouseY + (double)(ItemInteractionsConfig.getAnimationSetting().itemPos.y() * 16.0f);
                double speedX = GlobalDirt.speedX + (double)ItemInteractionsConfig.getAnimationSetting().itemSpeed.x();
                double speedY = GlobalDirt.speedY + (double)ItemInteractionsConfig.getAnimationSetting().itemSpeed.y();
                if (!SpawnerRegistry.compareSpawner(GlobalDirt.carriedGuiParticleSpawner, GlobalDirt.carriedItem) || GlobalDirt.carriedGuiParticleSpawner.isEmpty()) {
                    List<GuiParticleSpawner> newGuiParticleSpawner = SpawnerRegistry.get(GlobalDirt.carriedItem);
                    if (!newGuiParticleSpawner.isEmpty()) {
                        GlobalDirt.carriedGuiParticleSpawner = newGuiParticleSpawner;
                        Collections.fill(GlobalDirt.carriedGuiParticleSpawnerTimer, Float.valueOf(0.0f));
                        GlobalDirt.carriedGuiParticleSpawner.forEach(spawner -> spawner.setState("onPickup"));
                        GlobalDirt.slotSpawners.tickSpawners(-1, GlobalDirt.carriedGuiParticleSpawner, GlobalDirt.spawnerTickDelta, guiGraphics, (float)x, (float)y, (float)speedX, (float)speedY);
                        GlobalDirt.carriedGuiParticleSpawner.forEach(spawner -> spawner.setState("onIdle"));
                    } else {
                        GlobalDirt.carriedGuiParticleSpawner.clear();
                    }
                }
                GlobalDirt.carriedGuiParticleSpawner.forEach(spawner -> spawner.setState(GlobalDirt.isShaking ? "onShake" : "onCarried"));
                GlobalDirt.slotSpawners.tickSpawners(-1, GlobalDirt.carriedGuiParticleSpawner, GlobalDirt.spawnerTickDelta, guiGraphics, (float)x, (float)y, (float)speedX, (float)speedY);
                GlobalDirt.carriedGuiParticleSpawner.forEach(spawner -> spawner.setState("onIdle"));
            }
            GlobalDirt.isInventoryScrolling = false;
        }
        boolean i = false;
        for (BaseParticle particle : GlobalDirt.particleList) {
            if (GlobalDirt.shouldTickParticles && !GlobalDirt.dontUpdateTimer) {
                particle.tick();
                if (particle.shouldDelete) {
                    shouldDelete.add(particle);
                }
            }
            particle.render();
        }
        GlobalDirt.particleList.removeAll(shouldDelete);
    }
}

