/*
 * Decompiled with CFR 0.152.
 */
package dev.mineland.item_interactions_mod.CarriedInteractions.Spawners;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.mineland.item_interactions_mod.CarriedInteractions.Spawners.ParticleInstance;
import dev.mineland.item_interactions_mod.MiscUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;

public class ParticleEvent {
    public Optional<Float> interval = Optional.empty();
    public Optional<Float> interval_variance = Optional.empty();
    public float nextInterval = 0.0f;
    public Optional<ParticleInstance> attributes = Optional.empty();
    public Optional<ParticleInstance> attributes_variance = Optional.empty();
    public Optional<List<ParticleInstance>> particles = Optional.empty();
    public Optional<String> use = Optional.empty();
    public static final Codec<ParticleEvent> CODEC = RecordCodecBuilder.create(eventInstance -> eventInstance.group((App)Codec.FLOAT.optionalFieldOf("interval").forGetter(e -> e.interval), (App)Codec.FLOAT.optionalFieldOf("interval_variance").forGetter(e -> e.interval_variance), (App)ParticleInstance.CONFIG_CODEC.optionalFieldOf("attributes").forGetter(e -> e.attributes), (App)ParticleInstance.CONFIG_CODEC.optionalFieldOf("attributes_variance").forGetter(e -> e.attributes_variance), (App)ParticleInstance.CODEC.listOf().optionalFieldOf("particles").forGetter(e -> e.particles), (App)Codec.STRING.optionalFieldOf("use").forGetter(e -> e.use)).apply((Applicative)eventInstance, ParticleEvent::new));

    public ParticleEvent() {
    }

    public ParticleEvent(Optional<Float> interval, Optional<Float> interval_variance, Optional<ParticleInstance> attributes, Optional<ParticleInstance> attributes_variance, Optional<List<ParticleInstance>> particles, Optional<String> use) {
        this.interval = interval;
        this.interval_variance = interval_variance;
        this.attributes = attributes;
        this.attributes_variance = attributes_variance;
        this.particles = particles;
        this.use = use;
    }

    private ParticleInstance combineAttributes(Optional<ParticleInstance> base, Optional<ParticleInstance> newer) {
        if (base.isEmpty() && newer.isEmpty()) {
            return new ParticleInstance();
        }
        if (newer.isEmpty()) {
            return base.get();
        }
        if (base.isEmpty()) {
            return newer.get();
        }
        ParticleInstance result = base.get().copy();
        ParticleInstance newerAttributes = newer.get();
        newerAttributes.x.ifPresent(attr -> {
            result.x = Optional.of(attr);
        });
        newerAttributes.y.ifPresent(attr -> {
            result.y = Optional.of(attr);
        });
        newerAttributes.speedX.ifPresent(attr -> {
            result.speedX = Optional.of(attr);
        });
        newerAttributes.speedY.ifPresent(attr -> {
            result.speedY = Optional.of(attr);
        });
        newerAttributes.accelerationX.ifPresent(attr -> {
            result.accelerationX = Optional.of(attr);
        });
        newerAttributes.accelerationY.ifPresent(attr -> {
            result.accelerationY = Optional.of(attr);
        });
        newerAttributes.frictionX.ifPresent(attr -> {
            result.frictionX = Optional.of(attr);
        });
        newerAttributes.frictionY.ifPresent(attr -> {
            result.frictionY = Optional.of(attr);
        });
        newerAttributes.colorStart.ifPresent(attr -> {
            result.colorStart = Optional.of(attr);
        });
        newerAttributes.colorEnd.ifPresent(attr -> {
            result.colorEnd = Optional.of(attr);
        });
        newerAttributes.brightnessStart.ifPresent(attr -> {
            result.brightnessStart = Optional.of(attr);
        });
        newerAttributes.brightnessEnd.ifPresent(attr -> {
            result.brightnessEnd = Optional.of(attr);
        });
        newerAttributes.duration.ifPresent(attr -> {
            result.duration = Optional.of(attr);
        });
        newerAttributes.count.ifPresent(attr -> {
            result.count = Optional.of(attr);
        });
        return result;
    }

    void fire(GuiGraphics guiGraphics, float x, float y, float speedX, float speedY, Optional<ParticleInstance> spawnerAttributes, Optional<ParticleInstance> spawnerAttributesVariance) {
        ParticleInstance empty = new ParticleInstance();
        ParticleInstance combined = this.combineAttributes(spawnerAttributes, this.attributes);
        ParticleInstance combinedVariance = this.combineAttributes(spawnerAttributesVariance, this.attributes_variance);
        int eventCount = combined.count.orElse(1);
        int rand = combinedVariance.count.orElse(0);
        for (ParticleInstance p : (List)this.particles.orElse(new ArrayList())) {
            for (int i = 0; i < (int)MiscUtils.randomVariance(p.count.orElse(eventCount).intValue(), rand); ++i) {
                p.spawn(guiGraphics, x, y, speedX, speedY, combined, combinedVariance);
            }
        }
    }

    public void inheritFromParent(Map<String, Either<ParticleEvent, String>> eventMap, Either<ParticleEvent, String> parent) {
        ParticleInstance newAttributes;
        if (parent == null) {
            return;
        }
        if (parent.right().isPresent()) {
            this.inheritFromParent(eventMap, parent);
            return;
        }
        if (parent.left().isEmpty()) {
            return;
        }
        ParticleInstance localAttributes = new ParticleInstance();
        ParticleInstance localAttributesVariance = new ParticleInstance();
        if (((ParticleEvent)parent.left().get()).attributes.isPresent()) {
            localAttributes = ((ParticleEvent)parent.left().get()).attributes.orElse(localAttributes);
        }
        if (this.attributes.isPresent()) {
            newAttributes = this.attributes.get();
            localAttributes.x.ifPresent(attr -> {
                newAttributes.x = Optional.of(attr);
            });
            localAttributes.y.ifPresent(attr -> {
                newAttributes.y = Optional.of(attr);
            });
            localAttributes.speedX.ifPresent(attr -> {
                newAttributes.speedX = Optional.of(attr);
            });
            localAttributes.speedY.ifPresent(attr -> {
                newAttributes.speedY = Optional.of(attr);
            });
            localAttributes.accelerationX.ifPresent(attr -> {
                newAttributes.accelerationX = Optional.of(attr);
            });
            localAttributes.accelerationY.ifPresent(attr -> {
                newAttributes.accelerationY = Optional.of(attr);
            });
            localAttributes.frictionX.ifPresent(attr -> {
                newAttributes.frictionX = Optional.of(attr);
            });
            localAttributes.frictionY.ifPresent(attr -> {
                newAttributes.frictionY = Optional.of(attr);
            });
            localAttributes.colorStart.ifPresent(attr -> {
                newAttributes.colorStart = Optional.of(attr);
            });
            localAttributes.colorEnd.ifPresent(attr -> {
                newAttributes.colorEnd = Optional.of(attr);
            });
            localAttributes.brightnessStart.ifPresent(attr -> {
                newAttributes.brightnessStart = Optional.of(attr);
            });
            localAttributes.brightnessEnd.ifPresent(attr -> {
                newAttributes.brightnessEnd = Optional.of(attr);
            });
            localAttributes.duration.ifPresent(attr -> {
                newAttributes.duration = Optional.of(attr);
            });
            localAttributes.count.ifPresent(attr -> {
                newAttributes.count = Optional.of(attr);
            });
            this.attributes = Optional.of(newAttributes);
        } else {
            this.attributes = Optional.of(localAttributes);
        }
        if (((ParticleEvent)parent.left().get()).attributes_variance.isPresent()) {
            localAttributesVariance = ((ParticleEvent)parent.left().get()).attributes_variance.orElse(localAttributesVariance);
        }
        if (this.attributes_variance.isPresent()) {
            newAttributes = this.attributes_variance.get();
            localAttributesVariance.x.ifPresent(attr -> {
                newAttributes.x = Optional.of(attr);
            });
            localAttributesVariance.y.ifPresent(attr -> {
                newAttributes.y = Optional.of(attr);
            });
            localAttributesVariance.speedX.ifPresent(attr -> {
                newAttributes.speedX = Optional.of(attr);
            });
            localAttributesVariance.speedY.ifPresent(attr -> {
                newAttributes.speedY = Optional.of(attr);
            });
            localAttributesVariance.accelerationX.ifPresent(attr -> {
                newAttributes.accelerationX = Optional.of(attr);
            });
            localAttributesVariance.accelerationY.ifPresent(attr -> {
                newAttributes.accelerationY = Optional.of(attr);
            });
            localAttributesVariance.frictionX.ifPresent(attr -> {
                newAttributes.frictionX = Optional.of(attr);
            });
            localAttributesVariance.frictionY.ifPresent(attr -> {
                newAttributes.frictionY = Optional.of(attr);
            });
            localAttributesVariance.colorStart.ifPresent(attr -> {
                newAttributes.colorStart = Optional.of(attr);
            });
            localAttributesVariance.colorEnd.ifPresent(attr -> {
                newAttributes.colorEnd = Optional.of(attr);
            });
            localAttributesVariance.brightnessStart.ifPresent(attr -> {
                newAttributes.brightnessStart = Optional.of(attr);
            });
            localAttributesVariance.brightnessEnd.ifPresent(attr -> {
                newAttributes.brightnessEnd = Optional.of(attr);
            });
            localAttributesVariance.duration.ifPresent(attr -> {
                newAttributes.duration = Optional.of(attr);
            });
            localAttributesVariance.count.ifPresent(attr -> {
                newAttributes.count = Optional.of(attr);
            });
            this.attributes_variance = Optional.of(newAttributes);
        } else {
            this.attributes_variance = Optional.of(localAttributesVariance);
        }
        if (this.particles.isEmpty()) {
            this.particles = ((ParticleEvent)parent.left().get()).particles;
        }
        if (this.interval.isEmpty()) {
            this.interval = ((ParticleEvent)parent.left().get()).interval;
        }
        if (this.interval_variance.isEmpty()) {
            this.interval_variance = ((ParticleEvent)parent.left().get()).interval_variance;
        }
        this.use = Optional.empty();
        ((ParticleEvent)parent.left().get()).use.ifPresent(s -> this.inheritFromParent(eventMap, (Either<ParticleEvent, String>)((Either)eventMap.get(s))));
    }
}

