/*
 * Decompiled with CFR 0.152.
 */
package dev.mineland.item_interactions_mod.CustomGuiComponents;

import dev.mineland.item_interactions_mod.CustomGuiComponents.ClientFakeContainer;
import dev.mineland.item_interactions_mod.GlobalDirt;
import dev.mineland.item_interactions_mod.ItemInteractionsConfig;
import dev.mineland.item_interactions_mod.ItemInteractionsMod;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractContainerWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class ConfigInventoryPreview
extends AbstractContainerWidget {
    private static final ResourceLocation CONTAINER_BACKGROUND = ResourceLocation.withDefaultNamespace((String)"textures/gui/container/generic_54.png");
    private final ClientFakeContainer container;
    private static int invX;
    private static int invY;
    private static final int previewWidth = 68;
    private static final int previewHeight = 78;
    private static int mouseX;
    private static int mouseY;

    public ConfigInventoryPreview(int i, int j, int k, int l, Component label) {
        super(i, j, k, l, label);
        int containerRows = 3;
        int imageHeight = 114 + containerRows * 18;
        int inventoryLabelY = imageHeight - 94;
        int imageWidth = 176;
        int previewWidth = containerRows * 18 + 7 + 7;
        int previewHeight = 78;
        invX = this.getX() + this.width / 2 - previewWidth / 2;
        invY = this.getY() + this.height / 2 - previewHeight / 2;
        this.container = new ClientFakeContainer(3, 3, invX + 7, invY + 17);
        mouseX = 0;
        mouseY = 0;
    }

    protected int contentHeight() {
        return 0;
    }

    protected double scrollRate() {
        return 0.0;
    }

    protected void renderWidget(GuiGraphics guiGraphics, int i, int j, float f) {
        Font font = Minecraft.getInstance().font;
        GlobalDirt.updateTimer();
        if (ItemInteractionsConfig.debugDraws) {
            // empty if block
        }
        int containerRows = 3;
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, CONTAINER_BACKGROUND, invX, invY, 0.0f, 0.0f, 61, containerRows * 18 + 17, 256, 256);
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, CONTAINER_BACKGROUND, invX, invY + (containerRows * 18 + 17), 0.0f, 215.0f, 61, 7, 256, 256);
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, CONTAINER_BACKGROUND, invX + 61, invY, 169.0f, 0.0f, 7, containerRows * 18 + 17, 256, 256);
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, CONTAINER_BACKGROUND, invX + 61, invY + (containerRows * 18 + 17), 169.0f, 215.0f, 7, 7, 256, 256);
        guiGraphics.pose().pushMatrix();
        this.container.render(guiGraphics, mouseX, mouseY);
        guiGraphics.pose().popMatrix();
        GlobalDirt.updateMousePositions();
        GlobalDirt.tailUpdateTimer();
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }

    public void setItem(int id, ItemStack item) {
        if (id < 0 || id >= this.container.getContainerSize()) {
            ItemInteractionsMod.warnMessage("Tried setting a slot that doesnt exist!", new Object[0]);
            return;
        }
        this.container.setItem(id, item);
    }

    public void setX(int left) {
        super.setX(left);
        invX = left + this.width / 2 - 34;
        this.container.setX(invX + 7);
    }

    public void setY(int top) {
        super.setY(top);
        invY = top + this.height / 2 - 39;
        this.container.setY(invY + 17);
    }

    public void setPosition(int left, int top) {
        super.setPosition(left, top);
        invX = left + this.width / 2 - 34;
        invY = top + this.height / 2 - 39;
        this.container.setPos(invX + 7, invY + 17);
    }

    public void setInvX(int x) {
        this.container.setX(x);
    }

    public void setInvY(int y) {
        this.container.setY(y);
    }

    public void setInvPos(int x, int y) {
        this.container.setPos(x, y);
    }

    public boolean mouseClicked(MouseButtonEvent mouseButtonEvent, boolean bl) {
        double x = mouseButtonEvent.x();
        double y = mouseButtonEvent.y();
        int mb = mouseButtonEvent.button();
        this.container.mouseClicked(x, y, mb);
        return super.mouseClicked(mouseButtonEvent, bl);
    }

    public void mouseMoved(double d, double e) {
        mouseX = (int)d;
        mouseY = (int)e;
        super.mouseMoved(d, e);
    }

    public List<? extends GuiEventListener> children() {
        return List.of();
    }
}

