/*
 * Decompiled with CFR 0.152.
 */
package dev.mineland.item_interactions_mod.CustomGuiComponents;

import net.minecraft.client.InputType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

public abstract class SteppedSliderButton
extends AbstractWidget {
    private static final ResourceLocation SLIDER_SPRITE = ResourceLocation.withDefaultNamespace((String)"widget/slider");
    private static final ResourceLocation HIGHLIGHTED_SPRITE = ResourceLocation.withDefaultNamespace((String)"widget/slider_highlighted");
    private static final ResourceLocation SLIDER_HANDLE_SPRITE = ResourceLocation.withDefaultNamespace((String)"widget/slider_handle");
    private static final ResourceLocation SLIDER_HANDLE_HIGHLIGHTED_SPRITE = ResourceLocation.withDefaultNamespace((String)"widget/slider_handle_highlighted");
    protected static final int TEXT_MARGIN = 2;
    private static final int HANDLE_WIDTH = 8;
    private static final int HANDLE_HALF_WIDTH = 4;
    public double minValue;
    public double maxValue;
    public int steps;
    private double range;
    private int selectedStep;
    private boolean canChangeValue;
    public boolean divideSteps;
    private double handlePosition;
    public double value;
    private boolean dragging;

    public SteppedSliderButton(int left, int top, int width, int height, Component message, double initialValue) {
        this(left, top, width, height, message, initialValue, 0.0, 1.0, 0, false);
    }

    public SteppedSliderButton(int left, int top, int width, int height, Component message, double initialValue, double minValue, double maxValue) {
        this(left, top, width, height, message, initialValue, minValue, maxValue, 0, false);
    }

    public SteppedSliderButton(int left, int top, int width, int height, Component message, double initialValue, double minValue, double maxValue, int steps) {
        this(left, top, width, height, message, initialValue, minValue, maxValue, steps, false);
    }

    public SteppedSliderButton(int left, int top, int width, int height, Component message, double initialValue, double minValue, double maxValue, int steps, boolean divideSteps) {
        super(left, top, width, height, message);
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.steps = steps;
        this.range = maxValue - minValue;
        this.divideSteps = divideSteps;
        if (steps > 0) {
            this.selectedStep = (int)Math.round((initialValue - minValue) / this.range * (double)steps);
            this.setValueInternal((double)this.selectedStep / (double)steps * this.range + minValue);
        } else {
            this.setValueInternal(initialValue);
        }
        this.updateHandlePosition();
    }

    private ResourceLocation getSprite() {
        return this.isActive() && this.isFocused() && !this.canChangeValue ? HIGHLIGHTED_SPRITE : SLIDER_SPRITE;
    }

    private ResourceLocation getHandleSprite() {
        return !this.isActive() || !this.isHovered && !this.canChangeValue ? SLIDER_HANDLE_SPRITE : SLIDER_HANDLE_HIGHLIGHTED_SPRITE;
    }

    @NotNull
    protected MutableComponent createNarrationMessage() {
        return Component.translatable((String)"gui.narrate.slider", (Object[])new Object[]{this.getMessage()});
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
        narrationElementOutput.add(NarratedElementType.TITLE, (Component)this.createNarrationMessage());
        if (this.active) {
            if (this.isFocused()) {
                narrationElementOutput.add(NarratedElementType.USAGE, (Component)Component.translatable((String)"narration.slider.usage.focused"));
            } else {
                narrationElementOutput.add(NarratedElementType.USAGE, (Component)Component.translatable((String)"narration.slider.usage.hovered"));
            }
        }
    }

    public void renderWidget(GuiGraphics guiGraphics, int i, int j, float f) {
        Minecraft minecraft = Minecraft.getInstance();
        double stepWidth = (double)this.getWidth() / (double)this.steps;
        if (this.divideSteps) {
            for (int x = 0; x < this.steps; ++x) {
                guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, this.getSprite(), (int)((double)this.getX() + stepWidth * (double)x), this.getY(), (int)stepWidth, this.getHeight(), ARGB.white((float)this.alpha));
            }
        } else {
            guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, this.getSprite(), this.getX(), this.getY(), this.getWidth(), this.getHeight(), ARGB.white((float)this.alpha));
        }
        guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, this.getHandleSprite(), this.getX() + (int)(this.handlePosition * (double)(this.width - 8)), this.getY(), 8, this.getHeight(), ARGB.white((float)this.alpha));
        int k = this.active ? 0xFFFFFF : 0xA0A0A0;
        this.renderScrollingString(guiGraphics, minecraft.font, 2, k | Mth.ceil((float)(this.alpha * 255.0f)) << 24);
    }

    public void onClick(MouseButtonEvent mouseButtonEvent, boolean bl) {
        this.dragging = this.active;
        this.setValueFromMouse(mouseButtonEvent);
    }

    public void updateHandlePosition() {
        this.handlePosition = this.steps > 0 ? (double)((float)this.selectedStep / (float)this.steps) : (this.value - this.minValue) / this.range;
    }

    public void setFocused(boolean bl) {
        super.setFocused(bl);
        if (!bl) {
            this.canChangeValue = false;
        } else {
            InputType inputType = Minecraft.getInstance().getLastInputType();
            if (inputType == InputType.MOUSE || inputType == InputType.KEYBOARD_TAB) {
                this.canChangeValue = true;
            }
        }
    }

    public boolean keyPressed(KeyEvent keyEvent) {
        if (keyEvent.isSelection()) {
            this.canChangeValue = !this.canChangeValue;
            return true;
        }
        if (this.canChangeValue) {
            boolean leftKeyPressed = keyEvent.isLeft();
            boolean rightKeyPressed = keyEvent.isRight();
            if (leftKeyPressed || rightKeyPressed) {
                int f;
                int n = f = leftKeyPressed ? -1 : 1;
                if (this.steps == 0) {
                    this.setValue(Math.clamp(this.value + (double)f / this.range, this.minValue, this.maxValue));
                } else {
                    this.setValueStep(this.selectedStep + f);
                }
                return true;
            }
        }
        return false;
    }

    private void setValueFromMouse(double d) {
        this.handlePosition = Math.clamp((d - (double)(this.getX() + 4)) / (double)(this.width - 8), 0.0, 1.0);
        this.setValueInternal(this.handlePosition * this.range + this.minValue);
    }

    private void setValueFromMouse(MouseButtonEvent mouseButtonEvent) {
        double normalizedProgressFromMouse = Mth.clamp((double)((mouseButtonEvent.x() - (double)(this.getX() + 4)) / (double)(this.width - 8)), (double)0.0, (double)1.0);
        this.setValue(normalizedProgressFromMouse * this.range + this.minValue);
    }

    public void setValueStep(int step) {
        this.setValueInternal(this.minValue + (double)step / (double)this.steps * this.range);
        this.updateHandlePosition();
    }

    private void setValueInternal(double d) {
        double currentValue = this.value;
        int targetStep = -1;
        double targetValue = d;
        if (this.steps > 0) {
            targetStep = (int)Math.round((d - this.minValue) / this.range * (double)this.steps);
            targetValue = Mth.clamp((double)((double)targetStep / (double)this.steps * this.range + this.minValue), (double)this.minValue, (double)this.maxValue);
        }
        if (currentValue != targetValue) {
            this.value = (double)Math.round(targetValue * 100.0) / 100.0;
            this.selectedStep = targetStep;
            this.applyValue();
        }
        this.updateMessage();
    }

    public void setValue(double d) {
        this.setValueInternal(d);
        this.updateHandlePosition();
    }

    protected void onDrag(MouseButtonEvent mouseButtonEvent, double d, double e) {
        this.setValueFromMouse(mouseButtonEvent);
        super.onDrag(mouseButtonEvent, d, e);
    }

    public void playDownSound(SoundManager soundManager) {
    }

    public void onRelease(double d, double e) {
        super.playDownSound(Minecraft.getInstance().getSoundManager());
        if (this.divideSteps) {
            this.updateHandlePosition();
        }
    }

    protected abstract void updateMessage();

    protected abstract void applyValue();
}

