/*
 * Decompiled with CFR 0.152.
 */
package dev.mineland.item_interactions_mod;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.mineland.item_interactions_mod.CarriedInteractions.Spawners.GuiParticleSpawner;
import dev.mineland.item_interactions_mod.GlobalDirt;
import dev.mineland.item_interactions_mod.ItemInteractionsConfig;
import dev.mineland.item_interactions_mod.ItemInteractionsMod;
import dev.mineland.item_interactions_mod.SpawnerRegistry;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.components.toasts.ToastManager;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import org.jetbrains.annotations.NotNull;

public class GuiParticlesReloadListener
implements ResourceManagerReloadListener {
    private GuiParticleSpawner parseSpawner(JsonObject SpawnerJson, ResourceLocation id, ResourceManager resourceManager) {
        GlobalDirt.currentParticleSpawner = id.toString();
        ResourceLocation filePath = ResourceLocation.fromNamespaceAndPath((String)id.getNamespace(), (String)("gui_particle_spawners/" + id.getPath()));
        DataResult dataResult = GuiParticleSpawner.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)SpawnerJson);
        GuiParticleSpawner result = (GuiParticleSpawner)dataResult.resultOrPartial(s -> {
            if (!GlobalDirt.spawnerErrorList.containsKey(filePath)) {
                GlobalDirt.spawnerErrorList.put(filePath, new ArrayList());
            }
            GlobalDirt.spawnerErrorList.get(filePath).add((String)s);
            ItemInteractionsMod.warnMessage("Errors found in '" + String.valueOf(filePath) + "\n" + s, new Object[0]);
            ++GlobalDirt.spawnerErrorCount;
        }).orElseThrow();
        result.setName(id);
        return result;
    }

    private double trySet(JsonObject json, String member, double defaultValue) {
        try {
            return json.get(member).getAsDouble();
        }
        catch (Exception ignore) {
            return defaultValue;
        }
    }

    private void loadSpawners(ResourceManager resourceManager) {
        for (Map.Entry entry : resourceManager.listResources("gui_particle_spawners", resourceLocation -> resourceLocation.getPath().endsWith(".json")).entrySet()) {
            ResourceLocation id = (ResourceLocation)entry.getKey();
            Resource resource = (Resource)entry.getValue();
            if (ItemInteractionsConfig.debugDraws) {
                ItemInteractionsMod.infoMessage("Loading " + String.valueOf(id) + ":" + String.valueOf(resource));
            }
            try {
                InputStream stream = resource.open();
                try {
                    JsonObject json = JsonParser.parseReader((Reader)new InputStreamReader(stream)).getAsJsonObject();
                    GuiParticleSpawner a = this.parseSpawner(json, id, resourceManager);
                    SpawnerRegistry.register(a, id);
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            catch (Exception e) {
                ItemInteractionsMod.errorMessage("Couldn't parse '" + String.valueOf(id) + "': \n" + String.valueOf(e.getCause()), new Object[0]);
                if (!GlobalDirt.spawnerErrorList.containsKey(id)) {
                    GlobalDirt.spawnerErrorList.put(id, new ArrayList());
                }
                GlobalDirt.spawnerErrorList.get(id).add(e.getMessage());
                ++GlobalDirt.spawnerErrorCount;
            }
        }
    }

    private void loadStuff(ResourceManager resourceManager) {
        ItemInteractionsMod.infoMessage("Reloading gui particle spawners");
        SpawnerRegistry.clear();
        this.loadSpawners(resourceManager);
        String spawnerString = SpawnerRegistry.SPAWNER_MAP.size() == 1 ? "Parsed %d Gui particle spawner" : "Parsed %d Gui particle spawners";
        Object errorCountString = "";
        if (GlobalDirt.spawnerErrorCount == 1) {
            errorCountString = " (1 error)";
        } else if (GlobalDirt.spawnerErrorCount > 1) {
            errorCountString = " (" + GlobalDirt.spawnerErrorCount + " errors)";
        }
        ItemInteractionsMod.infoMessage(String.format(spawnerString + (String)errorCountString, SpawnerRegistry.SPAWNER_MAP.size()));
    }

    @NotNull
    public String getName() {
        return super.getName();
    }

    public void onResourceManagerReload(ResourceManager resourceManager) {
        GlobalDirt.isReloadingResources = true;
        GlobalDirt.spawnerErrorList.clear();
        GlobalDirt.particleErrorList.clear();
        GlobalDirt.spawnerErrorCount = 0;
        GlobalDirt.currentParticleSpawner = "";
        this.loadStuff(resourceManager);
        if (GlobalDirt.spawnerErrorCount > 0) {
            String errorTitle = GlobalDirt.spawnerErrorCount == 1 ? "%d Gui particle error" : "%d Gui particle errors";
            SystemToast.add((ToastManager)Minecraft.getInstance().getToastManager(), (SystemToast.SystemToastId)SystemToast.SystemToastId.PACK_LOAD_FAILURE, (Component)Component.literal((String)String.format(errorTitle, GlobalDirt.spawnerErrorCount)), (Component)Component.literal((String)"Check the logs for more information"));
        }
        GlobalDirt.isReloadingResources = false;
    }
}

