/*
 * Decompiled with CFR 0.152.
 */
package dev.mineland.item_interactions_mod;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.mineland.item_interactions_mod.GlobalDirt;
import dev.mineland.item_interactions_mod.ItemInteractionsConfig;
import dev.mineland.item_interactions_mod.ItemInteractionsMod;
import dev.mineland.item_interactions_mod.LineAlgs;
import dev.mineland.item_interactions_mod.MiscUtils;
import dev.mineland.item_interactions_mod.itemcarriedalgs.AnimTemplate;
import dev.mineland.item_interactions_mod.renderState.ColoredPolygonRenderState;
import dev.mineland.item_interactions_mod.renderState.GuiFloatingItemRenderState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.render.TextureSetup;
import net.minecraft.client.gui.render.state.GuiElementRenderState;
import net.minecraft.client.gui.render.state.GuiRenderState;
import net.minecraft.client.gui.render.state.pip.PictureInPictureRenderState;
import net.minecraft.client.renderer.CachedOrthoProjectionMatrixBuffer;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.item.TrackingItemStackRenderState;
import net.minecraft.world.entity.ItemOwner;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fc;
import org.joml.Quaternionf;
import org.joml.Vector2f;
import org.joml.Vector3f;

public class GuiRendererHelper {
    public static ItemStackRenderState currentItemStackRenderer;
    public static PoseStack currentPose;
    public static final CachedOrthoProjectionMatrixBuffer itemsProjectionMatrixBuffer;
    public static ItemStack prevItem;

    public static void clearItem() {
        currentItemStackRenderer = new ItemStackRenderState();
        currentPose = new PoseStack();
    }

    public static void renderItem(GuiRenderState guiRenderState, ItemStack itemStack, Level level, LivingEntity livingEntity, int k, Minecraft minecraft, int initialX, int initialY, int initialZ) {
        TrackingItemStackRenderState scratchItemStackRenderState = new TrackingItemStackRenderState();
        int x = initialX;
        int y = initialY;
        AnimTemplate anim = ItemInteractionsConfig.getAnimationSetting();
        if (anim == null) {
            return;
        }
        if (prevItem.isEmpty() && !itemStack.isEmpty()) {
            anim.reset(initialX, initialY, 1000);
        }
        prevItem = itemStack;
        GuiGraphics guiGraphics = new GuiGraphics(Minecraft.getInstance(), guiRenderState);
        PoseStack newPose = anim.makePose(initialX, initialY, 0, GlobalDirt.speedX, -GlobalDirt.speedY, GlobalDirt.isCurrentItem3d, guiGraphics);
        try {
            minecraft.getItemModelResolver().updateForTopItem((ItemStackRenderState)scratchItemStackRenderState, itemStack, ItemDisplayContext.GUI, level, (ItemOwner)livingEntity, k);
            AnimTemplate animationSetting = ItemInteractionsConfig.getAnimationSetting();
            float ivX = animationSetting.itemPos.x;
            float ivY = animationSetting.itemPos.y;
            int size = 64;
            int correction = size / 2 - 8;
            int x0 = (int)(ivX * 16.0f) + x - correction;
            int y0 = (int)(ivY * 16.0f) + y - correction;
            int x1 = (int)(ivX * 16.0f) + x - correction + size;
            int y1 = (int)(ivY * 16.0f) + y - correction + size;
            int scX = x + (int)(ivX * 16.0f) - correction;
            int scY = y + (int)(ivY * 16.0f) - correction;
            if (ItemInteractionsConfig.debugDraws) {
                guiGraphics.submitOutline(scX, scY, size, size, -1);
            }
            guiRenderState.submitPicturesInPictureState((PictureInPictureRenderState)new GuiFloatingItemRenderState(scratchItemStackRenderState, new Vector3f(), new Quaternionf(), null, x0, y0, x1, y1, 16.0f, null, newPose));
        }
        catch (Exception e) {
            ItemInteractionsMod.errorMessage("Crashed. " + String.valueOf(e), new Object[0]);
        }
    }

    public static void renderItem(GuiRenderState guiRenderState, ItemStack itemStack, Level level, LivingEntity livingEntity, int k, Minecraft minecraft, float initialX, float initialY, float initialZ) {
        TrackingItemStackRenderState scratchItemStackRenderState = new TrackingItemStackRenderState();
        int x = (int)initialX;
        int y = (int)initialY;
        AnimTemplate anim = ItemInteractionsConfig.getAnimationSetting();
        if (anim == null) {
            return;
        }
        if (prevItem.isEmpty() && !itemStack.isEmpty()) {
            anim.reset((int)initialX, (int)initialY, 1000);
        }
        prevItem = itemStack;
        GuiGraphics guiGraphics = new GuiGraphics(Minecraft.getInstance(), guiRenderState);
        PoseStack newPose = anim.makePose((int)initialX, (int)initialY, 0, GlobalDirt.speedX, GlobalDirt.speedY, GlobalDirt.isCurrentItem3d, guiGraphics);
        newPose.translate(initialX - (float)x, initialY - (float)y, initialZ - (float)Math.round(initialZ));
        try {
            minecraft.getItemModelResolver().updateForTopItem((ItemStackRenderState)scratchItemStackRenderState, itemStack, ItemDisplayContext.GUI, level, (ItemOwner)livingEntity, k);
            AnimTemplate animationSetting = ItemInteractionsConfig.getAnimationSetting();
            float ivX = animationSetting.itemPos.x;
            float ivY = animationSetting.itemPos.y;
            int size = 64;
            int correction = size / 2 - 8;
            int x0 = (int)(ivX * 16.0f) + x - correction;
            int y0 = (int)(ivY * 16.0f) + y - correction;
            int x1 = (int)(ivX * 16.0f) + x - correction + size;
            int y1 = (int)(ivY * 16.0f) + y - correction + size;
            int scX = x + (int)(ivX * 16.0f) - correction;
            int scY = y + (int)(ivY * 16.0f) - correction;
            if (ItemInteractionsConfig.debugDraws) {
                guiGraphics.submitOutline(scX, scY, size, size, -1);
            }
            guiRenderState.submitPicturesInPictureState((PictureInPictureRenderState)new GuiFloatingItemRenderState(scratchItemStackRenderState, new Vector3f(), new Quaternionf(), null, x0, y0, x1, y1, 16.0f, null, newPose));
        }
        catch (Exception e) {
            ItemInteractionsMod.errorMessage("Crashed. " + String.valueOf(e), new Object[0]);
        }
    }

    public static void setPixel(GuiGraphics guiGraphics, int x, int y, int color) {
        guiGraphics.fill(x, y, x + 1, y + 1, color);
    }

    public static void renderLine(GuiGraphics guiGraphics, int x0, int y0, int x1, int y1, int color) {
        GuiRendererHelper.renderLine(guiGraphics, x0, y0, x1, y1, color, true);
    }

    public static void renderLine(GuiGraphics guiGraphics, float x0, float y0, float x1, float y1, int color) {
        GuiRendererHelper.renderLine(guiGraphics, x0, y0, x1, y1, color, true);
    }

    public static void renderLine(GuiGraphics guiGraphics, float x0, float y0, float x1, float y1, int color, boolean pixelated) {
        if (pixelated) {
            if (x0 == x1 || y0 == y1) {
                int px = 0;
                int py = 0;
                if (y0 != y1) {
                    px = 1;
                }
                if (x0 != x1) {
                    py = 1;
                }
                guiGraphics.fill((int)x0, (int)y0, (int)x1 + px, (int)y1 + py, color);
                return;
            }
            LineAlgs.plotLine(guiGraphics, (int)x0, (int)y0, (int)x1, (int)y1, color);
            return;
        }
        VertexConsumer vertexConsumer = Minecraft.getInstance().renderBuffers().bufferSource().getBuffer(RenderType.lines());
        Vector2f p0 = new Vector2f(x0, y0);
        Vector2f p1 = new Vector2f(x1, y1);
        float angle = (float)Math.atan2(y1 - y0, x1 - x0);
        Vector2f[] points = new Vector2f[]{new Vector2f(), new Vector2f(), new Vector2f(), new Vector2f()};
        points[0] = MiscUtils.pointAtFrom(new Vector2f(1.5707964f + angle, 0.5f), p0);
        points[1] = MiscUtils.pointAtFrom(new Vector2f(1.5707964f + angle, 0.5f), p1);
        points[2] = MiscUtils.pointAtFrom(new Vector2f(-1.5707964f + angle, 0.5f), p1);
        points[3] = MiscUtils.pointAtFrom(new Vector2f(-1.5707964f + angle, 0.5f), p0);
        float brX = points[0].x();
        float brY = points[0].y();
        float trX = points[1].x();
        float trY = points[1].y();
        float tlX = points[2].x();
        float tlY = points[2].y();
        float blX = points[3].x();
        float blY = points[3].y();
        GlobalDirt.getGlobalGuiRenderState().submitGuiElement((GuiElementRenderState)new ColoredPolygonRenderState(RenderPipelines.GUI, TextureSetup.noTexture(), new Matrix3x2f((Matrix3x2fc)guiGraphics.pose()), new Vector2f(tlX, tlY), new Vector2f(trX, trY), new Vector2f(blX, blY), new Vector2f(brX, brY), color, color, null));
    }

    public static void renderLines_RepeatColors(GuiGraphics guiGraphics, float[][] points, int[] colors, boolean pixelated) {
        int pointsLength = points.length;
        int colorsLength = colors.length;
        int length = Math.max(pointsLength, colorsLength);
        int[] newColors = new int[length + 1];
        for (int i = 0; i <= length; ++i) {
            newColors[i] = colors[i % colors.length];
        }
        GuiRendererHelper.renderLines(guiGraphics, points, newColors, pixelated);
    }

    public static void renderLine_ColorPattern(GuiGraphics guiGraphics, float x0, float y0, float x1, float y1, int[] colors, int repeats, boolean pixelated) {
        if (repeats < 1) {
            repeats = 1;
        }
        if (MiscUtils.samePoint(x0, y0, x1, y1)) {
            return;
        }
        if (colors.length == 0) {
            return;
        }
        int length = repeats * colors.length;
        float[][] points = new float[1 + length][2];
        for (int i = 0; i <= length; ++i) {
            float progress = (float)i / (float)length;
            float x = MiscUtils.lerp(progress, x0, x1);
            float y = MiscUtils.lerp(progress, y0, y1);
            points[i] = new float[]{x, y};
        }
        GuiRendererHelper.renderLines_RepeatColors(guiGraphics, points, colors, pixelated);
    }

    private static void renderLines(GuiGraphics guiGraphics, float[][] points, int[] colors, boolean pixelated) {
        if (points.length == 0) {
            return;
        }
        if (pixelated) {
            GuiRendererHelper.renderPixelatedLines(guiGraphics, points, colors);
        } else {
            GuiRendererHelper.renderSmoothLines(guiGraphics, points, colors);
        }
    }

    private static void renderPixelatedLines(GuiGraphics guiGraphics, float[][] points, int[] colors) {
        if (points.length == 1) {
            GuiRendererHelper.setPixel(guiGraphics, (int)points[0][0], (int)points[0][1], colors[0]);
        }
        for (int i = 0; i < points.length - 1; ++i) {
            float[] currentPoint = points[i];
            float[] nextPoint = points[i + 1];
            if (MiscUtils.samePoint((int)currentPoint[0], (int)currentPoint[1], (int)nextPoint[0], (int)nextPoint[1])) continue;
            if (MiscUtils.outOfBoundsPoint(currentPoint[0], currentPoint[1])) break;
            GuiRendererHelper.renderLine(guiGraphics, currentPoint[0], currentPoint[1], nextPoint[0], nextPoint[1], colors[i], true);
        }
    }

    private static void renderSmoothLines(GuiGraphics guiGraphics, float[][] points, int[] colors) {
        VertexConsumer vertexConsumer = Minecraft.getInstance().renderBuffers().bufferSource().getBuffer(RenderType.lines());
        try {
            for (int i = 0; i < points.length - 1; ++i) {
                float x0 = points[i][0];
                float y0 = points[i][1];
                float x1 = points[i + 1][0];
                float y1 = points[i + 1][1];
                Vector2f p0 = new Vector2f(x0, y0);
                Vector2f p1 = new Vector2f(x1, y1);
                float angle = (float)Math.atan2(y1 - y0, x1 - x0);
                Vector2f[] quadPoints = new Vector2f[]{new Vector2f(), new Vector2f(), new Vector2f(), new Vector2f()};
                quadPoints[0] = MiscUtils.pointAtFrom(new Vector2f(1.5707964f + angle, 0.5f), p0);
                quadPoints[1] = MiscUtils.pointAtFrom(new Vector2f(1.5707964f + angle, 0.5f), p1);
                quadPoints[2] = MiscUtils.pointAtFrom(new Vector2f(-1.5707964f + angle, 0.5f), p1);
                quadPoints[3] = MiscUtils.pointAtFrom(new Vector2f(-1.5707964f + angle, 0.5f), p0);
                float brX = quadPoints[0].x();
                float brY = quadPoints[0].y();
                float trX = quadPoints[1].x();
                float trY = quadPoints[1].y();
                float tlX = quadPoints[2].x();
                float tlY = quadPoints[2].y();
                float blX = quadPoints[3].x();
                float blY = quadPoints[3].y();
                GlobalDirt.getGlobalGuiRenderState().submitGuiElement((GuiElementRenderState)new ColoredPolygonRenderState(RenderPipelines.GUI, TextureSetup.noTexture(), new Matrix3x2f((Matrix3x2fc)guiGraphics.pose()), new Vector2f(tlX, tlY), new Vector2f(trX, trY), new Vector2f(blX, blY), new Vector2f(brX, brY), colors[i], colors[i], null));
            }
        }
        catch (Exception e) {
            MiscUtils.displayErrorInUi(e.getMessage());
        }
    }

    static {
        itemsProjectionMatrixBuffer = new CachedOrthoProjectionMatrixBuffer("items", -1000.0f, 1000.0f, true);
        prevItem = ItemStack.EMPTY;
    }
}

