/*
 * Decompiled with CFR 0.152.
 */
package dev.mineland.item_interactions_mod.itemcarriedalgs;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.mineland.item_interactions_mod.GlobalDirt;
import dev.mineland.item_interactions_mod.GuiRendererHelper;
import dev.mineland.item_interactions_mod.ItemInteractionsConfig;
import dev.mineland.item_interactions_mod.MiscUtils;
import dev.mineland.item_interactions_mod.itemcarriedalgs.AnimTemplate;
import net.minecraft.client.gui.GuiGraphics;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class AnimRope
extends AnimTemplate {
    public double elasticity = 0.4;
    public double length = 16.0;
    public Vector3f gravity = new Vector3f(0.0f, 6.0f, 0.0f);
    public double inertia = 0.8;
    public boolean pixelated = true;
    int[] colors = new int[]{-5410231, -8109034};
    public double currentStress = 0.0;
    public float rotationAngle;
    Quaternionf rotation = new Quaternionf();
    public Vector3f globalItemPos = new Vector3f();
    public float angle = 0.0f;
    private boolean isStill = false;
    private float actualX = 0.0f;
    private float actualY = 0.0f;
    private float oldAngle = 0.0f;
    Vector3f prevPos = new Vector3f();
    Vector3f newPos = new Vector3f();
    Vector3f mousePos = new Vector3f();
    private final Vector3f oldMousePos = new Vector3f();
    boolean isDead = false;
    private final Vector3f smoothedMousePos = new Vector3f();
    private boolean firstTick = true;
    float accumulator = 0.0f;
    final float FIXED_STEP = 0.033333335f;
    final float MAX_ACCUMULATED_TIME = 0.25f;

    @Override
    public void refreshSettings() {
        this.length = (Double)this.getSetting("rope_length");
        this.elasticity = (Double)this.getSetting("rope_elasticity");
        this.inertia = (Double)this.getSetting("rope_inertia");
        this.gravity = (Vector3f)ItemInteractionsConfig.getSetting("rope_gravity");
        this.pixelated = (Boolean)this.getSetting("rope_pixelated");
    }

    public AnimRope() {
        super("rope");
        this.addSetting("rope_elasticity", 0.4);
        this.addSetting("rope_length", 16.0);
        this.addSetting("rope_gravity", new Vector3f(0.0f, 6.0f, 0.0f));
        this.addSetting("rope_inertia", 0.8);
        this.addSetting("rope_pixelated", true);
    }

    @Override
    public PoseStack makePose(int x, int y, int z, double doubleSpeedX, double doubleSpeedY, boolean is3d, GuiGraphics guiGraphics) {
        PoseStack pose = new PoseStack();
        this.ropeSim(guiGraphics, pose, x, y, z);
        return pose;
    }

    @Override
    public void reset(int initialX, int initialY, int initialZ) {
        this.isDead = false;
        this.resetValues(initialX, initialY, initialZ);
    }

    private void resetValues(int initialX, int initialY, int initialZ) {
        super.reset(initialX, initialY, initialZ);
        this.globalItemPos.set((float)initialX, (float)initialY, (float)initialZ);
        this.prevPos.set((Vector3fc)this.globalItemPos);
        this.rotation = new Quaternionf();
        this.rotationAngle = 0.0f;
        this.oldAngle = 0.0f;
        this.oldMousePos.set(0.0f, 0.0f, 0.0f);
        this.smoothedMousePos.set((float)initialX, (float)initialY, (float)initialZ);
        this.firstTick = true;
    }

    private void ropeSim(GuiGraphics guiGraphics, PoseStack pose, int x, int y, int z) {
        block6: {
            try {
                this.newPos.set((Vector3fc)this.globalItemPos);
                if (!GlobalDirt.skipCalcs) {
                    this.mousePos.set((float)x, (float)y, this.globalItemPos.z());
                    this.actualX = x;
                    this.actualY = y;
                    this.update(guiGraphics, x, y, z, GlobalDirt.msTickDelta);
                }
                Vector3f renderPos = new Vector3f((Vector3fc)this.prevPos).lerp((Vector3fc)this.newPos, this.accumulator * 30.0f);
                GuiRendererHelper.renderLine_ColorPattern(guiGraphics, x + 8, y + 8, (float)x + renderPos.x() - this.actualX + 8.0f, (float)y + renderPos.y() - this.actualY + 8.0f, this.colors, (int)(this.length / 8.0), this.pixelated);
                if (ItemInteractionsConfig.debugDraws) {
                    GuiRendererHelper.renderLine_ColorPattern(guiGraphics, x + 8, y + 8, (float)x + this.newPos.x() - this.actualX + 8.0f, (float)y + this.newPos.y() - this.actualY + 8.0f, new int[]{0x40FF0000}, (int)(this.length / 8.0), this.pixelated);
                }
                this.rotationAngle = (float)MiscUtils.lerpRotation(Math.clamp(this.currentStress, 0.0, 1.0), this.rotationAngle, this.angle);
                float rotationDelta = this.rotationAngle - this.oldAngle;
                if (rotationDelta == 0.0f && !this.isStill) {
                    this.isStill = true;
                    this.rotationAngle = (float)((double)this.rotationAngle % Math.PI);
                } else {
                    this.isStill = false;
                }
                this.oldAngle = this.rotationAngle;
                this.rotation.rotateZ(rotationDelta);
                this.globalItemPos.set((Vector3fc)this.newPos);
                this.itemPos.set((renderPos.x() - this.actualX) / 16.0f, (renderPos.y - this.actualY) / 16.0f, this.globalItemPos.z());
                pose.pushPose();
                pose.rotateAround((Quaternionfc)this.rotation, 0.0f, 0.0f, 16.0f);
                this.isDead = true;
            }
            catch (Exception e) {
                this.resetValues(x, y, z);
                if (!ItemInteractionsConfig.debugDraws || !this.isDead) break block6;
                String error = "(" + this.getClass().getName() + ") \n" + String.valueOf(e);
                this.isDead = false;
                MiscUtils.displayErrorInUi(error);
            }
        }
    }

    public void update(GuiGraphics guiGraphics, int x, int y, int z, float msTickDelta) {
        msTickDelta = Math.min(msTickDelta, 0.25f);
        this.accumulator += msTickDelta;
        while (this.accumulator >= 0.033333335f) {
            this.simulate(x, y, z, 0.33333334f * GlobalDirt.tickScale);
            this.accumulator -= 0.033333335f;
        }
    }

    public void simulate(int x, int y, int z, float delta) {
        float stretch;
        this.prevPos.set((Vector3fc)this.globalItemPos);
        this.actualX = x;
        this.actualY = y;
        if (this.firstTick) {
            this.smoothedMousePos.set((Vector3fc)this.mousePos);
            this.firstTick = false;
        } else {
            this.smoothedMousePos.lerp((Vector3fc)this.mousePos, 1.0f - (float)Math.pow(0.1, delta * 60.0f));
        }
        this.angle = (float)Math.atan2(this.newPos.y() - this.smoothedMousePos.y(), this.newPos.x() - this.smoothedMousePos.x());
        Vector3f ropeDir = new Vector3f(this.newPos.x() - this.smoothedMousePos.x(), this.newPos.y() - this.smoothedMousePos.y(), 0.0f);
        float ropeLen = ropeDir.length();
        this.currentStress = Math.max(0.0, ((double)ropeLen - this.length) / this.length);
        if (ropeLen != 0.0f) {
            ropeDir.div(ropeLen);
        }
        if ((stretch = (float)((double)ropeLen - this.length)) > 0.0f) {
            float springStrength = 10.0f;
            float springForceMag = Math.min(stretch * springStrength, 300.0f);
            Vector3f springForce = new Vector3f((Vector3fc)ropeDir).mul(springForceMag * delta);
            this.itemSpeed.sub((Vector3fc)springForce);
        }
        float gravityFactor = (float)(0.5 + this.inertia * this.inertia * 0.5);
        this.itemSpeed.add((Vector3fc)new Vector3f((Vector3fc)this.gravity).mul(gravityFactor * delta));
        float outwardSpeed = this.itemSpeed.dot((Vector3fc)ropeDir);
        Vector3f radialVel = new Vector3f((Vector3fc)ropeDir).mul(outwardSpeed);
        Vector3f tangentialVel = new Vector3f((Vector3fc)this.itemSpeed).sub((Vector3fc)radialVel);
        radialVel.mul(0.92f);
        tangentialVel.mul(0.995f);
        this.itemSpeed.set((Vector3fc)radialVel.add((Vector3fc)tangentialVel));
        this.newPos.add((Vector3fc)new Vector3f((Vector3fc)this.itemSpeed).mul(delta));
        float maxRopeLength = (float)(this.length * (1.0 + this.elasticity * 1.25));
        float newDistance = this.newPos.distance((Vector3fc)this.smoothedMousePos);
        if (newDistance > maxRopeLength) {
            Vector3f dir = new Vector3f((Vector3fc)this.newPos).sub((Vector3fc)this.smoothedMousePos).normalize();
            this.newPos.set(this.smoothedMousePos.x() + dir.x * maxRopeLength, this.smoothedMousePos.y() + dir.y * maxRopeLength, this.newPos.z());
            float overshootSpeed = this.itemSpeed.dot((Vector3fc)dir);
            if (overshootSpeed > 0.0f) {
                Vector3f outwardVel = new Vector3f((Vector3fc)dir).mul(overshootSpeed);
                this.itemSpeed.sub((Vector3fc)outwardVel).sub((Vector3fc)outwardVel.mul(0.05f));
            }
        }
        this.globalItemPos.set((Vector3fc)this.newPos);
    }
}

