/*
 * Decompiled with CFR 0.152.
 */
package dev.mineland.item_interactions_mod.CustomGuiComponents;

import dev.mineland.item_interactions_mod.GuiRendererHelper;
import dev.mineland.item_interactions_mod.MiscUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_5348;
import net.minecraft.class_6382;

public class GraphOverTimeWidget
extends class_339 {
    private final boolean showGraphTitle;
    private int titleWidth;
    private int valueWidth = 0;
    double maxGraphY;
    double minGraphY;
    float zLayer;
    int graphDataLength;
    double graphDataHeight;
    boolean showYAxis;
    int graphDivisions;
    boolean showCurrentValue;
    int graphVisualWidth;
    int graphVisualHeight;
    String[] yAxisMarkers;
    private int colorLineNew = -1;
    private int colorLineOld = -1;
    private int colorBackground = -1073741824;
    private int colorOutline = -1;
    private boolean pixelatedGraph;
    private int timeIndex = 0;
    private int decimalPrecision = 3;
    double[] points;
    int yAxisLabelWidth = 0;
    static int padding = 2;
    static int lineHeight;
    List<Marker> markers;
    protected final PointGetter pointGetter;
    private boolean updateGraphEveryFrame = false;
    private boolean overdraw = false;
    boolean dead;

    public static Builder builder(class_2561 graphTitle, PointGetter pointGetter, boolean updateGraphEveryFrame) {
        return new Builder(graphTitle, pointGetter, updateGraphEveryFrame);
    }

    public static Builder builder(String graphTitle, PointGetter pointGetter, boolean updateGraphEveryFrame) {
        return new Builder((class_2561)class_2561.method_43470((String)graphTitle), pointGetter, updateGraphEveryFrame);
    }

    public GraphOverTimeWidget(int x, int y, float zLayer, int width, int height, int graphWidth, int graphHeight, boolean overdraw, double minGraphY, double maxGraphY, int graphDataLength, int decimalPrecision, boolean showYAxis, int graphDivisions, int newerColor, int olderColor, int backgroundColor, int outlineColor, boolean showCurrentValue, boolean pixelatedGraph, PointGetter pointGetter, boolean updateGraphEveryFrame, List<Marker> markers, boolean showGraphTitle, class_2561 message) {
        super(x, y, width, height, message);
        this.minGraphY = minGraphY;
        this.maxGraphY = maxGraphY;
        this.overdraw = overdraw;
        this.graphDataLength = graphDataLength;
        this.decimalPrecision = decimalPrecision;
        this.showYAxis = showYAxis;
        this.graphDivisions = graphDivisions + 1;
        this.colorLineNew = newerColor;
        this.colorLineOld = olderColor;
        this.colorBackground = backgroundColor;
        this.colorOutline = outlineColor;
        this.pixelatedGraph = pixelatedGraph;
        this.pointGetter = pointGetter;
        this.updateGraphEveryFrame = updateGraphEveryFrame;
        this.showGraphTitle = showGraphTitle;
        this.showCurrentValue = showCurrentValue;
        this.graphDataHeight = maxGraphY - minGraphY;
        this.graphVisualWidth = graphWidth;
        this.graphVisualHeight = graphHeight;
        class_327 FONT = class_310.method_1551().field_1772;
        if (showYAxis) {
            this.yAxisLabelWidth = Math.max(MiscUtils.numberMaxDecimal(minGraphY, decimalPrecision).length(), MiscUtils.numberMaxDecimal(maxGraphY, decimalPrecision).length());
            for (int i = 0; i <= graphDivisions; ++i) {
                double num = MiscUtils.lerp((double)i / (double)graphDivisions, minGraphY, maxGraphY);
                this.yAxisLabelWidth = Math.max(FONT.method_1727(MiscUtils.numberMaxDecimal(num, decimalPrecision) + " "), this.yAxisLabelWidth);
            }
        }
        if (showGraphTitle) {
            this.titleWidth = FONT.method_1727(message.getString());
        }
        if (showCurrentValue) {
            this.valueWidth = FONT.method_1727("0000." + "0".repeat(decimalPrecision));
        }
        this.points = new double[graphDataLength];
        this.markers = markers;
    }

    public void setPixelatedGraph(boolean v) {
        this.pixelatedGraph = v;
    }

    public void displayCurrentValue(boolean v) {
        this.showCurrentValue = v;
    }

    public void setBackgroundColor(int color) {
        this.colorBackground = color;
    }

    public void setColor(int color) {
        this.setColor(color, color);
    }

    public void setColor(int colStart, int colEnd) {
        this.setColorFresh(colStart);
        this.setColorOld(colEnd);
    }

    public void setColorFresh(int col) {
        this.colorLineNew = col;
    }

    public void setColorOld(int col) {
        this.colorLineOld = col;
    }

    protected void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (!this.field_22764) {
            return;
        }
        class_327 FONT = class_310.method_1551().field_1772;
        guiGraphics.method_51448().pushMatrix();
        guiGraphics.method_25294(this.method_46426(), this.method_46427(), this.method_46426() + this.method_25368(), this.method_46427() + this.method_25364(), this.colorBackground);
        guiGraphics.method_73198(this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364(), this.colorOutline);
        GuiRendererHelper.renderLine_ColorPattern(guiGraphics, (float)this.method_46426() + (float)this.method_25368() / 2.0f, this.method_46427(), (float)this.method_46426() + (float)this.method_25368() / 2.0f, this.method_46427() + this.method_25364(), new int[]{0x20FFFFFF, 0}, 8, true);
        GuiRendererHelper.renderLine_ColorPattern(guiGraphics, this.method_46426(), (float)this.method_46427() + (float)this.method_25364() / 2.0f, this.method_46426() + this.method_25368(), (float)this.method_46427() + (float)this.method_25364() / 2.0f, new int[]{0x20FFFFFF, 0}, 8, true);
        if (this.showGraphTitle) {
            guiGraphics.method_27534(FONT, this.method_25369(), this.method_46426() + this.method_25368() / 2, this.method_46427() + padding + 1, -1);
        }
        if (this.showCurrentValue) {
            guiGraphics.method_25300(FONT, MiscUtils.numberMaxDecimal(this.getCurrentValue(), this.decimalPrecision), this.method_46426() + this.method_25368() / 2, this.method_46427() + this.method_25364() - lineHeight - 1, -1);
        }
        try {
            if (this.updateGraphEveryFrame) {
                this.plotPoint();
            }
            for (int i = 0; i <= this.graphDivisions; ++i) {
                int y;
                int n = y = i == 0 ? this.getGraphY() + this.getGraphHeight() - 1 : Math.round((float)(this.getGraphY() + this.getGraphHeight()) - (float)i * (float)this.getGraphHeight() / (float)this.graphDivisions - 0.5f);
                if (y != 0 && y != this.graphDivisions) {
                    GuiRendererHelper.renderLine(guiGraphics, this.getGraphX(), y, this.getGraphX() + this.getGraphWidth(), y, -2139062144, this.pixelatedGraph);
                }
                if (!this.showYAxis) continue;
                String string = MiscUtils.numberMaxDecimal(MiscUtils.lerp((double)((float)i / (float)this.graphDivisions), this.minGraphY, this.maxGraphY), this.decimalPrecision) + " ";
                int n2 = this.getGraphX() - FONT.method_1727(string);
                Objects.requireNonNull(FONT);
                guiGraphics.method_25303(FONT, string, n2, y - 9 / 2 + 1, -1);
            }
            this.markers.forEach(marker -> {
                int y = Math.round((float)(this.getGraphY() + this.getGraphHeight()) - (float)(marker.val * (double)this.getGraphHeight() / this.graphDataHeight) - 0.5f);
                GuiRendererHelper.renderLine(guiGraphics, this.getGraphX(), y, this.getGraphX() + this.getGraphWidth(), y, marker.color);
                if (this.showYAxis) {
                    String string = MiscUtils.numberMaxDecimal(marker.val, this.decimalPrecision) + " ";
                    int left = this.getGraphX() - FONT.method_1727(string);
                    int right = this.getGraphX();
                    Objects.requireNonNull(FONT);
                    int top = y - 9 / 2;
                    Objects.requireNonNull(FONT);
                    int bottom = y + 9 / 2 + 1;
                    Objects.requireNonNull(FONT);
                    guiGraphics.method_25303(FONT, string, left, y - 9 / 2 + 1, marker.color);
                    guiGraphics.method_25294(left, top, right, bottom, MiscUtils.applyBrightness(marker.color, 0.25));
                }
            });
            guiGraphics.method_73198(this.getGraphX(), this.getGraphY(), this.getGraphWidth(), this.getGraphHeight(), -1);
            if (!this.overdraw) {
                guiGraphics.method_44379(this.getGraphX(), this.getGraphY(), this.getGraphX() + this.getGraphWidth(), this.getGraphY() + this.getGraphHeight());
            }
            float prevX = 0.0f;
            float prevY = 0.0f;
            for (int i = 0; i < this.points.length; ++i) {
                int entry = (this.timeIndex + i + 1) % this.graphDataLength;
                if (Double.isNaN(this.points[entry])) continue;
                float posX = (float)Math.floor((double)i * (double)this.getGraphWidth() / (double)this.graphDataLength);
                float posY = (float)((this.points[entry] - this.minGraphY) * (double)this.getGraphHeight() / this.graphDataHeight) + 1.0f;
                int color = MiscUtils.colorLerp((float)i / (float)this.points.length, this.colorLineNew, this.colorLineOld);
                if (i != 0) {
                    GuiRendererHelper.renderLine(guiGraphics, (float)this.getGraphX() + prevX, (float)(this.getGraphY() + this.getGraphHeight()) - prevY, (float)this.getGraphX() + posX, (float)(this.getGraphY() + this.getGraphHeight()) - posY, color, this.pixelatedGraph);
                }
                prevX = posX;
                prevY = posY;
            }
            if (!this.overdraw) {
                guiGraphics.method_44380();
            }
            guiGraphics.method_51448().popMatrix();
        }
        catch (Exception e) {
            MiscUtils.displayErrorInUi(e.toString());
        }
    }

    public void plotPoint() {
        this.plotPoint(this.pointGetter.pointGetter(this));
    }

    public void plotPoint(double y) {
        ++this.timeIndex;
        this.points[this.timeIndex % this.graphDataLength] = y;
    }

    public void plotPoint(float y) {
        this.plotPoint((double)y);
    }

    public void plotPoint(int y) {
        this.plotPoint((double)y);
    }

    public double getCurrentValue() {
        return this.points[this.timeIndex % this.graphDataLength];
    }

    protected void method_47399(class_6382 narrationElementOutput) {
    }

    private boolean notPureGraph() {
        return this.showYAxis || this.showGraphTitle || this.showCurrentValue;
    }

    private int getGraphX() {
        int res = this.method_46426();
        if (this.showYAxis && !this.showCurrentValue && !this.showGraphTitle) {
            res += this.yAxisLabelWidth + padding + 1;
        } else if (this.notPureGraph()) {
            res += this.method_25368() / 2 - this.getGraphWidth() / 2 + 1;
        }
        return res;
    }

    private int getGraphY() {
        int res = this.method_46427();
        if (this.showYAxis || this.showGraphTitle || this.showCurrentValue) {
            ++res;
        }
        if (this.showYAxis) {
            res += padding + lineHeight / 2;
        }
        if (this.showGraphTitle) {
            res += padding + lineHeight;
        }
        return res;
    }

    private int getGraphWidth() {
        int res = this.graphVisualWidth;
        return res;
    }

    private int getGraphHeight() {
        int res = this.graphVisualHeight;
        return res;
    }

    public void addMarker(double yPos, int color, String label) {
        this.markers.add(new Marker(yPos, color, label));
        this.yAxisLabelWidth = Math.max(this.yAxisLabelWidth, class_310.method_1551().field_1772.method_1727(MiscUtils.numberMaxDecimal(yPos, this.decimalPrecision)));
    }

    public void addMarker(double yPos) {
        this.addMarker(yPos, -1, "m" + this.markers.size());
    }

    public void addMarker(double yPos, String label) {
        this.addMarker(yPos, -1, label);
    }

    public void addMarker(double yPos, int color) {
        this.addMarker(yPos, color, "m" + this.markers.size());
    }

    public int getGraphDataLength() {
        return this.graphDataLength;
    }

    public double getGraphDataHeight() {
        return this.graphDataHeight;
    }

    static {
        Objects.requireNonNull(class_310.method_1551().field_1772);
        lineHeight = 9;
    }

    public static class Builder {
        private final class_2561 graphTitle;
        private final PointGetter pointGetter;
        int x;
        int y;
        int width;
        int height;
        private int graphWidth;
        private int graphHeight;
        private double maxGraphY = 0.0;
        private double minGraphY = 0.0;
        private int graphDataLength = 60;
        private int graphDivisions = 0;
        private boolean showYAxis = true;
        private boolean showCurrentValue = false;
        private boolean titleVisible = true;
        private final List<Marker> yAxisMarkers = new ArrayList<Marker>();
        private int newDataColor = -1;
        private int oldDataColor = -1;
        private int colorBackground = -1073741824;
        private int colorOutline = -1;
        private boolean pixelatedGraph = true;
        private boolean overdraw = false;
        private final boolean updateGraphEveryFrame;
        private int decimalPrecision = 3;
        private int yAxisLabelWidth = 0;
        private boolean sizedFromInnerGraph = false;
        private float sizedScale = 1.0f;
        private float zLayer = 0.0f;

        public Builder(class_2561 graphTitle, PointGetter pointGetter) {
            this(graphTitle, pointGetter, true);
        }

        public Builder(class_2561 graphTitle, PointGetter pointGetter, boolean updateGraphEveryFrame) {
            this.graphTitle = graphTitle;
            this.pointGetter = pointGetter;
            this.updateGraphEveryFrame = updateGraphEveryFrame;
        }

        private void refreshYAxisLabelLength() {
            this.yAxisLabelWidth = Math.max(MiscUtils.numberMaxDecimal(this.minGraphY, this.decimalPrecision).length(), MiscUtils.numberMaxDecimal(this.maxGraphY, this.decimalPrecision).length());
            for (Marker m : this.yAxisMarkers) {
                double num = m.val;
                this.yAxisLabelWidth = Math.max(class_310.method_1551().field_1772.method_1727(MiscUtils.numberMaxDecimal(num, this.decimalPrecision) + " "), this.yAxisLabelWidth);
            }
            for (int i = 0; i <= this.graphDivisions; ++i) {
                double num = MiscUtils.lerp((double)i / (double)this.graphDivisions, this.minGraphY, this.maxGraphY);
                this.yAxisLabelWidth = Math.max(class_310.method_1551().field_1772.method_1727(MiscUtils.numberMaxDecimal(num, this.decimalPrecision) + " "), this.yAxisLabelWidth);
            }
        }

        public GraphOverTimeWidget build() {
            if (this.sizedFromInnerGraph) {
                this.size_fromInnerGraph(this.graphDataLength, this.minGraphY, this.maxGraphY, this.sizedScale);
            }
            return new GraphOverTimeWidget(this.x, this.y, this.zLayer, this.width, this.height, this.graphWidth, this.graphHeight, this.overdraw, this.minGraphY, this.maxGraphY, this.graphDataLength, this.decimalPrecision, this.showYAxis, this.graphDivisions, this.newDataColor, this.oldDataColor, this.colorBackground, this.colorOutline, this.showCurrentValue, this.pixelatedGraph, this.pointGetter, this.updateGraphEveryFrame, this.yAxisMarkers, this.titleVisible, this.graphTitle);
        }

        public Builder pos(int x, int y) {
            this.x = x;
            this.y = y;
            return this;
        }

        public Builder size(int width, int height) {
            this.width = width;
            this.height = height;
            if (!(this.showCurrentValue || this.showYAxis || this.titleVisible)) {
                this.graphWidth = width;
                this.graphHeight = height;
            } else {
                int subY = 0;
                int subX = padding * 2;
                if (this.showYAxis) {
                    subY += lineHeight + padding + padding;
                    subX += this.yAxisLabelWidth;
                    if (this.titleVisible || this.showCurrentValue) {
                        subX += this.yAxisLabelWidth;
                    }
                }
                if (this.titleVisible) {
                    subY += lineHeight + padding;
                }
                if (this.showCurrentValue) {
                    subY += lineHeight + padding;
                }
                this.graphWidth = width - subX;
                this.graphHeight = height - subY;
            }
            this.sizedFromInnerGraph = false;
            return this;
        }

        public Builder size_fromInnerGraph(int dataSize, double height) {
            return this.size_fromInnerGraph(dataSize, 0.0, height, 1.0f);
        }

        public Builder size_fromInnerGraph(int dataSize, double height, float scale) {
            return this.size_fromInnerGraph(dataSize, 0.0, height, scale);
        }

        public Builder size_fromInnerGraph(int dataSize, double start, double end) {
            return this.size_fromInnerGraph(dataSize, start, end, 1.0f);
        }

        public Builder size_fromInnerGraph(int dataSize, double start, double end, float scale) {
            int widthScaled;
            this.sizedFromInnerGraph = true;
            this.sizedScale = scale;
            int height = widthScaled = (int)(Math.abs(end - start) * (double)scale);
            int width = dataSize;
            if (this.showYAxis || this.titleVisible || this.showCurrentValue) {
                height += 2;
                width += 2;
            }
            this.graphWidth = dataSize;
            this.graphHeight = widthScaled;
            class_327 FONT = class_310.method_1551().field_1772;
            if (this.titleVisible || this.showCurrentValue || this.showYAxis) {
                int titleWidth = FONT.method_27525((class_5348)this.graphTitle) + padding + padding;
                int valueWidth = FONT.method_1727("000000.000") + padding + padding;
                int yAxisWidth = dataSize + this.yAxisLabelWidth + padding;
                if (this.titleVisible || this.showCurrentValue) {
                    yAxisWidth += this.yAxisLabelWidth + padding;
                }
                if (this.showYAxis) {
                    this.refreshYAxisLabelLength();
                    height += lineHeight + padding * 2;
                }
                if (this.titleVisible) {
                    height += lineHeight + padding;
                }
                if (this.showCurrentValue) {
                    height += lineHeight + padding + (this.showYAxis ? 0 : padding);
                }
                width = MiscUtils.max(titleWidth, valueWidth, yAxisWidth, width);
            }
            this.width = width;
            this.height = height;
            return this.graphRange(start, end).dataLength(dataSize);
        }

        public Builder graphRange(double start, double end) {
            this.minGraphY = Math.min(start, end);
            this.maxGraphY = Math.max(start, end);
            return this;
        }

        public Builder dataLength(int size) {
            this.graphDataLength = size;
            return this;
        }

        public Builder addMarker(String name, double value) {
            this.yAxisMarkers.add(new Marker(value, -1, name));
            this.yAxisLabelWidth = Math.max(class_310.method_1551().field_1772.method_1727(MiscUtils.numberMaxDecimal(value, this.decimalPrecision) + " "), this.yAxisLabelWidth);
            return this;
        }

        public Builder decimalPrecision(int digits) {
            this.decimalPrecision = digits;
            return this;
        }

        public Builder lineColor(int color) {
            return this.lineColor(color, color);
        }

        public Builder lineColor(int newDataColor, int oldDataColor) {
            this.newDataColor = newDataColor;
            this.oldDataColor = oldDataColor;
            return this;
        }

        public Builder background(int color) {
            this.colorBackground = color;
            return this;
        }

        public Builder outline(int color) {
            this.colorOutline = color;
            return this;
        }

        public Builder background(int backgroundColor, int outlineColor) {
            this.colorOutline = outlineColor;
            this.colorBackground = backgroundColor;
            return this;
        }

        public Builder showTitle() {
            return this.showTitle(true);
        }

        public Builder showTitle(boolean visible) {
            this.titleVisible = visible;
            return this;
        }

        public Builder smoothGraph() {
            return this.pixelatedGraph(false);
        }

        public Builder pixelatedGraph() {
            return this.pixelatedGraph(true);
        }

        public Builder pixelatedGraph(boolean value) {
            this.pixelatedGraph = value;
            return this;
        }

        public Builder setZLayer(float z) {
            this.zLayer = z;
            return this;
        }

        public Builder showYAxis() {
            return this.showYAxis(true);
        }

        public Builder hideYAxis() {
            return this.showYAxis(false);
        }

        public Builder showYAxis(boolean value) {
            this.showYAxis = value;
            return this;
        }

        public Builder graphDivisions(int n) {
            this.graphDivisions = n;
            return this;
        }

        public Builder showCurrentValue() {
            return this.showCurrentValue(true);
        }

        public Builder showCurrentValue(boolean visible) {
            this.showCurrentValue = visible;
            return this;
        }

        public Builder allowOverdraw() {
            this.overdraw = true;
            return this;
        }

        public Builder allowOverdraw(boolean v) {
            this.overdraw = v;
            return this;
        }
    }

    public static interface PointGetter {
        public double pointGetter(GraphOverTimeWidget var1);
    }

    public static class Marker {
        public double val;
        public int color;
        public String label;

        public Marker(double val, int color, String label) {
            this.val = val;
            this.color = color;
            this.label = label;
        }
    }
}

