/*
 * Decompiled with CFR 0.152.
 */
package dev.mineland.item_interactions_mod.CustomGuiComponents;

import dev.mineland.item_interactions_mod.CarriedInteractions.GuiParticleSpawnersLogic;
import dev.mineland.item_interactions_mod.GlobalDirt;
import dev.mineland.item_interactions_mod.ItemInteractionsConfig;
import dev.mineland.item_interactions_mod.ItemInteractionsMod;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_310;
import net.minecraft.class_332;
import org.jetbrains.annotations.NotNull;

public class ClientFakeContainer
implements class_1263 {
    private final List<class_1735> slots = new ArrayList<class_1735>();
    private final List<class_1799> itemStacks = new ArrayList<class_1799>();
    private class_1799 mouseItem;
    private int x;
    private int y;
    private int slotSize = 18;
    private int columns;
    private int rows;

    public ClientFakeContainer(int columns, int rows, int left, int top) {
        int id = 0;
        this.x = left;
        this.y = top;
        this.columns = columns;
        this.rows = rows;
        int slotSize = this.slotSize;
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                class_1735 newSlot = new class_1735((class_1263)this, id, left + j * slotSize, top + i * slotSize);
                newSlot.field_7874 = id++;
                class_1799 newEmptyItem = new class_1799((class_1935)class_1799.field_8037.method_7909());
                this.slots.add(newSlot);
                this.itemStacks.add(newEmptyItem);
            }
        }
        this.mouseItem = class_1799.field_8037;
    }

    public void setX(int x) {
        this.x = x;
        this.updateSlots();
    }

    public void setY(int y) {
        this.y = y;
        this.updateSlots();
    }

    public void setPos(int x, int y) {
        this.x = x;
        this.y = y;
        this.updateSlots();
    }

    public void updateSlots() {
        int id = 0;
        for (int i = 0; i < this.columns; ++i) {
            for (int j = 0; j < this.rows; ++j) {
                class_1735 newSlot = new class_1735((class_1263)this, id, this.x + j * this.slotSize, this.y + i * this.slotSize);
                newSlot.field_7874 = id;
                class_1799 oldItem = this.slots.get(id).method_7677();
                newSlot.method_7673(oldItem);
                this.slots.set(id, newSlot);
                ++id;
            }
        }
    }

    public int method_5439() {
        return this.slots.size();
    }

    public void renderSlots(class_332 guiGraphics) {
        GlobalDirt.slotCount = 0;
        for (class_1735 slot : this.slots) {
            if (slot.method_7677().method_7960()) {
                ++GlobalDirt.slotCount;
                continue;
            }
            int itemX = slot.field_7873 + 1;
            int itemY = slot.field_7872 + 1;
            guiGraphics.method_51427(slot.method_7677(), itemX, itemY);
            guiGraphics.method_51431(class_310.method_1551().field_1772, slot.method_7677(), itemX, itemY);
            if (!ItemInteractionsConfig.enableGuiParticles) continue;
            GuiParticleSpawnersLogic.checkAndTick(guiGraphics, slot, false, 0, 0, GlobalDirt.slotCount);
            ++GlobalDirt.slotCount;
        }
    }

    public void renderMouseItem(class_332 guiGraphics, int x, int y) {
        GlobalDirt.carriedItem = this.mouseItem;
        guiGraphics.method_51427(this.mouseItem, x - 8, y - 8);
        guiGraphics.method_51431(class_310.method_1551().field_1772, this.mouseItem, x - 8, y - 8);
    }

    public void render(class_332 guiGraphics, int mouseX, int mouseY) {
        this.renderSlots(guiGraphics);
        guiGraphics.method_51448().pushMatrix();
        guiGraphics.method_51448().translate(0.0f, 0.0f);
        this.renderMouseItem(guiGraphics, mouseX, mouseY);
        guiGraphics.method_51448().translate(0.0f, 0.0f);
        guiGraphics.method_51448().popMatrix();
        GlobalDirt.skipCalcs = true;
        guiGraphics.method_51427(this.mouseItem, this.x + 18, this.y - 36);
        GlobalDirt.skipCalcs = false;
        GuiParticleSpawnersLogic.mainLogic(guiGraphics);
        GlobalDirt.carriedItem = class_1799.field_8037;
    }

    public void printItemStacks() {
        ItemInteractionsMod.infoMessage(this.itemStacks.toString());
    }

    public boolean method_5442() {
        return false;
    }

    public class_1799 method_5438(int i) {
        if (i > this.slots.size()) {
            return class_1799.field_8037;
        }
        if (i < 0) {
            return this.mouseItem;
        }
        return this.itemStacks.get(i);
    }

    public class_1799 method_5434(int id, int count) {
        return this.slots.get(id).method_7677().method_7971(count);
    }

    @NotNull
    public class_1799 method_5441(int id) {
        if (id >= this.slots.size() || id < 0) {
            return class_1799.field_8037;
        }
        class_1799 oldItem = this.slots.get(id).method_7677();
        this.slots.get(id).method_7673(class_1799.field_8037);
        return oldItem;
    }

    public void method_5447(int i, class_1799 itemStack) {
        this.itemStacks.set(i, itemStack);
    }

    public void method_5431() {
    }

    public boolean method_5443(class_1657 player) {
        return false;
    }

    public void method_5448() {
    }

    public boolean method_5437(int i, class_1799 itemStack) {
        return super.method_5437(i, itemStack);
    }

    public boolean method_49104(class_1263 container, int i, class_1799 itemStack) {
        return super.method_49104(container, i, itemStack);
    }

    public class_1799 getMouseItem() {
        return this.mouseItem;
    }

    public void mouseClicked(double x, double y, int mouseButton) {
        int slotX = (int)Math.floor((x - (double)this.x) / (double)this.slotSize);
        int slotY = (int)Math.floor((y - (double)this.y) / (double)this.slotSize);
        int slotId = this.columns * slotY + slotX;
        if (slotX < 0 || slotY < 0 || slotX >= this.columns || slotY >= this.rows || slotId >= this.slots.size()) {
            return;
        }
        this.mouseClicked(slotId, mouseButton);
    }

    public void mouseClicked(int slotId, int mouseButton) {
        if (slotId < 0 || slotId >= this.slots.size()) {
            return;
        }
        class_1735 targetSlot = this.slots.get(slotId);
        switch (mouseButton) {
            case 0: {
                if (this.mouseItem.method_7960() && targetSlot.method_7681()) {
                    this.mouseItem = targetSlot.method_7677();
                    targetSlot.method_7673(class_1799.field_8037);
                    break;
                }
                if (!this.mouseItem.method_7960() && targetSlot.method_7681()) {
                    class_1799 oldMouse = this.mouseItem.method_7972();
                    this.mouseItem = targetSlot.method_7677();
                    targetSlot.method_7673(oldMouse);
                }
                this.mouseItem = targetSlot.method_32756(this.mouseItem);
                break;
            }
            case 1: {
                if (this.mouseItem.method_7960() && targetSlot.method_7681()) {
                    int takeCount = targetSlot.method_7677().method_7947();
                    this.mouseItem = targetSlot.method_7677().method_7971(takeCount / 2);
                    break;
                }
                if (this.mouseItem.method_7960()) break;
                this.mouseItem = targetSlot.method_32755(this.mouseItem, 1);
            }
        }
        GlobalDirt.carriedItem = this.mouseItem;
    }
}

