/*
 * Decompiled with CFR 0.152.
 */
package dev.mineland.item_interactions_mod;

import dev.mineland.item_interactions_mod.ItemInteractionsMod;
import dev.mineland.item_interactions_mod.MiscUtils;
import dev.mineland.item_interactions_mod.itemcarriedalgs.AnimTemplate;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Scanner;
import java.util.TreeMap;
import org.joml.Vector3f;

public class ItemInteractionsConfig {
    private static final Path configPath = Path.of("config", "item_interactions.cfg");
    public static String animationConfig;
    public static boolean enableGuiParticles;
    public static boolean smoothGuiParticles;
    public static boolean debugDraws;
    public static HashMap<String, Object> settingsMap;
    public static HashMap<String, Object> defaultSettingsMap;
    public static HashMap<String, AnimTemplate> animations;
    public static HashMap<String, AnimTemplate> defaultAnimations;
    public static List<AnimTemplate> animationList;
    private static AnimTemplate currentAnimationSelected;
    private static List<AnimTemplate> animIndexes;

    public static Object getSetting(String setting) {
        if (settingsMap.get(setting) == null) {
            return ItemInteractionsConfig.getDefaultSetting(setting);
        }
        return settingsMap.getOrDefault(setting, ItemInteractionsConfig.getDefaultSetting(setting));
    }

    public static void setSetting(String setting, Object value) {
        try {
            if (defaultSettingsMap.get(setting) == null) {
                ItemInteractionsMod.errorMessage(String.format("Tried setting %s to %s but it doesn't exist", setting, value), new Object[0]);
                return;
            }
            if (value == null) {
                ItemInteractionsMod.errorMessage("Tried setting '%s' to *null*", setting);
                return;
            }
            if (!value.getClass().equals(defaultSettingsMap.get(setting).getClass())) {
                ItemInteractionsMod.errorMessage(String.format("Failed to set %s (%s) to setting %s (%s)", value, value.getClass().getName(), setting, settingsMap.get(setting).getClass().getName()), new Object[0]);
                return;
            }
            settingsMap.put(setting, value);
        }
        catch (Exception e) {
            MiscUtils.displayErrorInUi(String.format("setSetting(%s, %s): %s", setting, value, e));
        }
    }

    public static void resetSetting(String setting) {
        if (defaultSettingsMap.containsKey(setting)) {
            settingsMap.put(setting, defaultSettingsMap.get(setting));
        }
    }

    public static void setAnimationSetting(String id) {
        ItemInteractionsConfig.setSetting("animation", id);
        currentAnimationSelected = animations.getOrDefault(id, animations.get("speed"));
    }

    public static Object getDefaultSetting(String setting) {
        return defaultSettingsMap.get(setting);
    }

    public static void addAnimation(AnimTemplate anim) {
        animationList.add(anim);
        defaultSettingsMap.putAll(anim.getSettingsList());
    }

    public static void refreshAnimList() {
        animations.clear();
        animationList.forEach(t -> {
            animations.put(t.getId(), (AnimTemplate)t);
            settingsMap.putAll(t.getSettingsList());
        });
        animations.put("none", new AnimTemplate("none"));
    }

    private static void putDefault(String setting, Object value) {
        settingsMap.put(setting, value);
        defaultSettingsMap.put(setting, value);
    }

    public static void init() {
        settingsMap.clear();
        ItemInteractionsConfig.refreshAnimList();
        ItemInteractionsConfig.putDefault("gui_particles", true);
        ItemInteractionsConfig.putDefault("debug", false);
        ItemInteractionsConfig.putDefault("animation", "speed");
        ItemInteractionsConfig.putDefault("gui_smooth_particles", false);
        currentAnimationSelected = animations.get("speed");
    }

    public static AnimTemplate getAnimationSetting() {
        return currentAnimationSelected;
    }

    public static void refreshConfig() {
        try {
            File configFile = configPath.toFile();
            if (!configFile.exists()) {
                configFile.createNewFile();
            }
            Scanner lector = new Scanner(configFile);
            int lineCount = 0;
            while (lector.hasNext() && lineCount < 20) {
                String line = lector.nextLine();
                int equalCount = MiscUtils.count(line, "=");
                if (equalCount != 1) {
                    ItemInteractionsMod.infoMessage("Skipping line " + (lineCount + 1) + ": `" + line + "`. Contains " + equalCount + " `=``");
                    continue;
                }
                line = line.trim();
                int equalIndex = line.indexOf("=");
                String arg = line.substring(0, equalIndex).trim();
                String value = line.substring(equalIndex + 1).trim();
                if (settingsMap.containsKey(arg)) {
                    Object og = settingsMap.get(arg);
                    Object parsedValue = arg.equals("animation") ? (animations.containsKey(value) ? value : null) : ItemInteractionsConfig.parseConfigValue(value, og);
                    if (parsedValue == null) {
                        ItemInteractionsMod.warnMessage("Defaulting invalid setting: %s = %s", arg, value);
                        parsedValue = ItemInteractionsConfig.getDefaultSetting(arg);
                    }
                    settingsMap.put(arg, parsedValue);
                } else {
                    ItemInteractionsMod.warnMessage("Found unknown setting: %s = %s", arg, value);
                }
                ++lineCount;
            }
            if (!settingsMap.containsKey("animation") || settingsMap.get("animation") == null || settingsMap.get("animation").equals("null") || !animations.containsKey((String)settingsMap.get("animation"))) {
                settingsMap.put("animation", defaultAnimations.get("speed"));
            }
            ItemInteractionsConfig.writeConfig(configFile);
        }
        catch (Exception e) {
            ItemInteractionsMod.warnMessage("Failed to refresh the config! \n" + e.getMessage() + "Using the defaults", new Object[0]);
            ItemInteractionsConfig.init();
        }
        ItemInteractionsConfig.setValuesAfterRefresh();
        ItemInteractionsConfig.getAnimationSetting().refreshSettings();
    }

    private static Object parseConfigValue(String value, Object obj) {
        Object parsedValue = null;
        Object object = obj;
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Integer.class, Float.class, Double.class, Boolean.class, Vector3f.class}, (Object)object2, n)) {
            case 0: {
                Integer i = (Integer)object2;
                if (!MiscUtils.isInt(value)) break;
                parsedValue = Integer.parseInt(value);
                break;
            }
            case 1: {
                Float f = (Float)object2;
                if (!MiscUtils.isNumber(value)) break;
                parsedValue = Float.valueOf(Float.parseFloat(value));
                break;
            }
            case 2: {
                Double d = (Double)object2;
                if (!MiscUtils.isNumber(value)) break;
                parsedValue = Double.parseDouble(value);
                break;
            }
            case 3: {
                Boolean b = (Boolean)object2;
                if (!MiscUtils.isBoolean(value)) break;
                parsedValue = Boolean.parseBoolean(value);
                break;
            }
            case 4: {
                Vector3f vector3f = (Vector3f)object2;
                if (!MiscUtils.isVector(value)) break;
                parsedValue = MiscUtils.parseVector3f(value);
                break;
            }
        }
        return parsedValue;
    }

    private static boolean IsCorrectClass(Object og, Object value) {
        boolean ret = og.getClass().equals(value.getClass());
        if (!ret) {
            ItemInteractionsMod.warnMessage(String.format("invalid value! using the default %nOg: %s%nCf: %s", og.getClass(), value.getClass()), new Object[0]);
        }
        return ret;
    }

    private static void setValuesAfterRefresh() {
        enableGuiParticles = (Boolean)ItemInteractionsConfig.getSetting("gui_particles");
        smoothGuiParticles = (Boolean)ItemInteractionsConfig.getSetting("gui_smooth_particles");
        debugDraws = (Boolean)ItemInteractionsConfig.getSetting("debug");
        currentAnimationSelected = animations.getOrDefault((String)ItemInteractionsConfig.getSetting("animation"), animations.get("speed"));
    }

    private static void writeConfig(File configFile) throws IOException {
        FileWriter obj = new FileWriter(configFile);
        StringBuilder configFileString = new StringBuilder();
        ArrayList stringList = new ArrayList(20);
        TreeMap<String, Object> h = new TreeMap<String, Object>(settingsMap);
        h.forEach((k, v) -> stringList.add(String.format("%s = %s%n", k, v)));
        for (String s : stringList) {
            configFileString.append(s);
        }
        obj.write(configFileString.toString());
        obj.flush();
    }

    public static void createConfig() {
        try {
            ItemInteractionsConfig.writeConfig(configPath.toFile());
        }
        catch (Exception e) {
            ItemInteractionsMod.warnMessage("Error writing config file! \n" + String.valueOf(e), new Object[0]);
        }
    }

    static {
        settingsMap = new HashMap();
        defaultSettingsMap = new HashMap();
        animations = new HashMap();
        defaultAnimations = new HashMap();
        animationList = new ArrayList<AnimTemplate>();
        animIndexes = new ArrayList<AnimTemplate>();
    }
}

