/*
 * Decompiled with CFR 0.152.
 */
package dev.mineland.item_interactions_mod;

import dev.mineland.item_interactions_mod.CarriedInteractions.Spawners.GuiParticleSpawner;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;

public record SpawnerRegistry() {
    public static Map<class_1792, List<class_2960>> MAPPED_ITEMS_LIST = new HashMap<class_1792, List<class_2960>>();
    public static Map<class_2960, GuiParticleSpawner> SPAWNER_MAP = new HashMap<class_2960, GuiParticleSpawner>();

    public static void clear() {
        MAPPED_ITEMS_LIST.clear();
        SPAWNER_MAP.clear();
    }

    public static List<GuiParticleSpawner> get(class_1799 item) {
        List<class_2960> spawnerIds = MAPPED_ITEMS_LIST.get(item.method_7909());
        ArrayList<GuiParticleSpawner> result = new ArrayList<GuiParticleSpawner>();
        if (spawnerIds == null) {
            return result;
        }
        for (class_2960 id : spawnerIds) {
            GuiParticleSpawner guiParticleSpawner = SpawnerRegistry.getSpawnerFromId(id);
            if (guiParticleSpawner == null || !guiParticleSpawner.matches(item)) continue;
            result.add(guiParticleSpawner);
        }
        return result;
    }

    public static List<class_2960> getList(class_1799 item) {
        List<class_2960> spawnerIds = MAPPED_ITEMS_LIST.get(item.method_7909());
        ArrayList<class_2960> result = new ArrayList<class_2960>();
        if (spawnerIds == null) {
            return result;
        }
        for (class_2960 id : spawnerIds) {
            GuiParticleSpawner guiParticleSpawner = SpawnerRegistry.getSpawnerFromId(id);
            if (guiParticleSpawner == null || !guiParticleSpawner.matches(item)) continue;
            result.add(id);
        }
        return result;
    }

    public static GuiParticleSpawner getSpawnerFromId(class_2960 id) {
        return SPAWNER_MAP.getOrDefault(id, null);
    }

    public static void register(GuiParticleSpawner guiParticleSpawner, class_2960 id) {
        List<class_1799> items = guiParticleSpawner.getAppliedItems();
        SPAWNER_MAP.put(id, guiParticleSpawner);
        for (class_1799 item : items) {
            if (!MAPPED_ITEMS_LIST.containsKey(item.method_7909())) {
                MAPPED_ITEMS_LIST.put(item.method_7909(), new ArrayList());
            }
            if (MAPPED_ITEMS_LIST.get(item.method_7909()).contains(id)) continue;
            MAPPED_ITEMS_LIST.get(item.method_7909()).add(id);
        }
    }

    public static boolean compareSpawner(List<GuiParticleSpawner> carriedGuiParticleSpawner, class_1799 carriedItem) {
        ArrayList<class_2960> carriedList = new ArrayList<class_2960>();
        List<class_2960> itemList = SpawnerRegistry.getList(carriedItem);
        for (GuiParticleSpawner s : carriedGuiParticleSpawner) {
            carriedList.add(s.getName());
        }
        return new HashSet(carriedList).containsAll(itemList);
    }

    public static List<GuiParticleSpawner> create(List<GuiParticleSpawner> itemGuiParticleSpawnerList) {
        ArrayList<GuiParticleSpawner> result = new ArrayList<GuiParticleSpawner>();
        for (GuiParticleSpawner a : itemGuiParticleSpawnerList) {
            result.add(a.duplicate());
        }
        return result;
    }
}

