/*
 * Decompiled with CFR 0.152.
 */
package dev.mineland.item_interactions_mod.CarriedInteractions;

import dev.mineland.item_interactions_mod.CarriedInteractions.Particles.BaseParticle;
import dev.mineland.item_interactions_mod.CarriedInteractions.Spawners.GuiParticleSpawner;
import dev.mineland.item_interactions_mod.GlobalDirt;
import dev.mineland.item_interactions_mod.ItemInteractionsConfig;
import dev.mineland.item_interactions_mod.Item_interactions_mod;
import dev.mineland.item_interactions_mod.SpawnerRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_332;

public class GuiParticleSpawnersLogic {
    private static final List<class_1735> slots = new ArrayList<class_1735>();

    public static void reset() {
        slots.clear();
    }

    public static boolean checkAndTick(class_332 guiGraphics, class_1735 slot, boolean dead, int leftPos, int topPos, int initialSlotCount) {
        if (!GlobalDirt.shouldTickParticles) {
            return false;
        }
        int slotCount = initialSlotCount;
        while (slots.size() <= GlobalDirt.slotCount) {
            slots.add(null);
        }
        if (slots.get(slotCount) != slot) {
            if (slotCount - 1 >= 0 && slots.get(slotCount - 1) == slot) {
                --GlobalDirt.slotCount;
            } else if (slotCount + 1 < slots.size() && slots.get(slotCount + 1) == slot) {
                ++GlobalDirt.slotCount;
            }
            slotCount = GlobalDirt.slotCount;
        }
        slots.set(slotCount, slot);
        while (GlobalDirt.slotSpawners.size() <= slotCount) {
            GlobalDirt.slotSpawners.add(null);
        }
        try {
            class_1799 slotItem = slot.method_7677();
            List<GuiParticleSpawner> itemGuiParticleSpawnerList = SpawnerRegistry.get(slotItem);
            List<class_2960> currentSpawnersList = GlobalDirt.slotSpawners.getIdList(slotCount);
            List<class_2960> itemSpawnersIdList = SpawnerRegistry.getList(slotItem);
            if (ItemInteractionsConfig.debugDraws) {
                guiGraphics.method_49601(slot.field_7873, slot.field_7872, 16, 16, -1);
            }
            if (itemGuiParticleSpawnerList.isEmpty() && currentSpawnersList.isEmpty()) {
                return false;
            }
            if (itemGuiParticleSpawnerList.isEmpty()) {
                if (ItemInteractionsConfig.debugDraws) {
                    guiGraphics.method_25294(slot.field_7873, slot.field_7872, slot.field_7873 + 16, slot.field_7872 + 16, -65536);
                }
                GlobalDirt.slotSpawners.set(slotCount, new ArrayList<GuiParticleSpawner>());
                return false;
            }
            int globalX = slot.field_7873 + leftPos + 8;
            int globalY = slot.field_7872 + topPos + 8;
            if (currentSpawnersList.isEmpty() || !new HashSet<class_2960>(currentSpawnersList).containsAll(itemSpawnersIdList)) {
                if (ItemInteractionsConfig.debugDraws) {
                    guiGraphics.method_25294(slot.field_7873, slot.field_7872, slot.field_7873 + 16, slot.field_7872 + 16, currentSpawnersList.isEmpty() ? -16711936 : -256);
                }
                GlobalDirt.slotSpawners.set(slotCount, itemGuiParticleSpawnerList, GlobalDirt.isInventoryScrolling ? "onIdle" : "onPut");
                GlobalDirt.slotSpawners.tick(slotCount, GlobalDirt.spawnerTickDelta, guiGraphics, globalX, globalY, 0.0f, 0.0f);
                GlobalDirt.slotSpawners.setState(slotCount, "onIdle");
                return false;
            }
            if (ItemInteractionsConfig.debugDraws) {
                guiGraphics.method_25294(slot.field_7873, slot.field_7872, slot.field_7873 + 16, slot.field_7872 + 16, -2147418368);
            }
            GlobalDirt.slotSpawners.tick(slotCount, GlobalDirt.spawnerTickDelta, guiGraphics, globalX, globalY, 0.0f, 0.0f);
            return false;
        }
        catch (Exception e) {
            if (!dead) {
                Item_interactions_mod.warnMessage("Error! \n" + String.valueOf(e));
            }
            return true;
        }
    }

    public static void mainLogic(class_332 guiGraphics) {
        ArrayList<BaseParticle> shouldDelete = new ArrayList<BaseParticle>();
        if (GlobalDirt.shouldTickParticles && ItemInteractionsConfig.enableGuiParticles) {
            if (GlobalDirt.carriedItem == null || GlobalDirt.carriedItem.method_7960() || SpawnerRegistry.get(GlobalDirt.carriedItem).isEmpty()) {
                GlobalDirt.carriedGuiParticleSpawner.clear();
            } else if (GlobalDirt.carriedItem != null && !GlobalDirt.carriedItem.method_7960()) {
                if (!SpawnerRegistry.compareSpawner(GlobalDirt.carriedGuiParticleSpawner, GlobalDirt.carriedItem) || GlobalDirt.carriedGuiParticleSpawner.isEmpty()) {
                    List<GuiParticleSpawner> newGuiParticleSpawner = SpawnerRegistry.get(GlobalDirt.carriedItem);
                    if (!newGuiParticleSpawner.isEmpty()) {
                        GlobalDirt.carriedGuiParticleSpawner = newGuiParticleSpawner;
                        Collections.fill(GlobalDirt.carriedGuiParticleSpawnerTimer, Float.valueOf(0.0f));
                        GlobalDirt.carriedGuiParticleSpawner.forEach(spawner -> spawner.setState("onPickup"));
                        GlobalDirt.slotSpawners.tickSpawners(-1, GlobalDirt.carriedGuiParticleSpawner, GlobalDirt.spawnerTickDelta, guiGraphics, (float)GlobalDirt.lastMouseX, (float)GlobalDirt.lastMouseY, (float)GlobalDirt.mouseDeltaX, (float)GlobalDirt.mouseDeltaY);
                        GlobalDirt.carriedGuiParticleSpawner.forEach(spawner -> spawner.setState("onIdle"));
                    } else {
                        GlobalDirt.carriedGuiParticleSpawner.clear();
                    }
                }
                GlobalDirt.carriedGuiParticleSpawner.forEach(spawner -> spawner.setState(GlobalDirt.isShaking ? "onShake" : "onCarried"));
                GlobalDirt.slotSpawners.tickSpawners(-1, GlobalDirt.carriedGuiParticleSpawner, GlobalDirt.spawnerTickDelta, guiGraphics, (float)GlobalDirt.lastMouseX, (float)GlobalDirt.lastMouseY, (float)GlobalDirt.mouseDeltaX, (float)GlobalDirt.mouseDeltaY);
                GlobalDirt.carriedGuiParticleSpawner.forEach(spawner -> spawner.setState("onIdle"));
            }
            GlobalDirt.isInventoryScrolling = false;
        }
        for (BaseParticle particle : GlobalDirt.particleList) {
            if (GlobalDirt.shouldTickParticles) {
                particle.tick();
                if (particle.shouldDelete) {
                    shouldDelete.add(particle);
                }
            }
            particle.render();
        }
        GlobalDirt.particleList.removeAll(shouldDelete);
    }
}

