/*
 * Decompiled with CFR 0.152.
 */
package dev.mineland.item_interactions_mod.CarriedInteractions.Particles;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import dev.mineland.item_interactions_mod.CarriedInteractions.Particles.BaseParticle;
import dev.mineland.item_interactions_mod.GlobalDirt;
import dev.mineland.item_interactions_mod.GuiRendererHelper;
import dev.mineland.item_interactions_mod.Item_interactions_mod;
import dev.mineland.item_interactions_mod.MiscUtils;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_332;

public class TexturedParticle
extends BaseParticle {
    int tintStart;
    int tintEnd;
    TextureType textureType;
    JsonObject textureMcMeta;
    class_2960 particleLocation;
    List<class_2960> frames;
    int width;
    int height;
    double frametime;
    int textureIndex;
    boolean interpolate;
    int length;
    double totalLifeTime;
    boolean isMCMetaAnimatedTexture;

    public TexturedParticle(class_332 guiGraphics, double x, double y, double speedX, double speedY, double accelerationX, double accelerationY, double frictionX, double frictionY, double lifeTime, class_2960 particleLocation, int tintStart, int tintEnd) {
        this(guiGraphics, x, y, speedX, speedY, accelerationX, accelerationY, frictionX, frictionY, lifeTime, particleLocation, TextureType.LIFETIME, tintStart, tintEnd);
    }

    public TexturedParticle(class_332 guiGraphics, double x, double y, double speedX, double speedY, double accelerationX, double accelerationY, double frictionX, double frictionY, double lifeTime, class_2960 particleLocation, TextureType textureType, int tintStart, int tintEnd) {
        super(guiGraphics, x, y, speedX, speedY, accelerationX, accelerationY, frictionX, frictionY, lifeTime);
        this.tintStart = tintStart;
        this.tintEnd = tintEnd;
        this.particleLocation = particleLocation;
        this.textureType = textureType;
        this.totalLifeTime = lifeTime;
        this.frames = this.getTexturesFromArray(particleLocation);
    }

    private List<class_2960> getTexturesFromArray(class_2960 particleLocation) {
        try {
            class_3298 a = (class_3298)class_310.method_1551().method_1478().method_14486(particleLocation.method_45138("particles/").method_48331(".json")).orElseThrow();
            ArrayList<class_2960> finalList = new ArrayList<class_2960>();
            JsonElement json = JsonParser.parseReader((Reader)a.method_43039());
            for (JsonElement textureJson : json.getAsJsonObject().get("textures").getAsJsonArray()) {
                class_2960 raw = class_2960.method_12829((String)textureJson.getAsString());
                Object path = raw.method_12832().startsWith("textures/") ? raw.method_12832() : "textures/particle/" + raw.method_12832();
                path = ((String)path).endsWith(".png") ? path : (String)path + ".png";
                finalList.add(new class_2960(raw.method_12836(), (String)path));
            }
            this.length = finalList.size();
            this.isMCMetaAnimatedTexture = false;
            return finalList;
        }
        catch (Exception e) {
            ArrayList<class_2960> r = new ArrayList<class_2960>();
            r.add(new class_2960("minecraft:textures/missingno.png"));
            return r;
        }
    }

    @Override
    public void render() {
        int totalTextureWidth;
        int totalTextureHeight;
        block7: {
            super.render();
            this.particleLocation = this.frames.get(this.textureIndex);
            totalTextureHeight = 16;
            totalTextureWidth = 16;
            try {
                int[] size = GuiRendererHelper.getSize(this.particleLocation);
                totalTextureHeight = size[0];
                totalTextureWidth = size[1];
            }
            catch (Exception e) {
                if (!GlobalDirt.devenv) break block7;
                Item_interactions_mod.errorMessage("Died loading particle!" + String.valueOf(e));
            }
        }
        boolean yStart = false;
        int uvHeight = totalTextureHeight;
        switch (this.textureType.ordinal()) {
            case 0: {
                break;
            }
            case 2: {
                if (this.length == 0) break;
                int index = (int)Math.floor(this.lifeTime / this.maxTick * (double)this.length);
                this.textureIndex = MiscUtils.clamp(index, 0, this.length - 1);
                break;
            }
            case 1: {
                if (this.lifeTime % this.frametime != 0.0) break;
                this.textureIndex = (this.textureIndex + 1) % (this.length + 1);
            }
        }
        int finalColor = MiscUtils.colorLerp((float)MiscUtils.clamp(this.lifeTime / this.maxTick, 0.0, 1.0), this.tintStart, this.tintEnd);
        this.guiGraphics.method_51448().method_22903();
        this.guiGraphics.method_51448().method_46416(0.0f, 0.0f, 399.0f);
        GuiRendererHelper.blit(this.guiGraphics.method_51448(), this.frames.get(this.textureIndex), (int)this.x - totalTextureWidth / 2, (int)this.y - uvHeight / 2, 0.0f, (float)yStart, totalTextureWidth, uvHeight, totalTextureWidth, totalTextureHeight, finalColor);
        this.guiGraphics.method_51448().method_22909();
    }

    @Override
    public void tick() {
        super.tick();
        this.x += this.speedX / 20.0;
        this.y += this.speedY / 20.0;
        this.speedX = (this.speedX + this.accelerationX) * this.frictionX;
        this.speedY = (this.speedY + this.accelerationY) * this.frictionY;
        if (this.x + (double)this.width < 0.0 || this.x - (double)this.width > (double)class_310.method_1551().method_22683().method_4486() || this.y + (double)this.height < 0.0 || this.y - (double)this.height > (double)class_310.method_1551().method_22683().method_4502()) {
            this.shouldDelete = true;
        }
    }

    public static enum TextureType {
        STATIC(0),
        FRAMETIME(1),
        LIFETIME(2);

        final int typeId;

        private TextureType(int i) {
            this.typeId = i;
        }
    }
}

