/*
 * Decompiled with CFR 0.152.
 */
package dev.mineland.item_interactions_mod.CarriedInteractions.Spawners;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.mineland.item_interactions_mod.CarriedInteractions.Spawners.ParticleEvent;
import dev.mineland.item_interactions_mod.CarriedInteractions.Spawners.ParticleInstance;
import dev.mineland.item_interactions_mod.GlobalDirt;
import dev.mineland.item_interactions_mod.Item_interactions_mod;
import dev.mineland.item_interactions_mod.MiscUtils;
import dev.mineland.item_interactions_mod.backport.ItemStackWithoutCount;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Method;
import java.lang.reflect.RecordComponent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_332;

public class GuiParticleSpawner {
    protected int id = 0;
    protected class_2960 name = null;
    private Optional<class_2960> parent = Optional.empty();
    private Optional<List<class_2960>> childrenLocations = Optional.empty();
    private Optional<ParticleInstance> attributes = Optional.empty();
    private Optional<ParticleInstance> attributes_variance = Optional.empty();
    private Optional<Map<String, Either<ParticleEvent, String>>> events = Optional.empty();
    private Optional<List<class_1799>> appliedItems = Optional.empty();
    private String state = null;
    private List<GuiParticleSpawner> childGuiParticleSpawners = new ArrayList<GuiParticleSpawner>();
    private float timer = 0.0f;
    static Codec<Either<ParticleEvent, String>> eventOrStringCodec = Codec.either(ParticleEvent.CODEC, (Codec)Codec.STRING);
    static Codec<Map<String, Either<ParticleEvent, String>>> eventsCodec = Codec.unboundedMap((Codec)Codec.STRING, eventOrStringCodec);
    public static Codec<GuiParticleSpawner> CODEC = RecordCodecBuilder.create(spawnerInstance -> spawnerInstance.group((App)class_2960.field_25139.optionalFieldOf("parent").forGetter(s -> s.parent), (App)class_2960.field_25139.listOf().optionalFieldOf("children").forGetter(s -> s.childrenLocations), (App)ParticleInstance.CONFIG_CODEC.optionalFieldOf("attributes").forGetter(s -> s.attributes), (App)ParticleInstance.CONFIG_CODEC.optionalFieldOf("attributes_variance").forGetter(s -> s.attributes_variance), (App)eventsCodec.optionalFieldOf("events").forGetter(spawner -> spawner.events), (App)ItemStackWithoutCount.CODEC.listOf().optionalFieldOf("applies").forGetter(s -> s.appliedItems)).apply((Applicative)spawnerInstance, GuiParticleSpawner::new));
    private JsonObject tempParentJson;

    public GuiParticleSpawner duplicate() {
        return new GuiParticleSpawner(this.parent, this.childrenLocations, this.attributes, this.attributes_variance, this.events, this.appliedItems);
    }

    public GuiParticleSpawner() {
        this.id = -1;
    }

    public GuiParticleSpawner parseSpawner(class_2960 id) {
        GuiParticleSpawner guiParticleSpawner;
        block11: {
            class_3300 resourceManager = class_310.method_1551().method_1478();
            if (resourceManager.method_14486(id = id.method_45136("gui_particle_spawners/" + id.method_12832() + ".json")).isEmpty()) {
                if (!GlobalDirt.spawnerErrorList.containsKey(id)) {
                    GlobalDirt.spawnerErrorList.put(id, new ArrayList());
                }
                GlobalDirt.spawnerErrorList.get(id).add(String.valueOf(id) + " doesn't exist");
                Item_interactions_mod.warnMessage("Spawner '" + String.valueOf(id) + "' is empty!");
                return null;
            }
            InputStream stream = ((class_3298)resourceManager.method_14486(id).get()).method_14482();
            try {
                JsonObject json;
                this.tempParentJson = json = JsonParser.parseReader((Reader)new InputStreamReader(stream)).getAsJsonObject();
                DataResult dataResult = CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json);
                String warnMessage = String.format("Errors found in '%s': ", id);
                class_2960 finalId = id;
                GuiParticleSpawner result = (GuiParticleSpawner)dataResult.resultOrPartial(s -> {
                    if (!GlobalDirt.spawnerErrorList.containsKey(finalId)) {
                        GlobalDirt.spawnerErrorList.put(finalId, new ArrayList());
                    }
                    GlobalDirt.spawnerErrorList.get(finalId).add(warnMessage + s);
                    Item_interactions_mod.warnMessage(warnMessage + s);
                }).orElseThrow();
                result.setName(id);
                guiParticleSpawner = result;
                if (stream == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (JsonParseException | IOException e) {
                    if (!GlobalDirt.spawnerErrorList.containsKey(id)) {
                        GlobalDirt.spawnerErrorList.put(id, new ArrayList());
                    }
                    GlobalDirt.spawnerErrorList.get(id).add(e.getMessage());
                    Item_interactions_mod.warnMessage("Couldn't parse parent '" + String.valueOf(id) + "'!\n" + String.valueOf(e));
                    ++GlobalDirt.spawnerErrorCount;
                    return null;
                }
            }
            stream.close();
        }
        return guiParticleSpawner;
    }

    public void copyFromParent(GuiParticleSpawner parent) {
        this.childGuiParticleSpawners = parent.childGuiParticleSpawners;
        this.attributes = parent.attributes;
        this.attributes_variance = parent.attributes_variance;
        this.events = parent.events;
    }

    public GuiParticleSpawner(Optional<class_2960> parent, Optional<List<class_2960>> children, Optional<ParticleInstance> attributes, Optional<ParticleInstance> attributes_variance, Optional<Map<String, Either<ParticleEvent, String>>> eventMap, Optional<List<class_1799>> appliedItems) {
        DataResult p;
        Optional parentEvents = Optional.empty();
        if (parent.isPresent()) {
            class_2960 resourceLocation = parent.get();
            GuiParticleSpawner parentSpawner = this.parseSpawner(resourceLocation);
            this.copyFromParent(parentSpawner);
        }
        attributes.ifPresent(this::setAttributes);
        attributes_variance.ifPresent(this::setAttributes_variance);
        if (parent.isPresent() && (p = eventsCodec.parse((DynamicOps)JsonOps.INSTANCE, (Object)this.tempParentJson.get("events"))).resultOrPartial(s -> {}).isPresent()) {
            this.setEvents((Map)p.resultOrPartial(s -> {}).get());
        }
        eventMap.ifPresent(this::setEvents);
        appliedItems.ifPresent(this::setAppliedItems);
        children.ifPresent(childrenList -> {
            for (class_2960 childId : childrenList) {
                GuiParticleSpawner c = this.parseSpawner(childId);
                if (c == null) continue;
                this.childGuiParticleSpawners.add(c);
            }
        });
    }

    public void setName(class_2960 name) {
        this.name = name;
    }

    public void setName(String name) {
        this.name = class_2960.method_12829((String)name);
    }

    public class_2960 getName() {
        return this.name;
    }

    public Codec<GuiParticleSpawner> getCODEC() {
        return CODEC;
    }

    public void fireEvent(int id, int childCount, String eventName, float timeDuration, class_332 guiGraphics, float x, float y, float speedX, float speedY) {
        if (this.events.isEmpty()) {
            System.out.println("No events registered in " + String.valueOf(this.getName()));
            return;
        }
        Either<ParticleEvent, String> eventStringEither = this.getEvents().get(eventName);
        if (eventStringEither == null) {
            return;
        }
        if (eventStringEither.right().isPresent()) {
            this.fireEvent(id, childCount, (String)eventStringEither.right().get(), timeDuration, guiGraphics, x, y, speedX, speedY);
            return;
        }
        eventStringEither.ifLeft(e -> {
            GlobalDirt.slotSpawners.modifySpawnTimer(id, childCount, -timeDuration);
            float interval = GlobalDirt.slotSpawners.getSpawnerTimer(id, childCount);
            e.use.ifPresent(s -> e.inheritFromParent(this.getEvents(), this.getEvents().get(s)));
            if (interval <= 0.0f) {
                float nextTime = (float)MiscUtils.randomVariance(e.interval.orElse(Float.valueOf(0.0f)).floatValue(), e.interval_variance.orElse(Float.valueOf(0.0f)).floatValue());
                GlobalDirt.slotSpawners.setSpawnerTimer(id, childCount, nextTime);
                e.fire(guiGraphics, x, y, speedX, speedY, this.attributes, this.attributes_variance);
            }
        });
    }

    public void tick(float timeDuration, class_332 guiGraphics, float x, float y, float speedX, float speedY, int slotId, int childCount) {
        for (GuiParticleSpawner child : this.childGuiParticleSpawners) {
            child.tick(timeDuration, guiGraphics, x, y, speedX, speedY, slotId, childCount + 1);
        }
        Either<ParticleEvent, String> event = this.getEvents().get(this.state);
        if (this.state.equals("onShake") && event == null) {
            event = this.getEvents().get("onCarried");
            this.state = "onCarried";
        }
        if (event == null) {
            return;
        }
        this.fireEvent(slotId, childCount, this.state, timeDuration, guiGraphics, x, y, speedX, speedY);
    }

    public boolean matches(class_1799 itemStack) {
        for (class_1799 conditionItem : (List)this.appliedItems.orElse(new ArrayList())) {
            if (!itemStack.method_7909().equals(conditionItem.method_7909())) continue;
            return true;
        }
        return false;
    }

    private static boolean compareValuesAsSubset(Object source, Object target) {
        if (source == null || target == null) {
            return source == target;
        }
        if (source instanceof Map && target instanceof Map) {
            Map sourceMap = (Map)source;
            Map targetMap = (Map)target;
            for (Map.Entry entry : sourceMap.entrySet()) {
                Object key = entry.getKey();
                if (!targetMap.containsKey(key)) {
                    return false;
                }
                if (GuiParticleSpawner.compareValuesAsSubset(entry.getValue(), targetMap.get(key))) continue;
                return false;
            }
            return true;
        }
        if (source instanceof Iterable && target instanceof Iterable) {
            for (Object srcItem : (Iterable)source) {
                boolean matched = false;
                for (Object tgtItem : (Iterable)target) {
                    if (!GuiParticleSpawner.compareValuesAsSubset(srcItem, tgtItem)) continue;
                    matched = true;
                    break;
                }
                if (matched) continue;
                return false;
            }
            return true;
        }
        if (source.getClass().isRecord() && target.getClass().isRecord() && source.getClass() == target.getClass()) {
            try {
                for (RecordComponent field : source.getClass().getRecordComponents()) {
                    Object tgtField;
                    Method getter = field.getAccessor();
                    Object srcField = getter.invoke(source, new Object[0]);
                    if (GuiParticleSpawner.compareValuesAsSubset(srcField, tgtField = getter.invoke(target, new Object[0]))) continue;
                    return false;
                }
                return true;
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException("Failed to compare record fields", e);
            }
        }
        return source.equals(target);
    }

    public List<class_1799> getAppliedItems() {
        return this.appliedItems.orElseGet(ArrayList::new);
    }

    public void setAppliedItems(List<class_1799> appliedItems) {
        ArrayList<class_1799> items = new ArrayList<class_1799>();
        for (class_1799 itemStack : appliedItems) {
            if (itemStack.method_7960()) continue;
            items.add(itemStack);
        }
        this.appliedItems = Optional.of(items);
    }

    public ParticleInstance getAttributes() {
        return this.attributes.orElseGet(ParticleInstance::new);
    }

    public void setAttributes(ParticleInstance attributes) {
        if (this.attributes.isPresent()) {
            ParticleInstance newAttributes = this.attributes.get();
            attributes.x.ifPresent(attr -> {
                newAttributes.x = Optional.of(attr);
            });
            attributes.y.ifPresent(attr -> {
                newAttributes.y = Optional.of(attr);
            });
            attributes.speedX.ifPresent(attr -> {
                newAttributes.speedX = Optional.of(attr);
            });
            attributes.speedY.ifPresent(attr -> {
                newAttributes.speedY = Optional.of(attr);
            });
            attributes.accelerationX.ifPresent(attr -> {
                newAttributes.accelerationX = Optional.of(attr);
            });
            attributes.accelerationY.ifPresent(attr -> {
                newAttributes.accelerationY = Optional.of(attr);
            });
            attributes.frictionX.ifPresent(attr -> {
                newAttributes.frictionX = Optional.of(attr);
            });
            attributes.frictionY.ifPresent(attr -> {
                newAttributes.frictionY = Optional.of(attr);
            });
            attributes.colorStart.ifPresent(attr -> {
                newAttributes.colorStart = Optional.of(attr);
            });
            attributes.colorEnd.ifPresent(attr -> {
                newAttributes.colorEnd = Optional.of(attr);
            });
            attributes.duration.ifPresent(attr -> {
                newAttributes.duration = Optional.of(attr);
            });
            attributes.count.ifPresent(attr -> {
                newAttributes.count = Optional.of(attr);
            });
            this.attributes = Optional.of(newAttributes);
        } else {
            this.attributes = Optional.of(attributes);
        }
    }

    public ParticleInstance getAttributes_variance() {
        return this.attributes_variance.orElseGet(ParticleInstance::new);
    }

    public void setAttributes_variance(ParticleInstance attributes_variance) {
        if (this.attributes_variance.isPresent()) {
            ParticleInstance newAttributes = this.attributes_variance.get();
            attributes_variance.x.ifPresent(attr -> {
                newAttributes.x = Optional.of(attr);
            });
            attributes_variance.y.ifPresent(attr -> {
                newAttributes.y = Optional.of(attr);
            });
            attributes_variance.speedX.ifPresent(attr -> {
                newAttributes.speedX = Optional.of(attr);
            });
            attributes_variance.speedY.ifPresent(attr -> {
                newAttributes.speedY = Optional.of(attr);
            });
            attributes_variance.accelerationX.ifPresent(attr -> {
                newAttributes.accelerationX = Optional.of(attr);
            });
            attributes_variance.accelerationY.ifPresent(attr -> {
                newAttributes.accelerationY = Optional.of(attr);
            });
            attributes_variance.frictionX.ifPresent(attr -> {
                newAttributes.frictionX = Optional.of(attr);
            });
            attributes_variance.frictionY.ifPresent(attr -> {
                newAttributes.frictionY = Optional.of(attr);
            });
            attributes_variance.colorStart.ifPresent(attr -> {
                newAttributes.colorStart = Optional.of(attr);
            });
            attributes_variance.colorEnd.ifPresent(attr -> {
                newAttributes.colorEnd = Optional.of(attr);
            });
            attributes_variance.duration.ifPresent(attr -> {
                newAttributes.duration = Optional.of(attr);
            });
            attributes_variance.count.ifPresent(attr -> {
                newAttributes.count = Optional.of(attr);
            });
            this.attributes_variance = Optional.of(newAttributes);
        } else {
            this.attributes_variance = Optional.of(attributes_variance);
        }
    }

    public List<GuiParticleSpawner> getChildGuiParticleSpawners() {
        return this.childGuiParticleSpawners;
    }

    public void setChildGuiParticleSpawners(List<GuiParticleSpawner> childGuiParticleSpawners) {
        this.childGuiParticleSpawners = childGuiParticleSpawners;
    }

    public Map<String, Either<ParticleEvent, String>> getEvents() {
        return this.events.orElseGet(HashMap::new);
    }

    public void setEvents(Map<String, Either<ParticleEvent, String>> newEvents) {
        Map newEventsMap = this.events.orElse(new HashMap());
        newEvents.forEach((k, newEvent) -> {
            Either eitherCurrentEvent = newEventsMap.getOrDefault(k, newEvent);
            ParticleEvent finalEvent = new ParticleEvent();
            if (eitherCurrentEvent.left().isPresent()) {
                finalEvent = (ParticleEvent)eitherCurrentEvent.left().get();
            } else if (eitherCurrentEvent.right().isPresent()) {
                finalEvent.use = Optional.of((String)eitherCurrentEvent.right().get());
            }
            if (finalEvent.attributes.isEmpty()) {
                finalEvent.attributes = Optional.of(new ParticleInstance());
            }
            if (finalEvent.attributes_variance.isEmpty()) {
                finalEvent.attributes_variance = Optional.of(new ParticleInstance());
            }
            newEventsMap.put(k, Either.left((Object)finalEvent));
        });
        this.events = Optional.of(newEventsMap);
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public class_2960 getParent() {
        return this.parent.orElseGet(() -> null);
    }

    public void setParent(class_2960 parent) {
        this.parent = Optional.of(parent);
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
        for (GuiParticleSpawner child : this.childGuiParticleSpawners) {
            child.setState(state);
        }
    }

    public float getTimer() {
        return this.timer;
    }

    public void setTimer(float timer) {
        this.timer = timer;
    }
}

