/*
 * Decompiled with CFR 0.152.
 */
package dev.mineland.item_interactions_mod;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.mineland.item_interactions_mod.CarriedInteractions.Spawners.GuiParticleSpawner;
import dev.mineland.item_interactions_mod.GlobalDirt;
import dev.mineland.item_interactions_mod.GuiRendererHelper;
import dev.mineland.item_interactions_mod.ItemInteractionsConfig;
import dev.mineland.item_interactions_mod.Item_interactions_mod;
import dev.mineland.item_interactions_mod.SpawnerRegistry;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_370;
import net.minecraft.class_374;
import net.minecraft.class_4013;
import org.jetbrains.annotations.NotNull;

public class GuiParticlesReloadListener
implements class_4013 {
    private GuiParticleSpawner parseSpawner(JsonObject SpawnerJson, class_2960 id, class_3300 resourceManager) {
        GlobalDirt.currentParticleSpawner = id.toString();
        class_2960 filePath = new class_2960(id.method_12836(), "gui_particle_spawners/" + id.method_12832());
        DataResult dataResult = GuiParticleSpawner.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)SpawnerJson);
        GuiParticleSpawner result = (GuiParticleSpawner)dataResult.resultOrPartial(s -> {
            if (!GlobalDirt.spawnerErrorList.containsKey(filePath)) {
                GlobalDirt.spawnerErrorList.put(filePath, new ArrayList());
            }
            GlobalDirt.spawnerErrorList.get(filePath).add((String)s);
            Item_interactions_mod.warnMessage("Errors found in '" + String.valueOf(filePath) + "\n" + s);
            ++GlobalDirt.spawnerErrorCount;
        }).orElseThrow();
        result.setName(id);
        return result;
    }

    private double trySet(JsonObject json, String member, double defaultValue) {
        try {
            return json.get(member).getAsDouble();
        }
        catch (Exception ignore) {
            return defaultValue;
        }
    }

    private void loadSpawners(class_3300 resourceManager) {
        for (Map.Entry entry : resourceManager.method_14488("gui_particle_spawners", resourceLocation -> resourceLocation.method_12832().endsWith(".json")).entrySet()) {
            class_2960 id = (class_2960)entry.getKey();
            class_3298 resource = (class_3298)entry.getValue();
            if (ItemInteractionsConfig.debugDraws) {
                Item_interactions_mod.infoMessage("Loading " + String.valueOf(id) + ":" + String.valueOf(resource));
            }
            try {
                InputStream stream = resource.method_14482();
                try {
                    JsonObject json = JsonParser.parseReader((Reader)new InputStreamReader(stream)).getAsJsonObject();
                    GuiParticleSpawner a = this.parseSpawner(json, id, resourceManager);
                    SpawnerRegistry.register(a, id);
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            catch (Exception e) {
                Item_interactions_mod.errorMessage("Couldn't parse '" + String.valueOf(id) + "': \n" + String.valueOf(e.getCause()));
                if (!GlobalDirt.spawnerErrorList.containsKey(id)) {
                    GlobalDirt.spawnerErrorList.put(id, new ArrayList());
                }
                GlobalDirt.spawnerErrorList.get(id).add(e.getMessage());
                ++GlobalDirt.spawnerErrorCount;
            }
        }
    }

    private void loadStuff(class_3300 resourceManager) {
        Item_interactions_mod.infoMessage("Reloading gui particle spawners");
        SpawnerRegistry.clear();
        GuiRendererHelper.clearCache();
        this.loadSpawners(resourceManager);
        String spawnerString = SpawnerRegistry.SPAWNER_MAP.size() == 1 ? "Parsed %d Gui particle spawner" : "Parsed %d Gui particle spawners";
        Object errorCountString = "";
        if (GlobalDirt.spawnerErrorCount == 1) {
            errorCountString = " (1 error)";
        } else if (GlobalDirt.spawnerErrorCount > 1) {
            errorCountString = " (" + GlobalDirt.spawnerErrorCount + " errors)";
        }
        Item_interactions_mod.infoMessage(String.format(spawnerString + (String)errorCountString, SpawnerRegistry.SPAWNER_MAP.size()));
    }

    @NotNull
    public CompletableFuture<Void> reload(class_3302.class_4045 preparationBarrier, class_3300 resourceManager, Executor executor, Executor executor2) {
        CompletableFuture<Void> a = CompletableFuture.supplyAsync(() -> {
            GlobalDirt.isReloadingResources = true;
            GlobalDirt.spawnerErrorList.clear();
            GlobalDirt.particleErrorList.clear();
            GlobalDirt.spawnerErrorCount = 0;
            GlobalDirt.currentParticleSpawner = "";
            this.loadStuff(resourceManager);
            if (GlobalDirt.spawnerErrorCount > 0) {
                String errorTitle = GlobalDirt.spawnerErrorCount == 1 ? "%d Gui particle error" : "%d Gui particle errors";
                class_370.method_27024((class_374)class_310.method_1551().method_1566(), (class_370.class_371)class_370.class_371.field_21809, (class_2561)class_2561.method_43470((String)String.format(errorTitle, GlobalDirt.spawnerErrorCount)), (class_2561)class_2561.method_43470((String)"Check the logs for more information"));
            }
            GlobalDirt.isReloadingResources = false;
            return null;
        }, executor);
        return a.thenCompose(arg_0 -> ((class_3302.class_4045)preparationBarrier).method_18352(arg_0));
    }

    @NotNull
    public String method_22322() {
        return super.method_22322();
    }

    public void method_14491(class_3300 resourceManager) {
        GlobalDirt.isReloadingResources = true;
        GlobalDirt.spawnerErrorList.clear();
        GlobalDirt.particleErrorList.clear();
        GlobalDirt.spawnerErrorCount = 0;
        GlobalDirt.currentParticleSpawner = "";
        this.loadStuff(resourceManager);
        if (GlobalDirt.spawnerErrorCount > 0) {
            String errorTitle = GlobalDirt.spawnerErrorCount == 1 ? "%d Gui particle error" : "%d Gui particle errors";
            class_370.method_27024((class_374)class_310.method_1551().method_1566(), (class_370.class_371)class_370.class_371.field_21809, (class_2561)class_2561.method_43470((String)String.format(errorTitle, GlobalDirt.spawnerErrorCount)), (class_2561)class_2561.method_43470((String)"Check the logs for more information"));
        }
        GlobalDirt.isReloadingResources = false;
    }
}

