/*
 * Decompiled with CFR 0.152.
 */
package dev.mineland.item_interactions_mod;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.mineland.item_interactions_mod.GlobalDirt;
import dev.mineland.item_interactions_mod.ItemInteractionsConfig;
import dev.mineland.item_interactions_mod.itemcarriedalgs.AnimScale;
import dev.mineland.item_interactions_mod.itemcarriedalgs.AnimSpeed;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import net.minecraft.class_1011;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_757;
import org.joml.Matrix4f;

public class GuiRendererHelper {
    private static final HashMap<class_2960, int[]> particleSizesCache = new HashMap();

    public static void clearCache() {
        particleSizesCache.clear();
    }

    public static void blit(class_4587 pose, class_2960 resourceLocation, int i, int j, float f, float g, int k, int l, int m, int n, int color) {
        GuiRendererHelper.blit(pose, resourceLocation, i, j, k, l, f, g, k, l, m, n, color);
    }

    static void blit(class_4587 pose, class_2960 resourceLocation, int i, int j, int k, int l, float f, float g, int m, int n, int o, int p, int color) {
        GuiRendererHelper.blit(pose, resourceLocation, i, i + k, j, j + l, 0, m, n, f, g, o, p, color);
    }

    static void blit(class_4587 pose, class_2960 resourceLocation, int i, int j, int k, int l, int m, int n, int o, float f, float g, int p, int q, int color) {
        GuiRendererHelper.blit(pose, resourceLocation, i, j, k, l, m, (f + 0.0f) / (float)p, (f + (float)n) / (float)p, (g + 0.0f) / (float)q, (g + (float)o) / (float)q, color);
    }

    static void blit(class_4587 pose, class_2960 resourceLocation, int i, int j, int k, int l, int m, float f, float g, float h, float n, int color) {
        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        GuiRendererHelper.innerBlitTinted(pose, resourceLocation, i, j, k, l, m, f, g, h, n, red, green, blue, alpha);
    }

    static void innerBlitTinted(class_4587 pose, class_2960 resourceLocation, int i, int j, int k, int l, int m, float f, float g, float h, float n, float o, float p, float q, float r) {
        RenderSystem.setShaderTexture((int)0, (class_2960)resourceLocation);
        RenderSystem.setShader(class_757::method_34541);
        RenderSystem.enableBlend();
        Matrix4f matrix4f = pose.method_23760().method_23761();
        class_287 bufferBuilder = class_289.method_1348().method_1349();
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_20887);
        bufferBuilder.method_22918(matrix4f, (float)i, (float)k, (float)m).method_22915(o, p, q, r).method_22913(f, h).method_1344();
        bufferBuilder.method_22918(matrix4f, (float)i, (float)l, (float)m).method_22915(o, p, q, r).method_22913(f, n).method_1344();
        bufferBuilder.method_22918(matrix4f, (float)j, (float)l, (float)m).method_22915(o, p, q, r).method_22913(g, n).method_1344();
        bufferBuilder.method_22918(matrix4f, (float)j, (float)k, (float)m).method_22915(o, p, q, r).method_22913(g, h).method_1344();
        class_286.method_43433((class_287.class_7433)bufferBuilder.method_1326());
        RenderSystem.disableBlend();
    }

    public static void renderItem(class_332 guiGraphics, class_1799 itemStack, class_1937 level, class_1309 livingEntity, int k, class_310 minecraft, int initialX, int initialY, int initialZ) {
        class_4587 newPose = new class_4587();
        int x = initialX;
        int y = initialY;
        switch (ItemInteractionsConfig.getAnimationSetting()) {
            case ANIM_SCALE: {
                newPose = AnimScale.makePose(x + 16, y + 16, 0);
                break;
            }
            case ANIM_SPEED: {
                newPose = AnimSpeed.makePose(x + 8, y + 8, 150, GlobalDirt.speedX, GlobalDirt.speedY, GlobalDirt.isCurrentItem3d);
            }
        }
        newPose.method_22903();
        guiGraphics.method_51448().method_34425(newPose.method_23760().method_23761());
    }

    public static int[] getSize(class_2960 particleLocation) {
        if (particleSizesCache.containsKey(particleLocation)) {
            return particleSizesCache.get(particleLocation);
        }
        return particleSizesCache.getOrDefault(particleLocation, new int[]{0, 0});
    }

    public static boolean setParticleSizeCache(class_2960 particleLocation) {
        try {
            InputStream stream = class_310.method_1551().method_1478().open(particleLocation);
            class_1011 image = class_1011.method_4309((InputStream)stream);
            int[] sizes = new int[]{image.method_4307(), image.method_4323()};
            particleSizesCache.put(particleLocation, sizes);
            return true;
        }
        catch (IOException e) {
            particleSizesCache.put(particleLocation, new int[]{0, 0});
            return false;
        }
    }
}

