/*
 * Decompiled with CFR 0.152.
 */
package dev.mineland.item_interactions_mod;

import dev.mineland.item_interactions_mod.Item_interactions_mod;
import dev.mineland.item_interactions_mod.MiscUtils;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Scanner;
import net.minecraft.class_2561;

public class ItemInteractionsConfig {
    private static final Path configPath = Path.of("config", "item_interactions.cfg");
    public static animation animationConfig;
    public static double scaleSpeed;
    public static double scaleAmount;
    public static double mouseSpeedMult;
    public static double mouseDeceleration;
    public static boolean enableGuiParticles;
    public static boolean debugDraws;

    public static void init() {
        animationConfig = DefaultValues.animationConfig;
        scaleSpeed = 1.0;
        scaleAmount = 0.1;
        mouseDeceleration = 1.0;
        mouseSpeedMult = 1.0;
        enableGuiParticles = true;
    }

    public static animation getAnimationSetting() {
        return animationConfig;
    }

    public static String getAnimationSettingString(animation anim) {
        return switch (anim.ordinal()) {
            case 0 -> "scale";
            case 1 -> "speed";
            default -> "none";
        };
    }

    public static void refreshConfig() {
        try {
            File configFile = configPath.toFile();
            if (!configFile.exists()) {
                configFile.createNewFile();
            }
            Scanner lector = new Scanner(configFile);
            int lineCount = 0;
            while (lector.hasNext() && lineCount < 20) {
                String line = lector.nextLine();
                int equalCount = MiscUtils.count(line, "=");
                if (equalCount != 1) {
                    Item_interactions_mod.infoMessage("Skipping line " + (lineCount + 1) + ": `" + line + "`. Contains " + equalCount + " `=``");
                    continue;
                }
                line = line.trim();
                int equalIndex = line.indexOf("=");
                String arg = line.substring(0, equalIndex).trim();
                String value = line.substring(equalIndex + 1).trim();
                block14 : switch (arg) {
                    case "animation": {
                        switch (value) {
                            case "scale": {
                                animationConfig = animation.ANIM_SCALE;
                                break block14;
                            }
                            case "speed": {
                                animationConfig = animation.ANIM_SPEED;
                                break block14;
                            }
                            case "none": {
                                animationConfig = animation.NONE;
                                break block14;
                            }
                        }
                        Item_interactions_mod.warnMessage("Unknown animation setting. Using Default (speed)");
                        animationConfig = DefaultValues.animationConfig;
                        break;
                    }
                    case "scale_speed": {
                        try {
                            scaleSpeed = Float.parseFloat(value);
                        }
                        catch (Exception e) {
                            Item_interactions_mod.warnMessage("Error parsing scale speed. Using default\n" + e.getMessage());
                            scaleSpeed = 1.0;
                        }
                        break;
                    }
                    case "scale_amount": {
                        try {
                            scaleAmount = Float.parseFloat(value);
                        }
                        catch (Exception e) {
                            Item_interactions_mod.warnMessage("Error parsing scale amount. Using default\n" + e.getMessage());
                            scaleAmount = 0.1;
                        }
                        break;
                    }
                    case "deceleration": {
                        try {
                            mouseDeceleration = Float.parseFloat(value);
                        }
                        catch (Exception e) {
                            Item_interactions_mod.warnMessage("Error parsing deceleration. Using default\n" + e.getMessage());
                            mouseDeceleration = 1.0;
                        }
                        break;
                    }
                    case "mouse_speed_multiplier": {
                        try {
                            mouseSpeedMult = Float.parseFloat(value);
                        }
                        catch (Exception e) {
                            Item_interactions_mod.warnMessage("Error parsing mouse speed multiplier. Using default\n" + e.getMessage());
                            mouseSpeedMult = 1.0;
                        }
                        break;
                    }
                    case "gui_particles": {
                        if (value.equals("true")) {
                            enableGuiParticles = true;
                            break;
                        }
                        if (value.equals("false")) {
                            enableGuiParticles = false;
                            break;
                        }
                    }
                    case "debug": {
                        if (value.equals("true")) {
                            debugDraws = true;
                        }
                        if (!value.equals("false")) break;
                        debugDraws = false;
                        break;
                    }
                    default: {
                        Item_interactions_mod.infoMessage("Ignoring line " + (lineCount + 1) + ". Unknown setting `" + arg + "`.");
                    }
                }
                ++lineCount;
            }
            if (animationConfig == null) {
                animationConfig = DefaultValues.animationConfig;
                Item_interactions_mod.infoMessage("Defaulting to animation: speed");
            }
            ItemInteractionsConfig.writeConfig(configFile);
        }
        catch (IOException e) {
            Item_interactions_mod.warnMessage("Failed to refresh the config! \n" + e.getMessage());
            Item_interactions_mod.warnMessage("Using the defaults");
            ItemInteractionsConfig.init();
        }
    }

    private static void writeConfig(File configFile) throws IOException {
        FileWriter obj = new FileWriter(configFile);
        String configFileString = String.format("animation = %s\nscale_speed = %f\nscale_amount = %f\ndeceleration = %f\nmouse_speed_multiplier = %f\ngui_particles = %s\ndebug = %s\n", ItemInteractionsConfig.animationConfig.name, scaleSpeed, scaleAmount, mouseDeceleration, mouseSpeedMult, enableGuiParticles ? "true" : "false", debugDraws ? "true" : "false");
        obj.write(configFileString);
        obj.flush();
    }

    public static void createConfig() {
        try {
            ItemInteractionsConfig.writeConfig(configPath.toFile());
        }
        catch (Exception e) {
            Item_interactions_mod.warnMessage("Error writing config file! \n" + e.toString());
        }
    }

    static class DefaultValues {
        public static final animation animationConfig = animation.ANIM_SPEED;
        public static final double scaleSpeed = 1.0;
        public static final double scaleAmount = 0.1;
        public static final double mouseDeceleration = 1.0;
        public static final double mouseSpeedMult = 1.0;
        public static final boolean enableGuiParticles = true;

        DefaultValues() {
        }
    }

    public static enum animation {
        ANIM_SCALE("scale"),
        ANIM_SPEED("speed"),
        NONE("none");

        public final String name;
        public final class_2561 component;

        private animation(String name) {
            this.name = name;
            this.component = class_2561.method_43470((String)this.name);
        }
    }
}

