/*
 * Decompiled with CFR 0.152.
 */
package dev.mineland.item_interactions_mod;

import dev.mineland.item_interactions_mod.CustomGuiComponents.ConfigInventoryPreview;
import dev.mineland.item_interactions_mod.CustomGuiComponents.SteppedSliderButton;
import dev.mineland.item_interactions_mod.GlobalDirt;
import dev.mineland.item_interactions_mod.ItemInteractionsConfig;
import dev.mineland.item_interactions_mod.MiscUtils;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5676;
import net.minecraft.class_7842;
import net.minecraft.class_7847;
import net.minecraft.class_7849;
import net.minecraft.class_7919;
import net.minecraft.class_8021;
import net.minecraft.class_8132;

@Environment(value=EnvType.CLIENT)
public class ItemInteractionsSettingsScreen
extends class_437 {
    private final class_437 parent;
    private final class_8132 layout = new class_8132((class_437)this, 33, 36);
    public class_4185 button1;
    public class_4185 button2;
    public class_4185 doneButton;
    private class_4185 debugButton;
    private class_5676<ItemInteractionsConfig.animation> animationCycleButton;
    private SteppedSliderButton scaleSpeed;
    private SteppedSliderButton scaleAmount;
    private SteppedSliderButton mouseSpeedMult;
    private SteppedSliderButton mouseDeceleration;
    private class_4185 guiParticlesButton;
    private class_4185 resetButton;
    class_7849 linearLayout = (class_7849)this.layout.method_48999((class_8021)new class_7849(this.field_22789, this.field_22790, class_7849.class_7851.field_40790));
    class_7849 bodyLayout = (class_7849)this.linearLayout.method_46496((class_8021)new class_7849(this.field_22789, this.field_22790 - 64, class_7849.class_7851.field_40789), class_7847.method_46481().method_46467());
    class_7849 rightColumnLayout = (class_7849)this.bodyLayout.method_46496((class_8021)new class_7849(0, 140, class_7849.class_7851.field_40790), class_7847.method_46481().method_46474().method_46467().method_46464(4));
    class_7849 leftColumnLayout = (class_7849)this.bodyLayout.method_46496((class_8021)new class_7849(0, 140, class_7849.class_7851.field_40790), class_7847.method_46481().method_46472().method_46467().method_46464(4));
    class_7849 speedAnimLayout = new class_7849(0, 44, class_7849.class_7851.field_40790);
    class_7849 scaleAnimLayout = new class_7849(0, 44, class_7849.class_7851.field_40790);
    ItemInteractionsConfig.animation oldAnimationConfig = ItemInteractionsConfig.animationConfig;
    double oldScaleSpeed = ItemInteractionsConfig.scaleSpeed;
    double oldScaleAmount = ItemInteractionsConfig.scaleAmount;
    double oldMouseDeceleration = ItemInteractionsConfig.mouseDeceleration;
    double oldMouseSpeedMult = ItemInteractionsConfig.mouseSpeedMult;
    boolean oldParticleEnabled = ItemInteractionsConfig.enableGuiParticles;
    private static final int DEFAULT_SPACING = 8;
    public ConfigInventoryPreview inventoryPreview = new ConfigInventoryPreview(this.field_22789 - 100 - 8, this.field_22790 / 2 - 50, 150, 100, (class_2561)class_2561.method_43470((String)"Inventory preview"));

    public ItemInteractionsSettingsScreen(class_437 parent) {
        super((class_2561)class_2561.method_43470((String)"Item interactions mod settings"));
        this.parent = parent;
        ItemInteractionsConfig.refreshConfig();
        GlobalDirt.restore();
        this.createLayout();
        this.animationCycleButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43470((String)"Type of animation that will play when carrying an item\nSpeed: tilts based off the mouse speed\nScale: scales the item up on cycles\nNone: no animation")));
        this.scaleSpeed.method_47400(class_7919.method_47407((class_2561)class_2561.method_43470((String)"Speed of the scaling animation measured in seconds/cycle.")));
        this.scaleAmount.method_47400(class_7919.method_47407((class_2561)class_2561.method_43470((String)"How much the item will scale up. \n0.1 = +1/10 \n1 = +1 (Double the item size)")));
        this.mouseSpeedMult.method_47400(class_7919.method_47407((class_2561)class_2561.method_43470((String)"Multiplier for the speed gained while moving the mouse")));
        this.mouseDeceleration.method_47400(class_7919.method_47407((class_2561)class_2561.method_43470((String)"The deceleration factor for the items. \n1 = normal deceleration\n0 = no deceleration")));
        this.guiParticlesButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43470((String)"Enable or disable particles in the inventory from resource packs.")));
        boolean hadItems = false;
        if (class_310.method_1551().field_1687 != null && class_310.method_1551().field_1724 != null) {
            for (int hotbar = 0; hotbar < 9; ++hotbar) {
                class_1799 item = class_310.method_1551().field_1724.method_31548().method_5438(hotbar).method_7972();
                this.inventoryPreview.setItem(hotbar, item);
                if (item.method_7960()) continue;
                hadItems = true;
            }
        }
        if (!hadItems) {
            this.inventoryPreview.setItem(0, new class_1799((class_1935)class_1802.field_8465));
            this.inventoryPreview.setItem(1, new class_1799((class_1935)class_1802.field_17503));
            this.inventoryPreview.setItem(2, new class_1799((class_1935)class_1802.field_8377));
            this.inventoryPreview.setItem(4, new class_1799((class_1935)class_1802.field_8230));
            this.inventoryPreview.setItem(6, new class_1799((class_1935)class_1802.field_8884));
            this.inventoryPreview.setItem(7, new class_1799((class_1935)class_1802.field_8470));
            this.inventoryPreview.setItem(8, new class_1799((class_1935)class_1802.field_8803));
        }
        this.updateVisible();
    }

    void updateVisible() {
        this.scaleAnimLayout.method_48206(widget -> {
            widget.field_22764 = false;
        });
        this.speedAnimLayout.method_48206(widget -> {
            widget.field_22764 = false;
        });
        this.animationCycleButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43470((String)"Type of animation that will play when carrying an item\n-speed: tilts based off the mouse speed\n-scale: scales the item up on cycles\n-none: no animation")));
        switch ((ItemInteractionsConfig.animation)((Object)this.animationCycleButton.method_32603())) {
            case ANIM_SCALE: {
                this.scaleAnimLayout.method_48206(widget -> {
                    widget.field_22764 = true;
                });
                break;
            }
            case ANIM_SPEED: {
                this.speedAnimLayout.method_48206(widget -> {
                    widget.field_22764 = true;
                });
                break;
            }
            case NONE: {
                this.scaleAnimLayout.method_48206(widget -> {
                    widget.field_22764 = false;
                });
                this.speedAnimLayout.method_48206(widget -> {
                    widget.field_22764 = false;
                });
            }
        }
    }

    void createLayout() {
        class_5250 debugButtonInitialText;
        this.layout.method_48992((class_8021)new class_7842(this.field_22785, class_310.method_1551().field_1772));
        this.animationCycleButton = (class_5676)this.leftColumnLayout.method_46495((class_8021)class_5676.method_32606(animationSetting -> animationSetting.component.method_27661().method_27692(animationSetting == ItemInteractionsConfig.animation.NONE ? class_124.field_1061 : class_124.field_1054)).method_32624((Object[])new ItemInteractionsConfig.animation[]{ItemInteractionsConfig.animation.ANIM_SPEED, ItemInteractionsConfig.animation.ANIM_SCALE, ItemInteractionsConfig.animation.NONE}).method_32619((Object)ItemInteractionsConfig.animationConfig).method_32617(0, 0, 150, 20, (class_2561)class_2561.method_43470((String)"Animation"), (arg, arg2) -> {
            ItemInteractionsConfig.animationConfig = arg2;
            this.updateVisible();
        }));
        this.scaleSpeed = (SteppedSliderButton)this.scaleAnimLayout.method_46495((class_8021)new SteppedSliderButton(0, 0, 150, 20, class_5244.field_39003, ItemInteractionsConfig.scaleSpeed, 0.0, 4.0, 40, false){
            {
                this.value = ItemInteractionsConfig.scaleSpeed;
                this.applyValue();
                this.updateMessage();
            }

            @Override
            protected void updateMessage() {
                this.method_25355((class_2561)class_2561.method_43470((String)("Scale speed: " + ItemInteractionsConfig.scaleSpeed)));
            }

            @Override
            protected void applyValue() {
                ItemInteractionsConfig.scaleSpeed = this.value;
            }
        });
        this.scaleAmount = (SteppedSliderButton)this.scaleAnimLayout.method_46495((class_8021)new SteppedSliderButton(0, 0, 150, 20, class_5244.field_39003, ItemInteractionsConfig.scaleAmount, 0.0, 2.0, 20, false){
            {
                this.value = ItemInteractionsConfig.scaleAmount;
                this.applyValue();
                this.updateMessage();
            }

            @Override
            protected void updateMessage() {
                this.method_25355((class_2561)class_2561.method_43470((String)("Scale amount: " + ItemInteractionsConfig.scaleAmount)));
            }

            @Override
            protected void applyValue() {
                ItemInteractionsConfig.scaleAmount = MiscUtils.clamp(this.value, this.minValue, this.maxValue);
            }
        });
        this.mouseSpeedMult = (SteppedSliderButton)this.speedAnimLayout.method_46495((class_8021)new SteppedSliderButton(0, 0, 150, 20, class_5244.field_39003, ItemInteractionsConfig.mouseSpeedMult, -2.0, 2.0, 40){
            {
                this.updateMessage();
            }

            @Override
            protected void updateMessage() {
                class_5250 message = class_2561.method_43470((String)("Mouse speed: " + ItemInteractionsConfig.mouseSpeedMult + "x"));
                this.method_25355((class_2561)message);
            }

            @Override
            protected void applyValue() {
                ItemInteractionsConfig.mouseSpeedMult = this.value;
            }
        });
        this.mouseDeceleration = (SteppedSliderButton)this.speedAnimLayout.method_46495((class_8021)new SteppedSliderButton(0, 0, 150, 20, class_5244.field_39003, ItemInteractionsConfig.mouseDeceleration, 0.0, 1.0, 10){
            {
                this.value = ItemInteractionsConfig.mouseDeceleration;
                this.applyValue();
                this.updateMessage();
            }

            @Override
            protected void updateMessage() {
                this.method_25355((class_2561)class_2561.method_43470((String)("Mouse deceleration: " + ItemInteractionsConfig.mouseDeceleration)));
            }

            @Override
            protected void applyValue() {
                ItemInteractionsConfig.mouseDeceleration = this.value;
            }
        });
        this.leftColumnLayout.method_46496((class_8021)this.speedAnimLayout, class_7847.method_46481().method_46472());
        this.leftColumnLayout.method_46496((class_8021)this.scaleAnimLayout, class_7847.method_46481().method_46472());
        if (ItemInteractionsConfig.debugDraws || GlobalDirt.devenv) {
            debugButtonInitialText = class_2561.method_43470((String)"debug: ").method_10852((class_2561)class_2561.method_43470((String)("" + ItemInteractionsConfig.debugDraws)).method_27692(ItemInteractionsConfig.debugDraws ? class_124.field_1060 : class_124.field_1061));
            this.debugButton = (class_4185)this.leftColumnLayout.method_46495((class_8021)class_4185.method_46430((class_2561)debugButtonInitialText, self -> {
                ItemInteractionsConfig.debugDraws = !ItemInteractionsConfig.debugDraws;
                class_124 color = ItemInteractionsConfig.debugDraws ? class_124.field_1060 : class_124.field_1061;
                self.method_25355((class_2561)class_2561.method_43470((String)"debug: ").method_10852((class_2561)class_2561.method_43470((String)("" + ItemInteractionsConfig.debugDraws)).method_27692(color)));
            }).method_46431());
        }
        this.inventoryPreview = (ConfigInventoryPreview)this.rightColumnLayout.method_46496((class_8021)this.inventoryPreview, class_7847.method_46481().method_46474());
        this.rightColumnLayout.method_46496((class_8021)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Restore defaults"), self -> this.resetToDefaults()).method_46432(100).method_46431(), class_7847.method_46481().method_46467());
        debugButtonInitialText = class_2561.method_43470((String)"Inventory particles: ").method_10852((class_2561)class_2561.method_43470((String)("" + ItemInteractionsConfig.enableGuiParticles)).method_27692(ItemInteractionsConfig.enableGuiParticles ? class_124.field_1060 : class_124.field_1061));
        this.guiParticlesButton = (class_4185)this.rightColumnLayout.method_46496((class_8021)class_4185.method_46430((class_2561)debugButtonInitialText, self -> {
            ItemInteractionsConfig.enableGuiParticles = !ItemInteractionsConfig.enableGuiParticles;
            class_124 color = ItemInteractionsConfig.enableGuiParticles ? class_124.field_1060 : class_124.field_1061;
            self.method_25355((class_2561)class_2561.method_43470((String)"Inventory particles: ").method_10852((class_2561)class_2561.method_43470((String)("" + ItemInteractionsConfig.enableGuiParticles)).method_27692(color)));
        }).method_46431(), class_7847.method_46481().method_46474().method_46471(8));
        class_7849 footerLayout = new class_7849(0, 0, class_7849.class_7851.field_40789);
        footerLayout.method_46496((class_8021)class_4185.method_46430((class_2561)class_5244.field_24334, arg -> this.method_25419()).method_46432(150).method_46431(), class_7847.method_46481().method_46469(4));
        footerLayout.method_46496((class_8021)class_4185.method_46430((class_2561)class_5244.field_24335, arg -> this.onCancel()).method_46432(150).method_46431(), class_7847.method_46481().method_46473(4));
        this.layout.method_48996((class_8021)footerLayout);
        this.updateVisible();
    }

    public void method_16014(double d, double e) {
        this.inventoryPreview.method_16014(d, e);
        super.method_16014(d, e);
    }

    public void method_25394(class_332 guiGraphics, int i, int j, float f) {
        this.method_25420(guiGraphics);
        super.method_25394(guiGraphics, i, j, f);
    }

    protected void method_25426() {
        this.layout.method_48206(arg2 -> {
            class_339 uhh = (class_339)this.method_37063((class_364)arg2);
        });
        this.layout.method_48222();
        int firstY = this.speedAnimLayout.method_46427();
        this.scaleAnimLayout.method_46419(firstY);
    }

    public void method_25419() {
        this.field_22787.method_1507(this.parent);
        ItemInteractionsConfig.createConfig();
    }

    public void onCancel() {
        ItemInteractionsConfig.animationConfig = this.oldAnimationConfig;
        ItemInteractionsConfig.scaleSpeed = this.oldScaleSpeed;
        ItemInteractionsConfig.scaleAmount = this.oldScaleAmount;
        ItemInteractionsConfig.mouseDeceleration = this.oldMouseDeceleration;
        ItemInteractionsConfig.mouseSpeedMult = this.oldMouseSpeedMult;
        ItemInteractionsConfig.enableGuiParticles = this.oldParticleEnabled;
        this.field_22787.method_1507(this.parent);
    }

    public void resetToDefaults() {
        this.animationCycleButton.method_32605((Object)ItemInteractionsConfig.DefaultValues.animationConfig);
        this.scaleSpeed.setValue(1.0);
        this.scaleAmount.setValue(0.1);
        this.mouseSpeedMult.setValue(1.0);
        this.mouseDeceleration.setValue(1.0);
        this.guiParticlesButton.method_25355((class_2561)class_2561.method_43470((String)"Inventory particles: ").method_10852((class_2561)class_2561.method_43470((String)"true").method_27692(class_124.field_1060)));
        ItemInteractionsConfig.init();
        this.updateVisible();
    }
}

