/*
 * Decompiled with CFR 0.152.
 */
package dev.mineland.item_interactions_mod;

public class MiscUtils {
    public static int count(String s, String match) {
        int length = match.length();
        int result = 0;
        for (int i = 0; i <= s.length() - length; ++i) {
            if (!s.substring(i, i + length).equals(match)) continue;
            ++result;
        }
        return result;
    }

    public static String preNumberCharacter(int number, String characters) {
        if (number < 0) {
            return new StringBuilder().append(number).insert(1, characters).toString();
        }
        return characters + number;
    }

    public static String preNumberCharacter(double number, String characters) {
        if (number < 0.0) {
            return new StringBuilder().append(number).insert(1, characters).toString();
        }
        return characters + number;
    }

    public static String preNumberCharacter(float number, String characters) {
        if (number < 0.0f) {
            return new StringBuilder().append(number).insert(1, characters).toString();
        }
        return characters + number;
    }

    public static double randomRange(double min, double max) {
        double range = max - min;
        return Math.random() * range + min;
    }

    public static double randomVariance(double n, double variance) {
        return n + MiscUtils.randomRange(-variance, variance);
    }

    public static int colorLerp(float t, int a, int b) {
        int[] s = MiscUtils.int2Array(a);
        int[] e = MiscUtils.int2Array(b);
        int A = MiscUtils.lerp(t, s[0], e[0]);
        int R = MiscUtils.lerp(t, s[1], e[1]);
        int G = MiscUtils.lerp(t, s[2], e[2]);
        int B = MiscUtils.lerp(t, s[3], e[3]);
        return MiscUtils.array2Int(new int[]{A, R, G, B});
    }

    public static int[] int2Array(int i) {
        return new int[]{i >> 24 & 0xFF, i >> 16 & 0xFF, i >> 8 & 0xFF, i & 0xFF};
    }

    public static int array2Int(int[] i) {
        return (i[0] << 24) + (i[1] << 16) + (i[2] << 8) + i[3];
    }

    public static int lerp(float t, int a, int b) {
        return (int)((float)a + (float)(b - a) * t);
    }

    public static float lerp(float t, float a, float b) {
        return a + (b - a) * t;
    }

    public static int[] applyBrightness(int[] colorArray, double brightness) {
        double clampedBrightness = MiscUtils.clamp(brightness, 0.0, 1.0);
        int r = (int)((double)colorArray[1] * clampedBrightness);
        int g = (int)((double)colorArray[2] * clampedBrightness);
        int b = (int)((double)colorArray[3] * clampedBrightness);
        return new int[]{colorArray[0], r, g, b};
    }

    public static double clamp(double value, double min, double max) {
        return Math.max(min, Math.min(value, max));
    }

    public static float clamp(float value, float min, float max) {
        return Math.max(min, Math.min(value, max));
    }

    public static int clamp(int value, int min, int max) {
        return Math.max(min, Math.min(value, max));
    }
}

