/*
 * Decompiled with CFR 0.152.
 */
package dev.mineland.item_interactions_mod.CustomGuiComponents;

import net.minecraft.class_10799;
import net.minecraft.class_1144;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_5250;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import net.minecraft.class_8015;
import net.minecraft.class_9848;
import org.jetbrains.annotations.NotNull;

public abstract class SteppedSliderButton
extends class_339 {
    private static final class_2960 SLIDER_SPRITE = class_2960.method_60656((String)"widget/slider");
    private static final class_2960 HIGHLIGHTED_SPRITE = class_2960.method_60656((String)"widget/slider_highlighted");
    private static final class_2960 SLIDER_HANDLE_SPRITE = class_2960.method_60656((String)"widget/slider_handle");
    private static final class_2960 SLIDER_HANDLE_HIGHLIGHTED_SPRITE = class_2960.method_60656((String)"widget/slider_handle_highlighted");
    protected static final int TEXT_MARGIN = 2;
    private static final int HANDLE_WIDTH = 8;
    private static final int HANDLE_HALF_WIDTH = 4;
    public double minValue;
    public double maxValue;
    public int steps;
    private double range;
    private int selectedStep;
    private boolean canChangeValue;
    public boolean divideSteps;
    private double handlePosition;
    public double value;
    private boolean dragging;

    public SteppedSliderButton(int left, int top, int width, int height, class_2561 message, double initialValue) {
        this(left, top, width, height, message, initialValue, 0.0, 1.0, 0, false);
    }

    public SteppedSliderButton(int left, int top, int width, int height, class_2561 message, double initialValue, double minValue, double maxValue) {
        this(left, top, width, height, message, initialValue, minValue, maxValue, 0, false);
    }

    public SteppedSliderButton(int left, int top, int width, int height, class_2561 message, double initialValue, double minValue, double maxValue, int steps) {
        this(left, top, width, height, message, initialValue, minValue, maxValue, steps, false);
    }

    public SteppedSliderButton(int left, int top, int width, int height, class_2561 message, double initialValue, double minValue, double maxValue, int steps, boolean divideSteps) {
        super(left, top, width, height, message);
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.steps = steps;
        this.range = maxValue - minValue;
        this.divideSteps = divideSteps;
        if (steps > 0) {
            this.selectedStep = (int)Math.round((initialValue - minValue) / this.range * (double)steps);
            this.setValueInternal((double)this.selectedStep / (double)steps * this.range + minValue);
        } else {
            this.setValueInternal(initialValue);
        }
        this.updateHandlePosition();
    }

    private class_2960 getSprite() {
        return this.method_37303() && this.method_25370() && !this.canChangeValue ? HIGHLIGHTED_SPRITE : SLIDER_SPRITE;
    }

    private class_2960 getHandleSprite() {
        return !this.method_37303() || !this.field_22762 && !this.canChangeValue ? SLIDER_HANDLE_SPRITE : SLIDER_HANDLE_HIGHLIGHTED_SPRITE;
    }

    @NotNull
    protected class_5250 method_25360() {
        return class_2561.method_43469((String)"gui.narrate.slider", (Object[])new Object[]{this.method_25369()});
    }

    protected void method_47399(class_6382 narrationElementOutput) {
        narrationElementOutput.method_37034(class_6381.field_33788, (class_2561)this.method_25360());
        if (this.field_22763) {
            if (this.method_25370()) {
                narrationElementOutput.method_37034(class_6381.field_33791, (class_2561)class_2561.method_43471((String)"narration.slider.usage.focused"));
            } else {
                narrationElementOutput.method_37034(class_6381.field_33791, (class_2561)class_2561.method_43471((String)"narration.slider.usage.hovered"));
            }
        }
    }

    public void method_48579(class_332 guiGraphics, int i, int j, float f) {
        class_310 minecraft = class_310.method_1551();
        double stepWidth = (double)this.method_25368() / (double)this.steps;
        if (this.divideSteps) {
            for (int x = 0; x < this.steps; ++x) {
                guiGraphics.method_52707(class_10799.field_56883, this.getSprite(), (int)((double)this.method_46426() + stepWidth * (double)x), this.method_46427(), (int)stepWidth, this.method_25364(), class_9848.method_61317((float)this.field_22765));
            }
        } else {
            guiGraphics.method_52707(class_10799.field_56883, this.getSprite(), this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364(), class_9848.method_61317((float)this.field_22765));
        }
        guiGraphics.method_52707(class_10799.field_56883, this.getHandleSprite(), this.method_46426() + (int)(this.handlePosition * (double)(this.field_22758 - 8)), this.method_46427(), 8, this.method_25364(), class_9848.method_61317((float)this.field_22765));
        int k = this.field_22763 ? 0xFFFFFF : 0xA0A0A0;
        this.method_49604(guiGraphics, minecraft.field_1772, 2, k | class_3532.method_15386((float)(this.field_22765 * 255.0f)) << 24);
    }

    public void method_25348(class_11909 mouseButtonEvent, boolean bl) {
        this.dragging = this.field_22763;
        this.setValueFromMouse(mouseButtonEvent);
    }

    public void updateHandlePosition() {
        this.handlePosition = this.steps > 0 ? (double)((float)this.selectedStep / (float)this.steps) : (this.value - this.minValue) / this.range;
    }

    public void method_25365(boolean bl) {
        super.method_25365(bl);
        if (!bl) {
            this.canChangeValue = false;
        } else {
            class_8015 inputType = class_310.method_1551().method_48186();
            if (inputType == class_8015.field_41778 || inputType == class_8015.field_41780) {
                this.canChangeValue = true;
            }
        }
    }

    public boolean method_25404(class_11908 keyEvent) {
        if (keyEvent.method_74229()) {
            this.canChangeValue = !this.canChangeValue;
            return true;
        }
        if (this.canChangeValue) {
            boolean leftKeyPressed = keyEvent.method_74232();
            boolean rightKeyPressed = keyEvent.method_74233();
            if (leftKeyPressed || rightKeyPressed) {
                int f;
                int n = f = leftKeyPressed ? -1 : 1;
                if (this.steps == 0) {
                    this.setValue(Math.clamp(this.value + (double)f / this.range, this.minValue, this.maxValue));
                } else {
                    this.setValueStep(this.selectedStep + f);
                }
                return true;
            }
        }
        return false;
    }

    private void setValueFromMouse(double d) {
        this.handlePosition = Math.clamp((d - (double)(this.method_46426() + 4)) / (double)(this.field_22758 - 8), 0.0, 1.0);
        this.setValueInternal(this.handlePosition * this.range + this.minValue);
    }

    private void setValueFromMouse(class_11909 mouseButtonEvent) {
        double normalizedProgressFromMouse = class_3532.method_15350((double)((mouseButtonEvent.comp_4798() - (double)(this.method_46426() + 4)) / (double)(this.field_22758 - 8)), (double)0.0, (double)1.0);
        this.setValue(normalizedProgressFromMouse * this.range + this.minValue);
    }

    public void setValueStep(int step) {
        this.setValueInternal(this.minValue + (double)step / (double)this.steps * this.range);
        this.updateHandlePosition();
    }

    private void setValueInternal(double d) {
        double currentValue = this.value;
        int targetStep = -1;
        double targetValue = d;
        if (this.steps > 0) {
            targetStep = (int)Math.round((d - this.minValue) / this.range * (double)this.steps);
            targetValue = class_3532.method_15350((double)((double)targetStep / (double)this.steps * this.range + this.minValue), (double)this.minValue, (double)this.maxValue);
        }
        if (currentValue != targetValue) {
            this.value = (double)Math.round(targetValue * 100.0) / 100.0;
            this.selectedStep = targetStep;
            this.applyValue();
        }
        this.updateMessage();
    }

    public void setValue(double d) {
        this.setValueInternal(d);
        this.updateHandlePosition();
    }

    protected void method_25349(class_11909 mouseButtonEvent, double d, double e) {
        this.setValueFromMouse(mouseButtonEvent);
        super.method_25349(mouseButtonEvent, d, e);
    }

    public void method_25354(class_1144 soundManager) {
    }

    public void onRelease(double d, double e) {
        super.method_25354(class_310.method_1551().method_1483());
        if (this.divideSteps) {
            this.updateHandlePosition();
        }
    }

    protected abstract void updateMessage();

    protected abstract void applyValue();
}

