/*
 * Decompiled with CFR 0.152.
 */
package dev.mineland.item_interactions_mod;

import dev.mineland.item_interactions_mod.GlobalDirt;
import dev.mineland.item_interactions_mod.ItemInteractionsConfig;
import dev.mineland.item_interactions_mod.ItemInteractionsMod;
import dev.mineland.item_interactions_mod.LineAlgs;
import dev.mineland.item_interactions_mod.MiscUtils;
import dev.mineland.item_interactions_mod.itemcarriedalgs.AnimTemplate;
import dev.mineland.item_interactions_mod.renderState.ColoredPolygonRenderState;
import dev.mineland.item_interactions_mod.renderState.GuiFloatingItemRenderState;
import net.minecraft.class_10444;
import net.minecraft.class_10799;
import net.minecraft.class_11231;
import net.minecraft.class_11244;
import net.minecraft.class_11246;
import net.minecraft.class_11256;
import net.minecraft.class_11278;
import net.minecraft.class_11540;
import net.minecraft.class_11566;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_811;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fc;
import org.joml.Quaternionf;
import org.joml.Vector2f;
import org.joml.Vector3f;

public class GuiRendererHelper {
    public static class_10444 currentItemStackRenderer;
    public static class_4587 currentPose;
    public static final class_11278 itemsProjectionMatrixBuffer;
    public static class_1799 prevItem;

    public static void clearItem() {
        currentItemStackRenderer = new class_10444();
        currentPose = new class_4587();
    }

    public static void renderItem(class_11246 guiRenderState, class_1799 itemStack, class_1937 level, class_1309 livingEntity, int k, class_310 minecraft, int initialX, int initialY, int initialZ) {
        class_11540 scratchItemStackRenderState = new class_11540();
        int x = initialX;
        int y = initialY;
        AnimTemplate anim = ItemInteractionsConfig.getAnimationSetting();
        if (anim == null) {
            return;
        }
        if (prevItem.method_7960() && !itemStack.method_7960()) {
            anim.reset(initialX, initialY, 1000);
        }
        prevItem = itemStack;
        class_332 guiGraphics = new class_332(class_310.method_1551(), guiRenderState);
        class_4587 newPose = anim.makePose(initialX, initialY, 0, GlobalDirt.speedX, -GlobalDirt.speedY, GlobalDirt.isCurrentItem3d, guiGraphics);
        try {
            minecraft.method_65386().method_65598((class_10444)scratchItemStackRenderState, itemStack, class_811.field_4317, level, (class_11566)livingEntity, k);
            AnimTemplate animationSetting = ItemInteractionsConfig.getAnimationSetting();
            float ivX = animationSetting.itemPos.x;
            float ivY = animationSetting.itemPos.y;
            int size = 64;
            int correction = size / 2 - 8;
            int x0 = (int)(ivX * 16.0f) + x - correction;
            int y0 = (int)(ivY * 16.0f) + y - correction;
            int x1 = (int)(ivX * 16.0f) + x - correction + size;
            int y1 = (int)(ivY * 16.0f) + y - correction + size;
            int scX = x + (int)(ivX * 16.0f) - correction;
            int scY = y + (int)(ivY * 16.0f) - correction;
            if (ItemInteractionsConfig.debugDraws) {
                guiGraphics.method_73198(scX, scY, size, size, -1);
            }
            guiRenderState.method_70922((class_11256)new GuiFloatingItemRenderState(scratchItemStackRenderState, new Vector3f(), new Quaternionf(), null, x0, y0, x1, y1, 16.0f, null, newPose));
        }
        catch (Exception e) {
            ItemInteractionsMod.errorMessage("Crashed. " + String.valueOf(e), new Object[0]);
        }
    }

    public static void renderItem(class_11246 guiRenderState, class_1799 itemStack, class_1937 level, class_1309 livingEntity, int k, class_310 minecraft, float initialX, float initialY, float initialZ) {
        class_11540 scratchItemStackRenderState = new class_11540();
        int x = (int)initialX;
        int y = (int)initialY;
        AnimTemplate anim = ItemInteractionsConfig.getAnimationSetting();
        if (anim == null) {
            return;
        }
        if (prevItem.method_7960() && !itemStack.method_7960()) {
            anim.reset((int)initialX, (int)initialY, 1000);
        }
        prevItem = itemStack;
        class_332 guiGraphics = new class_332(class_310.method_1551(), guiRenderState);
        class_4587 newPose = anim.makePose((int)initialX, (int)initialY, 0, GlobalDirt.speedX, GlobalDirt.speedY, GlobalDirt.isCurrentItem3d, guiGraphics);
        newPose.method_46416(initialX - (float)x, initialY - (float)y, initialZ - (float)Math.round(initialZ));
        try {
            minecraft.method_65386().method_65598((class_10444)scratchItemStackRenderState, itemStack, class_811.field_4317, level, (class_11566)livingEntity, k);
            AnimTemplate animationSetting = ItemInteractionsConfig.getAnimationSetting();
            float ivX = animationSetting.itemPos.x;
            float ivY = animationSetting.itemPos.y;
            int size = 64;
            int correction = size / 2 - 8;
            int x0 = (int)(ivX * 16.0f) + x - correction;
            int y0 = (int)(ivY * 16.0f) + y - correction;
            int x1 = (int)(ivX * 16.0f) + x - correction + size;
            int y1 = (int)(ivY * 16.0f) + y - correction + size;
            int scX = x + (int)(ivX * 16.0f) - correction;
            int scY = y + (int)(ivY * 16.0f) - correction;
            if (ItemInteractionsConfig.debugDraws) {
                guiGraphics.method_73198(scX, scY, size, size, -1);
            }
            guiRenderState.method_70922((class_11256)new GuiFloatingItemRenderState(scratchItemStackRenderState, new Vector3f(), new Quaternionf(), null, x0, y0, x1, y1, 16.0f, null, newPose));
        }
        catch (Exception e) {
            ItemInteractionsMod.errorMessage("Crashed. " + String.valueOf(e), new Object[0]);
        }
    }

    public static void setPixel(class_332 guiGraphics, int x, int y, int color) {
        guiGraphics.method_25294(x, y, x + 1, y + 1, color);
    }

    public static void renderLine(class_332 guiGraphics, int x0, int y0, int x1, int y1, int color) {
        GuiRendererHelper.renderLine(guiGraphics, x0, y0, x1, y1, color, true);
    }

    public static void renderLine(class_332 guiGraphics, float x0, float y0, float x1, float y1, int color) {
        GuiRendererHelper.renderLine(guiGraphics, x0, y0, x1, y1, color, true);
    }

    public static void renderLine(class_332 guiGraphics, float x0, float y0, float x1, float y1, int color, boolean pixelated) {
        if (pixelated) {
            if (x0 == x1 || y0 == y1) {
                int px = 0;
                int py = 0;
                if (y0 != y1) {
                    px = 1;
                }
                if (x0 != x1) {
                    py = 1;
                }
                guiGraphics.method_25294((int)x0, (int)y0, (int)x1 + px, (int)y1 + py, color);
                return;
            }
            LineAlgs.plotLine(guiGraphics, (int)x0, (int)y0, (int)x1, (int)y1, color);
            return;
        }
        class_4588 vertexConsumer = class_310.method_1551().method_22940().method_23000().method_73477(class_1921.method_23594());
        Vector2f p0 = new Vector2f(x0, y0);
        Vector2f p1 = new Vector2f(x1, y1);
        float angle = (float)Math.atan2(y1 - y0, x1 - x0);
        Vector2f[] points = new Vector2f[]{new Vector2f(), new Vector2f(), new Vector2f(), new Vector2f()};
        points[0] = MiscUtils.pointAtFrom(new Vector2f(1.5707964f + angle, 0.5f), p0);
        points[1] = MiscUtils.pointAtFrom(new Vector2f(1.5707964f + angle, 0.5f), p1);
        points[2] = MiscUtils.pointAtFrom(new Vector2f(-1.5707964f + angle, 0.5f), p1);
        points[3] = MiscUtils.pointAtFrom(new Vector2f(-1.5707964f + angle, 0.5f), p0);
        float brX = points[0].x();
        float brY = points[0].y();
        float trX = points[1].x();
        float trY = points[1].y();
        float tlX = points[2].x();
        float tlY = points[2].y();
        float blX = points[3].x();
        float blY = points[3].y();
        GlobalDirt.getGlobalGuiRenderState().method_70919((class_11244)new ColoredPolygonRenderState(class_10799.field_56879, class_11231.method_70899(), new Matrix3x2f((Matrix3x2fc)guiGraphics.method_51448()), new Vector2f(tlX, tlY), new Vector2f(trX, trY), new Vector2f(blX, blY), new Vector2f(brX, brY), color, color, null));
    }

    public static void renderLines_RepeatColors(class_332 guiGraphics, float[][] points, int[] colors, boolean pixelated) {
        int pointsLength = points.length;
        int colorsLength = colors.length;
        int length = Math.max(pointsLength, colorsLength);
        int[] newColors = new int[length + 1];
        for (int i = 0; i <= length; ++i) {
            newColors[i] = colors[i % colors.length];
        }
        GuiRendererHelper.renderLines(guiGraphics, points, newColors, pixelated);
    }

    public static void renderLine_ColorPattern(class_332 guiGraphics, float x0, float y0, float x1, float y1, int[] colors, int repeats, boolean pixelated) {
        if (repeats < 1) {
            repeats = 1;
        }
        if (MiscUtils.samePoint(x0, y0, x1, y1)) {
            return;
        }
        if (colors.length == 0) {
            return;
        }
        int length = repeats * colors.length;
        float[][] points = new float[1 + length][2];
        for (int i = 0; i <= length; ++i) {
            float progress = (float)i / (float)length;
            float x = MiscUtils.lerp(progress, x0, x1);
            float y = MiscUtils.lerp(progress, y0, y1);
            points[i] = new float[]{x, y};
        }
        GuiRendererHelper.renderLines_RepeatColors(guiGraphics, points, colors, pixelated);
    }

    private static void renderLines(class_332 guiGraphics, float[][] points, int[] colors, boolean pixelated) {
        if (points.length == 0) {
            return;
        }
        if (pixelated) {
            GuiRendererHelper.renderPixelatedLines(guiGraphics, points, colors);
        } else {
            GuiRendererHelper.renderSmoothLines(guiGraphics, points, colors);
        }
    }

    private static void renderPixelatedLines(class_332 guiGraphics, float[][] points, int[] colors) {
        if (points.length == 1) {
            GuiRendererHelper.setPixel(guiGraphics, (int)points[0][0], (int)points[0][1], colors[0]);
        }
        for (int i = 0; i < points.length - 1; ++i) {
            float[] currentPoint = points[i];
            float[] nextPoint = points[i + 1];
            if (MiscUtils.samePoint((int)currentPoint[0], (int)currentPoint[1], (int)nextPoint[0], (int)nextPoint[1])) continue;
            if (MiscUtils.outOfBoundsPoint(currentPoint[0], currentPoint[1])) break;
            GuiRendererHelper.renderLine(guiGraphics, currentPoint[0], currentPoint[1], nextPoint[0], nextPoint[1], colors[i], true);
        }
    }

    private static void renderSmoothLines(class_332 guiGraphics, float[][] points, int[] colors) {
        class_4588 vertexConsumer = class_310.method_1551().method_22940().method_23000().method_73477(class_1921.method_23594());
        try {
            for (int i = 0; i < points.length - 1; ++i) {
                float x0 = points[i][0];
                float y0 = points[i][1];
                float x1 = points[i + 1][0];
                float y1 = points[i + 1][1];
                Vector2f p0 = new Vector2f(x0, y0);
                Vector2f p1 = new Vector2f(x1, y1);
                float angle = (float)Math.atan2(y1 - y0, x1 - x0);
                Vector2f[] quadPoints = new Vector2f[]{new Vector2f(), new Vector2f(), new Vector2f(), new Vector2f()};
                quadPoints[0] = MiscUtils.pointAtFrom(new Vector2f(1.5707964f + angle, 0.5f), p0);
                quadPoints[1] = MiscUtils.pointAtFrom(new Vector2f(1.5707964f + angle, 0.5f), p1);
                quadPoints[2] = MiscUtils.pointAtFrom(new Vector2f(-1.5707964f + angle, 0.5f), p1);
                quadPoints[3] = MiscUtils.pointAtFrom(new Vector2f(-1.5707964f + angle, 0.5f), p0);
                float brX = quadPoints[0].x();
                float brY = quadPoints[0].y();
                float trX = quadPoints[1].x();
                float trY = quadPoints[1].y();
                float tlX = quadPoints[2].x();
                float tlY = quadPoints[2].y();
                float blX = quadPoints[3].x();
                float blY = quadPoints[3].y();
                GlobalDirt.getGlobalGuiRenderState().method_70919((class_11244)new ColoredPolygonRenderState(class_10799.field_56879, class_11231.method_70899(), new Matrix3x2f((Matrix3x2fc)guiGraphics.method_51448()), new Vector2f(tlX, tlY), new Vector2f(trX, trY), new Vector2f(blX, blY), new Vector2f(brX, brY), colors[i], colors[i], null));
            }
        }
        catch (Exception e) {
            MiscUtils.displayErrorInUi(e.getMessage());
        }
    }

    static {
        itemsProjectionMatrixBuffer = new class_11278("items", -1000.0f, 1000.0f, true);
        prevItem = class_1799.field_8037;
    }
}

