/*
 * Decompiled with CFR 0.152.
 */
package dev.mineland.item_interactions_mod.CustomGuiComponents;

import dev.mineland.item_interactions_mod.CarriedInteractions.GuiParticleSpawnersLogic;
import dev.mineland.item_interactions_mod.GlobalDirt;
import dev.mineland.item_interactions_mod.ItemInteractionsConfig;
import dev.mineland.item_interactions_mod.ItemInteractionsMod;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class ClientFakeContainer
implements Container {
    private final List<Slot> slots = new ArrayList<Slot>();
    private final List<ItemStack> itemStacks = new ArrayList<ItemStack>();
    private ItemStack mouseItem;
    private int x;
    private int y;
    private int slotSize = 18;
    private int columns;
    private int rows;

    public ClientFakeContainer(int columns, int rows, int left, int top) {
        int id = 0;
        this.x = left;
        this.y = top;
        this.columns = columns;
        this.rows = rows;
        int slotSize = this.slotSize;
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                Slot newSlot = new Slot((Container)this, id, left + j * slotSize, top + i * slotSize);
                newSlot.index = id++;
                ItemStack newEmptyItem = new ItemStack((ItemLike)ItemStack.EMPTY.getItem());
                this.slots.add(newSlot);
                this.itemStacks.add(newEmptyItem);
            }
        }
        this.mouseItem = ItemStack.EMPTY;
    }

    public void setX(int x) {
        this.x = x;
        this.updateSlots();
    }

    public void setY(int y) {
        this.y = y;
        this.updateSlots();
    }

    public void setPos(int x, int y) {
        this.x = x;
        this.y = y;
        this.updateSlots();
    }

    public void updateSlots() {
        int id = 0;
        for (int i = 0; i < this.columns; ++i) {
            for (int j = 0; j < this.rows; ++j) {
                Slot newSlot = new Slot((Container)this, id, this.x + j * this.slotSize, this.y + i * this.slotSize);
                newSlot.index = id;
                ItemStack oldItem = this.slots.get(id).getItem();
                newSlot.set(oldItem);
                this.slots.set(id, newSlot);
                ++id;
            }
        }
    }

    public int getContainerSize() {
        return this.slots.size();
    }

    public void renderSlots(GuiGraphics guiGraphics) {
        GlobalDirt.slotCount = 0;
        for (Slot slot : this.slots) {
            if (slot.getItem().isEmpty()) {
                ++GlobalDirt.slotCount;
                continue;
            }
            int itemX = slot.x + 1;
            int itemY = slot.y + 1;
            guiGraphics.renderItem(slot.getItem(), itemX, itemY);
            guiGraphics.renderItemDecorations(Minecraft.getInstance().font, slot.getItem(), itemX, itemY);
            if (!ItemInteractionsConfig.enableGuiParticles) continue;
            GuiParticleSpawnersLogic.checkAndTick(guiGraphics, slot, false, 0, 0, GlobalDirt.slotCount);
            ++GlobalDirt.slotCount;
        }
    }

    public void renderMouseItem(GuiGraphics guiGraphics, int x, int y) {
        GlobalDirt.carriedItem = this.mouseItem;
        guiGraphics.renderItem(this.mouseItem, x - 8, y - 8);
        guiGraphics.renderItemDecorations(Minecraft.getInstance().font, this.mouseItem, x - 8, y - 8);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        this.renderSlots(guiGraphics);
        guiGraphics.pose().pushMatrix();
        guiGraphics.pose().translate(0.0f, 0.0f);
        this.renderMouseItem(guiGraphics, mouseX, mouseY);
        guiGraphics.pose().translate(0.0f, 0.0f);
        guiGraphics.pose().popMatrix();
        GlobalDirt.skipCalcs = true;
        guiGraphics.renderItem(this.mouseItem, this.x + 18, this.y - 36);
        GlobalDirt.skipCalcs = false;
        GuiParticleSpawnersLogic.mainLogic(guiGraphics);
        GlobalDirt.carriedItem = ItemStack.EMPTY;
    }

    public void printItemStacks() {
        ItemInteractionsMod.infoMessage(this.itemStacks.toString());
    }

    public boolean isEmpty() {
        return false;
    }

    public ItemStack getItem(int i) {
        if (i > this.slots.size()) {
            return ItemStack.EMPTY;
        }
        if (i < 0) {
            return this.mouseItem;
        }
        return this.itemStacks.get(i);
    }

    public ItemStack removeItem(int id, int count) {
        return this.slots.get(id).getItem().split(count);
    }

    @NotNull
    public ItemStack removeItemNoUpdate(int id) {
        if (id >= this.slots.size() || id < 0) {
            return ItemStack.EMPTY;
        }
        ItemStack oldItem = this.slots.get(id).getItem();
        this.slots.get(id).set(ItemStack.EMPTY);
        return oldItem;
    }

    public void setItem(int i, ItemStack itemStack) {
        this.itemStacks.set(i, itemStack);
    }

    public void setChanged() {
    }

    public boolean stillValid(Player player) {
        return false;
    }

    public void clearContent() {
    }

    public boolean canPlaceItem(int i, ItemStack itemStack) {
        return super.canPlaceItem(i, itemStack);
    }

    public boolean canTakeItem(Container container, int i, ItemStack itemStack) {
        return super.canTakeItem(container, i, itemStack);
    }

    public ItemStack getMouseItem() {
        return this.mouseItem;
    }

    public void mouseClicked(double x, double y, int mouseButton) {
        int slotX = (int)Math.floor((x - (double)this.x) / (double)this.slotSize);
        int slotY = (int)Math.floor((y - (double)this.y) / (double)this.slotSize);
        int slotId = this.columns * slotY + slotX;
        if (slotX < 0 || slotY < 0 || slotX >= this.columns || slotY >= this.rows || slotId >= this.slots.size()) {
            return;
        }
        this.mouseClicked(slotId, mouseButton);
    }

    public void mouseClicked(int slotId, int mouseButton) {
        if (slotId < 0 || slotId >= this.slots.size()) {
            return;
        }
        Slot targetSlot = this.slots.get(slotId);
        switch (mouseButton) {
            case 0: {
                if (this.mouseItem.isEmpty() && targetSlot.hasItem()) {
                    this.mouseItem = targetSlot.getItem();
                    targetSlot.set(ItemStack.EMPTY);
                    break;
                }
                if (!this.mouseItem.isEmpty() && targetSlot.hasItem()) {
                    ItemStack oldMouse = this.mouseItem.copy();
                    this.mouseItem = targetSlot.getItem();
                    targetSlot.set(oldMouse);
                }
                this.mouseItem = targetSlot.safeInsert(this.mouseItem);
                break;
            }
            case 1: {
                if (this.mouseItem.isEmpty() && targetSlot.hasItem()) {
                    int takeCount = targetSlot.getItem().getCount();
                    this.mouseItem = targetSlot.getItem().split(takeCount / 2);
                    break;
                }
                if (this.mouseItem.isEmpty()) break;
                this.mouseItem = targetSlot.safeInsert(this.mouseItem, 1);
            }
        }
        GlobalDirt.carriedItem = this.mouseItem;
    }
}

