/*
 * Decompiled with CFR 0.152.
 */
package dev.mineland.item_interactions_mod;

import dev.mineland.item_interactions_mod.CustomGuiComponents.ConfigInventoryPreview;
import dev.mineland.item_interactions_mod.CustomGuiComponents.GraphOverTimeWidget;
import dev.mineland.item_interactions_mod.CustomGuiComponents.SteppedSliderButton;
import dev.mineland.item_interactions_mod.GlobalDirt;
import dev.mineland.item_interactions_mod.ItemInteractionsConfig;
import dev.mineland.item_interactions_mod.ItemInteractionsMod;
import dev.mineland.item_interactions_mod.itemcarriedalgs.AnimTemplate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.SharedConstants;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.HeaderAndFooterLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LayoutSettings;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.joml.Vector3f;

public class ItemInteractionsSettingsScreen
extends Screen {
    private final Screen parent;
    private final HeaderAndFooterLayout layout = new HeaderAndFooterLayout((Screen)this, 33, 36);
    private ImageButton versionWarningButton;
    private StringWidget warnStringWidget;
    private boolean enableVersionWarning = false;
    private Button debugButton;
    private CycleButton<String> animationCycleButton;
    private SteppedSliderButton scaleSpeed;
    private SteppedSliderButton scaleAmount;
    private SteppedSliderButton mouseSpeedMult;
    private SteppedSliderButton mouseDeceleration;
    private Button ropePixelated;
    private SteppedSliderButton ropeElasticity;
    private SteppedSliderButton ropeLength;
    private SteppedSliderButton ropeGravity;
    private SteppedSliderButton ropeInertia;
    private Button guiParticlesButton;
    private Button smoothParticlesButton;
    private Button resetButton;
    LinearLayout linearLayout = (LinearLayout)this.layout.addToContents((LayoutElement)LinearLayout.vertical().spacing(8));
    LinearLayout bodyLayout = ((LinearLayout)this.linearLayout.addChild((LayoutElement)LinearLayout.horizontal(), LayoutSettings::alignHorizontallyCenter)).spacing(8);
    LinearLayout leftColumnLayout = ((LinearLayout)this.bodyLayout.addChild((LayoutElement)LinearLayout.vertical(), LayoutSettings::alignVerticallyTop)).spacing(8);
    LinearLayout speedAnimLayout = LinearLayout.vertical().spacing(4);
    LinearLayout scaleAnimLayout = LinearLayout.vertical().spacing(4);
    LinearLayout ropeAnimLayout = LinearLayout.vertical().spacing(4);
    LinearLayout rightColumnLayout = ((LinearLayout)this.bodyLayout.addChild((LayoutElement)LinearLayout.vertical())).spacing(2);
    GraphOverTimeWidget mouseXPosGraph = GraphOverTimeWidget.builder("TickProgress", graph -> GlobalDirt.tickProgress, true).showTitle().showYAxis().setZLayer(1000.0f).showCurrentValue().size_fromInnerGraph(50, 0.0, 1.0, 50.0f).pos(0, 28).pixelatedGraph().graphDivisions(5).allowOverdraw().decimalPrecision(2).build();
    GraphOverTimeWidget mouseYPosGraph = GraphOverTimeWidget.builder("speed y", graph -> ItemInteractionsConfig.getAnimationSetting().itemSpeed.y(), true).showTitle().showYAxis().showCurrentValue().size_fromInnerGraph(50, -200.0, 200.0, 0.125f).pos(100, 8).pixelatedGraph().graphDivisions(5).allowOverdraw().decimalPrecision(5).build();
    static HashMap<String, Object> previousSettingsMap = new HashMap<String, Object>(ItemInteractionsConfig.settingsMap);
    boolean oldParticleEnabled = (Boolean)ItemInteractionsConfig.getSetting("gui_particles");
    boolean oldSmoothParticles = (Boolean)ItemInteractionsConfig.getSetting("gui_smooth_particles");
    public ConfigInventoryPreview inventoryPreview = new ConfigInventoryPreview(this.width - 100 - 8, this.height / 2 - 50, 150, 100, (Component)Component.literal((String)"Inventory preview"));
    private static final String animTooltipString = "Type of animation that will play when carrying an item\nSpeed: tilts based off the mouse speed\nScale: scales the item up on cycles\nRope: ties the item in a rope\nSpin: spins the item around\nNone: no animation";
    int timer = 10;

    public ItemInteractionsSettingsScreen(Screen parent) {
        super((Component)Component.literal((String)"Item interactions mod settings"));
        this.parent = parent;
        ItemInteractionsConfig.refreshConfig();
        GlobalDirt.restore();
        this.createLayout();
        this.animationCycleButton.setTooltip(Tooltip.create((Component)Component.literal((String)animTooltipString)));
        this.scaleSpeed.setTooltip(Tooltip.create((Component)Component.literal((String)"Speed of the scaling animation measured in seconds/cycle.")));
        this.scaleAmount.setTooltip(Tooltip.create((Component)Component.literal((String)"How much the item will scale up. \n0.1 = +1/10 \n1 = +1 (Double the item size)")));
        this.mouseSpeedMult.setTooltip(Tooltip.create((Component)Component.literal((String)"Multiplier for the speed gained while moving the mouse")));
        this.mouseDeceleration.setTooltip(Tooltip.create((Component)Component.literal((String)"The deceleration factor for the items. \n1 = normal deceleration\n0 = no deceleration")));
        this.guiParticlesButton.setTooltip(Tooltip.create((Component)Component.literal((String)"Enable or disable particles in the inventory from resource packs.")));
        this.smoothParticlesButton.setTooltip(Tooltip.create((Component)Component.literal((String)"Toggles weather the particles are locked to the texture grid or not.")));
        boolean hadItems = false;
        if (Minecraft.getInstance().level != null && Minecraft.getInstance().player != null) {
            for (int hotbar = 0; hotbar < 9; ++hotbar) {
                ItemStack item = Minecraft.getInstance().player.getInventory().getItem(hotbar).copy();
                this.inventoryPreview.setItem(hotbar, item);
                if (item.isEmpty()) continue;
                hadItems = true;
            }
        }
        if (!hadItems) {
            this.inventoryPreview.setItem(0, new ItemStack((ItemLike)Items.CRAFTING_TABLE));
            this.inventoryPreview.setItem(1, new ItemStack((ItemLike)Items.OAK_LEAVES));
            this.inventoryPreview.setItem(2, new ItemStack((ItemLike)Items.DIAMOND_PICKAXE));
            this.inventoryPreview.setItem(4, new ItemStack((ItemLike)Items.REDSTONE_LAMP));
            this.inventoryPreview.setItem(6, new ItemStack((ItemLike)Items.FLINT_AND_STEEL));
            this.inventoryPreview.setItem(7, new ItemStack((ItemLike)Items.ZOMBIE_HEAD));
            this.inventoryPreview.setItem(8, new ItemStack((ItemLike)Items.EGG));
        }
        this.updateVisible();
    }

    void updateVisible() {
        this.scaleAnimLayout.visitWidgets(widget -> {
            widget.visible = false;
        });
        this.speedAnimLayout.visitWidgets(widget -> {
            widget.visible = false;
        });
        this.ropeAnimLayout.visitWidgets(widget -> {
            widget.visible = false;
        });
        this.animationCycleButton.setTooltip(Tooltip.create((Component)Component.literal((String)animTooltipString)));
        String value = (String)this.animationCycleButton.getValue();
        if (this.enableVersionWarning && this.versionWarningButton != null) {
            this.versionWarningButton.visible = true;
            this.versionWarningButton.active = !value.equals("none");
        }
        switch (value) {
            case "scale": {
                this.scaleAnimLayout.visitWidgets(widget -> {
                    widget.visible = true;
                });
                break;
            }
            case "speed": {
                this.speedAnimLayout.visitWidgets(widget -> {
                    widget.visible = true;
                });
                break;
            }
            case "rope": {
                this.ropeAnimLayout.visitWidgets(widget -> {
                    widget.visible = true;
                });
                break;
            }
            default: {
                this.scaleAnimLayout.visitWidgets(widget -> {
                    widget.visible = false;
                });
                this.speedAnimLayout.visitWidgets(widget -> {
                    widget.visible = false;
                });
            }
        }
    }

    void createLayout() {
        this.layout.addTitleHeader(this.title, Minecraft.getInstance().font);
        ArrayList<String> anims = new ArrayList<String>();
        for (AnimTemplate a : ItemInteractionsConfig.animationList) {
            anims.add(a.getId());
        }
        anims.add("none");
        this.animationCycleButton = (CycleButton)this.leftColumnLayout.addChild((LayoutElement)CycleButton.builder(animationSetting -> Component.literal((String)animationSetting).withStyle(animationSetting.equals("none") ? ChatFormatting.RED : ChatFormatting.YELLOW)).withValues(anims).withInitialValue((Object)((String)ItemInteractionsConfig.getSetting("animation"))).create(0, 0, 150, 20, (Component)Component.literal((String)"Animation"), (button, string) -> {
            ItemInteractionsConfig.setAnimationSetting(string);
            ItemInteractionsConfig.getAnimationSetting().reset((int)GlobalDirt.lastMouseX, (int)GlobalDirt.lastMouseY, 0);
            this.updateVisible();
        }));
        this.addScaleAnimSettings();
        this.addSpeedAnimSettings();
        this.addPhysAnimSettings();
        this.layout.addToContents((LayoutElement)this.speedAnimLayout);
        this.layout.addToContents((LayoutElement)this.scaleAnimLayout);
        this.layout.addToContents((LayoutElement)this.ropeAnimLayout);
        this.inventoryPreview = (ConfigInventoryPreview)this.rightColumnLayout.addChild((LayoutElement)this.inventoryPreview, LayoutSettings::alignVerticallyMiddle);
        this.rightColumnLayout.addChild((LayoutElement)Button.builder((Component)Component.literal((String)"Restore defaults"), self -> this.resetToDefaults()).width(100).build(), LayoutSettings::alignHorizontallyCenter);
        MutableComponent guiButtonInitialText = Component.literal((String)"Inventory particles: ").append((Component)Component.literal((String)String.valueOf(ItemInteractionsConfig.getSetting("gui_particles"))).withStyle((Boolean)ItemInteractionsConfig.getSetting("gui_particles") != false ? ChatFormatting.GREEN : ChatFormatting.RED));
        MutableComponent guiSmoothInitialText = Component.literal((String)"Smooth particles: ").append((Component)Component.literal((String)String.valueOf(ItemInteractionsConfig.getSetting("gui_smooth_particles"))).withStyle((Boolean)ItemInteractionsConfig.getSetting("gui_smooth_particles") != false ? ChatFormatting.GREEN : ChatFormatting.RED));
        this.guiParticlesButton = (Button)this.rightColumnLayout.addChild((LayoutElement)Button.builder((Component)guiButtonInitialText, self -> {
            ItemInteractionsConfig.enableGuiParticles = !ItemInteractionsConfig.enableGuiParticles;
            ItemInteractionsConfig.setSetting("gui_particles", ItemInteractionsConfig.enableGuiParticles);
            ChatFormatting color = ItemInteractionsConfig.enableGuiParticles ? ChatFormatting.GREEN : ChatFormatting.RED;
            self.setMessage((Component)Component.literal((String)"Inventory particles: ").append((Component)Component.literal((String)("" + ItemInteractionsConfig.enableGuiParticles)).withStyle(color)));
            this.smoothParticlesButton.active = ItemInteractionsConfig.enableGuiParticles;
        }).build(), LayoutSettings::alignHorizontallyCenter);
        this.smoothParticlesButton = (Button)this.rightColumnLayout.addChild((LayoutElement)Button.builder((Component)guiSmoothInitialText, self -> {
            ItemInteractionsConfig.smoothGuiParticles = !ItemInteractionsConfig.smoothGuiParticles;
            ItemInteractionsConfig.setSetting("gui_smooth_particles", ItemInteractionsConfig.smoothGuiParticles);
            ChatFormatting color = (Boolean)ItemInteractionsConfig.getSetting("gui_smooth_particles") != false ? ChatFormatting.GREEN : ChatFormatting.RED;
            self.setMessage((Component)Component.literal((String)"Smooth particles: ").append((Component)Component.literal((String)("" + ItemInteractionsConfig.smoothGuiParticles)).withStyle(color)));
        }).build(), LayoutSettings::alignHorizontallyCenter);
        LinearLayout footerLayout = LinearLayout.horizontal().spacing(8);
        footerLayout.addChild((LayoutElement)Button.builder((Component)CommonComponents.GUI_CANCEL, arg -> this.onCancel()).width(150).build());
        footerLayout.addChild((LayoutElement)Button.builder((Component)CommonComponents.GUI_DONE, arg -> this.onClose()).width(150).build());
        this.layout.addToFooter((LayoutElement)footerLayout);
        this.addVersionWarning();
        this.updateVisible();
        MutableComponent debugButtonInitialText = Component.literal((String)"debug: ").append((Component)Component.literal((String)("" + ItemInteractionsConfig.debugDraws)).withStyle(ItemInteractionsConfig.debugDraws ? ChatFormatting.GREEN : ChatFormatting.RED));
        if (ItemInteractionsConfig.debugDraws || GlobalDirt.devenv) {
            this.debugButton = Button.builder((Component)debugButtonInitialText, self -> {
                boolean d = ItemInteractionsConfig.debugDraws;
                ItemInteractionsConfig.setSetting("debug", !d);
                ItemInteractionsConfig.debugDraws = !d;
                ChatFormatting color = (Boolean)ItemInteractionsConfig.getSetting("debug") != false ? ChatFormatting.GREEN : ChatFormatting.RED;
                self.setMessage((Component)Component.literal((String)"debug: ").append((Component)Component.literal((String)String.valueOf(ItemInteractionsConfig.getSetting("debug"))).withStyle(color)));
            }).build();
            this.debugButton.setPosition(8, 8);
            this.debugButton.setSize(120, 20);
            this.addRenderableWidget((GuiEventListener)this.debugButton);
        }
    }

    private void addVersionWarning() {
        String verString = SharedConstants.getCurrentVersion().id();
        boolean snapshot = verString.contains("w");
        StringBuilder versionWarnMessage = new StringBuilder();
        ArrayList<String> versionWarnMessages = new ArrayList<String>();
        if (snapshot) {
            versionWarnMessages.add("> You're playing on a snapshot version. This is not supported");
        }
        if (ItemInteractionsMod.isNeo()) {
            versionWarnMessages.add("> Due to NeoForge weirdness, items appear with no light");
        }
        if (!versionWarnMessages.isEmpty()) {
            String countString = (versionWarnMessages.size() > 1 ? "These" : "This") + " will be fixed eventually, but you can disable animations in the meantime to get around this";
            for (String msg : versionWarnMessages) {
                versionWarnMessage.append(msg).append('\n');
            }
            versionWarnMessage.append(countString);
            WidgetSprites widgetSprites = new WidgetSprites(ResourceLocation.withDefaultNamespace((String)"dialog/warning_button"), ResourceLocation.withDefaultNamespace((String)"dialog/warning_button_disabled"), ResourceLocation.withDefaultNamespace((String)"dialog/warning_button_highlighted"));
            this.versionWarningButton = new ImageButton(Minecraft.getInstance().getWindow().getGuiScaledWidth() - 8 - 20, 8, 20, 20, widgetSprites, button -> {});
            this.versionWarningButton.setTooltip(Tooltip.create((Component)Component.literal((String)versionWarnMessage.toString())));
            this.warnStringWidget = new StringWidget((Component)Component.literal((String)"WARNING: THERE ARE VERSION ISSUES").withStyle(Style.EMPTY.withColor(ChatFormatting.YELLOW).withBold(Boolean.valueOf(true))), Minecraft.getInstance().font);
            this.enableVersionWarning = true;
        }
    }

    private void addPhysAnimSettings() {
        double elasticity = (Double)ItemInteractionsConfig.getSetting("rope_elasticity");
        double length = (Double)ItemInteractionsConfig.getSetting("rope_length");
        Vector3f gravity = (Vector3f)ItemInteractionsConfig.getSetting("rope_gravity");
        double inertia = (Double)ItemInteractionsConfig.getSetting("rope_inertia");
        boolean pixelated = (Boolean)ItemInteractionsConfig.getSetting("rope_pixelated");
        this.ropeElasticity = (SteppedSliderButton)this.ropeAnimLayout.addChild((LayoutElement)new SteppedSliderButton(this, 0, 0, 150, 20, CommonComponents.EMPTY, elasticity, 0.0, 1.0, 20){
            {
                this.updateMessage();
            }

            @Override
            protected void updateMessage() {
                MutableComponent message = Component.literal((String)("Elasticity: " + this.value));
                this.setMessage((Component)message);
            }

            @Override
            protected void applyValue() {
                ItemInteractionsConfig.setSetting("rope_elasticity", this.value);
            }
        });
        this.ropeLength = (SteppedSliderButton)this.ropeAnimLayout.addChild((LayoutElement)new SteppedSliderButton(this, 0, 0, 150, 20, CommonComponents.EMPTY, length, 1.0, 64.0, 63, false){
            {
                this.updateMessage();
            }

            @Override
            protected void updateMessage() {
                MutableComponent message = Component.literal((String)("Length: " + (int)this.value));
                this.setMessage((Component)message);
            }

            @Override
            protected void applyValue() {
                ItemInteractionsConfig.setSetting("rope_length", this.value);
            }
        });
        this.ropeGravity = (SteppedSliderButton)this.ropeAnimLayout.addChild((LayoutElement)new SteppedSliderButton(this, 0, 0, 150, 20, CommonComponents.EMPTY, (double)gravity.y(), -32.0, 32.0, 128){
            {
                this.updateMessage();
            }

            @Override
            protected void updateMessage() {
                MutableComponent message = Component.literal((String)("Gravity: " + this.value));
                this.setMessage((Component)message);
            }

            @Override
            protected void applyValue() {
                Vector3f gravity = (Vector3f)ItemInteractionsConfig.getSetting("rope_gravity");
                ItemInteractionsConfig.setSetting("rope_gravity", new Vector3f(gravity.x, (float)this.value, gravity.z));
            }
        });
        this.ropeInertia = (SteppedSliderButton)this.ropeAnimLayout.addChild((LayoutElement)new SteppedSliderButton(this, 0, 0, 150, 20, CommonComponents.EMPTY, inertia, 0.0, 1.0, 20){
            {
                this.updateMessage();
            }

            @Override
            protected void updateMessage() {
                MutableComponent message = Component.literal((String)("Inertia: " + this.value));
                this.setMessage((Component)message);
            }

            @Override
            protected void applyValue() {
                ItemInteractionsConfig.setSetting("rope_inertia", this.value);
            }
        });
        this.ropePixelated = (Button)this.ropeAnimLayout.addChild((LayoutElement)Button.builder((Component)Component.literal((String)"Pixel consistent: ").append((Component)Component.literal((String)("" + pixelated)).withStyle(pixelated ? ChatFormatting.GREEN : ChatFormatting.RED)), self -> {
            boolean rope = (Boolean)ItemInteractionsConfig.getSetting("rope_pixelated") == false;
            ItemInteractionsConfig.setSetting("rope_pixelated", rope);
            self.setMessage((Component)Component.literal((String)"Pixel consistent: ").append((Component)Component.literal((String)("" + rope)).withStyle(rope ? ChatFormatting.GREEN : ChatFormatting.RED)));
        }).build());
    }

    private void addSpeedAnimSettings() {
        this.mouseSpeedMult = (SteppedSliderButton)this.speedAnimLayout.addChild((LayoutElement)new SteppedSliderButton(this, 0, 0, 150, 20, CommonComponents.EMPTY, (double)((Double)ItemInteractionsConfig.getSetting("mouse_speed_multiplier")), -2.0, 2.0, 40){
            {
                this.updateMessage();
            }

            @Override
            protected void updateMessage() {
                MutableComponent message = Component.literal((String)("Mouse speed: " + String.valueOf(ItemInteractionsConfig.getSetting("mouse_speed_multiplier")) + "x"));
                this.setMessage((Component)message);
            }

            @Override
            protected void applyValue() {
                ItemInteractionsConfig.setSetting("mouse_speed_multiplier", this.value);
            }
        });
        this.mouseDeceleration = (SteppedSliderButton)this.speedAnimLayout.addChild((LayoutElement)new SteppedSliderButton(this, 0, 0, 150, 20, CommonComponents.EMPTY, (double)((Double)ItemInteractionsConfig.getSetting("mouse_deceleration")), 0.0, 1.0, 10){
            {
                this.value = (Double)ItemInteractionsConfig.getSetting("mouse_deceleration");
                this.applyValue();
                this.updateMessage();
            }

            @Override
            protected void updateMessage() {
                this.setMessage((Component)Component.literal((String)("Mouse deceleration: " + String.valueOf(ItemInteractionsConfig.getSetting("mouse_deceleration")))));
            }

            @Override
            protected void applyValue() {
                ItemInteractionsConfig.setSetting("mouse_deceleration", this.value);
            }
        });
    }

    private void addScaleAnimSettings() {
        this.scaleSpeed = (SteppedSliderButton)this.scaleAnimLayout.addChild((LayoutElement)new SteppedSliderButton(this, 0, 0, 150, 20, CommonComponents.EMPTY, (Double)ItemInteractionsConfig.getSetting("scale_speed"), 0.0, 4.0, 40, false){
            {
                this.value = (Double)ItemInteractionsConfig.getSetting("scale_speed");
                this.applyValue();
                this.updateMessage();
            }

            @Override
            protected void updateMessage() {
                this.setMessage((Component)Component.literal((String)("Scale speed: " + String.valueOf(ItemInteractionsConfig.getSetting("scale_speed")))));
            }

            @Override
            protected void applyValue() {
                ItemInteractionsConfig.setSetting("scale_speed", this.value);
            }
        });
        this.scaleAmount = (SteppedSliderButton)this.scaleAnimLayout.addChild((LayoutElement)new SteppedSliderButton(this, 0, 0, 150, 20, CommonComponents.EMPTY, (Double)ItemInteractionsConfig.getSetting("scale_amount"), 0.0, 2.0, 20, false){
            {
                this.value = (Double)ItemInteractionsConfig.getSetting("scale_amount");
                this.applyValue();
                this.updateMessage();
            }

            @Override
            protected void updateMessage() {
                this.setMessage((Component)Component.literal((String)("Scale amount: " + String.valueOf(ItemInteractionsConfig.getSetting("scale_amount")))));
            }

            @Override
            protected void applyValue() {
                ItemInteractionsConfig.setSetting("scale_amount", Math.clamp(this.value, this.minValue, this.maxValue));
            }
        });
    }

    public void render(GuiGraphics guiGraphics, int i, int j, float f) {
        super.render(guiGraphics, i, j, f);
        GlobalDirt.setGlobalGuiGraphics(guiGraphics);
        AnimTemplate currentAnimation = ItemInteractionsConfig.getAnimationSetting();
        if (currentAnimation != null) {
            currentAnimation.refreshSettings();
        }
    }

    public void mouseMoved(double d, double e) {
        this.inventoryPreview.mouseMoved(d, e);
        super.mouseMoved(d, e);
    }

    protected void init() {
        this.layout.visitWidgets(arg2 -> {
            AbstractWidget uhh = (AbstractWidget)this.addRenderableWidget((GuiEventListener)arg2);
        });
        this.layout.arrangeElements();
        this.leftColumnLayout.setY(this.rightColumnLayout.getY());
        int firstY = this.leftColumnLayout.getY() + 20 + 8;
        this.speedAnimLayout.setPosition(this.leftColumnLayout.getX(), firstY);
        this.scaleAnimLayout.setPosition(this.leftColumnLayout.getX(), firstY);
        this.ropeAnimLayout.setPosition(this.leftColumnLayout.getX(), firstY);
        this.addRenderableWidget((GuiEventListener)this.mouseXPosGraph);
        this.addRenderableWidget((GuiEventListener)this.mouseYPosGraph);
        if (!ItemInteractionsConfig.debugDraws) {
            this.mouseXPosGraph.visible = false;
        }
        this.mouseYPosGraph.visible = false;
        if (this.enableVersionWarning) {
            this.versionWarningButton.setPosition(this.width - 8 - 20, 8);
            int n = this.width / 2 - this.warnStringWidget.getWidth() / 2;
            Objects.requireNonNull(Minecraft.getInstance().font);
            this.warnStringWidget.setPosition(n, 9 * 3);
            this.addRenderableWidget((GuiEventListener)this.versionWarningButton);
            this.addRenderableWidget((GuiEventListener)this.warnStringWidget);
        }
    }

    public void onClose() {
        this.minecraft.setScreen(this.parent);
        ItemInteractionsConfig.createConfig();
    }

    public void onCancel() {
        ItemInteractionsConfig.enableGuiParticles = this.oldParticleEnabled;
        ItemInteractionsConfig.smoothGuiParticles = this.oldSmoothParticles;
        ItemInteractionsConfig.settingsMap = previousSettingsMap;
        this.minecraft.setScreen(this.parent);
    }

    public void resetToDefaults() {
        this.animationCycleButton.setValue((Object)((String)ItemInteractionsConfig.getDefaultSetting("animation")));
        this.scaleSpeed.setValue((Double)ItemInteractionsConfig.getDefaultSetting("scale_speed"));
        this.scaleAmount.setValue((Double)ItemInteractionsConfig.getDefaultSetting("scale_amount"));
        this.mouseSpeedMult.setValue((Double)ItemInteractionsConfig.getDefaultSetting("mouse_speed_multiplier"));
        this.mouseDeceleration.setValue((Double)ItemInteractionsConfig.getDefaultSetting("mouse_deceleration"));
        this.ropePixelated.setMessage((Component)Component.literal((String)"Pixel consistent: ").append((Component)Component.literal((String)String.valueOf(ItemInteractionsConfig.getDefaultSetting("rope_pixelated"))).withStyle(ChatFormatting.GREEN)));
        this.ropeElasticity.setValue((Double)ItemInteractionsConfig.getDefaultSetting("rope_elasticity"));
        this.ropeLength.setValue((Double)ItemInteractionsConfig.getDefaultSetting("rope_length"));
        this.ropeGravity.setValue(((Vector3f)ItemInteractionsConfig.getDefaultSetting("rope_gravity")).y());
        this.ropeInertia.setValue((Double)ItemInteractionsConfig.getDefaultSetting("rope_inertia"));
        this.guiParticlesButton.setMessage((Component)Component.literal((String)"Inventory particles: ").append((Component)Component.literal((String)String.valueOf(ItemInteractionsConfig.getDefaultSetting("gui_particles"))).withStyle(ChatFormatting.GREEN)));
        this.smoothParticlesButton.setMessage((Component)Component.literal((String)"Smooth particles: ").append((Component)Component.literal((String)String.valueOf(ItemInteractionsConfig.getDefaultSetting("gui_smooth_particles"))).withStyle(ChatFormatting.RED)));
        ItemInteractionsConfig.init();
        this.updateVisible();
    }
}

