/*
 * Decompiled with CFR 0.152.
 */
package dev.mineland.item_interactions_mod.itemcarriedalgs;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.mineland.item_interactions_mod.GlobalDirt;
import dev.mineland.item_interactions_mod.itemcarriedalgs.AnimTemplate;
import net.minecraft.client.gui.GuiGraphics;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class AnimSpeed
extends AnimTemplate {
    double mouseDeceleration;
    double mouseSpeedMult;
    float speedX = 0.0f;
    float speedY = 0.0f;

    @Override
    public void refreshSettings() {
        this.mouseSpeedMult = (Double)this.getSetting("mouse_speed_multiplier");
        this.mouseDeceleration = (Double)this.getSetting("mouse_deceleration");
    }

    public AnimSpeed() {
        super("speed");
        this.addSetting("mouse_speed_multiplier", 1.0);
        this.addSetting("mouse_deceleration", 1.0);
    }

    @Override
    public PoseStack makePose(int x, int y, int z, double doubleSpeedX, double doubleSpeedY, boolean is3d, GuiGraphics guiGraphics) {
        PoseStack newPose = new PoseStack();
        boolean posX = false;
        boolean posY = false;
        boolean posZ = false;
        double drag = Math.exp(-(16.0 * this.mouseDeceleration * this.mouseDeceleration) * (double)GlobalDirt.msTickDelta);
        double mouseSpeedMultiplier = this.mouseSpeedMult;
        this.speedX = (float)Math.clamp(((double)this.speedX + doubleSpeedX * mouseSpeedMultiplier) * drag, -100.0, 100.0);
        this.speedY = (float)Math.clamp(((double)this.speedY + doubleSpeedY * mouseSpeedMultiplier) * drag, -100.0, 100.0);
        float zPlane = 382.0f;
        if (is3d) {
            Quaternionf quatPointTo = new Quaternionf().rotateTo(0.0f, 0.0f, zPlane, this.speedX * 4.0f, this.speedY * 4.0f, zPlane).normalize();
            newPose.rotateAround((Quaternionfc)quatPointTo, (float)posX, (float)posY, (float)posZ);
        } else {
            float angleVertical = 0.3926991f * Math.clamp(-this.speedY * 0.1f, -1.5f, 1.5f);
            float angleHorizontal = (float)Math.PI / 180 * -this.speedX * 0.4f;
            Quaternionf quatRotateVertical = new Quaternionf().rotateX(angleVertical).rotateZ(angleHorizontal).normalize();
            newPose.rotateAround((Quaternionfc)quatRotateVertical, (float)posX, (float)posY, (float)posZ);
        }
        return newPose;
    }
}

