/*
 * Decompiled with CFR 0.152.
 */
package dev.mineland.item_interactions_mod.mixin;

import dev.mineland.item_interactions_mod.GlobalDirt;
import dev.mineland.item_interactions_mod.GuiRendererHelper;
import dev.mineland.item_interactions_mod.ItemInteractionsConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.render.state.GuiRenderState;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.world.entity.ItemOwner;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.joml.Matrix3x2fStack;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GuiGraphics.class})
public abstract class GuiGraphicsMixin {
    @Shadow
    @Final
    private Minecraft minecraft;
    @Shadow
    @Final
    private GuiRenderState guiRenderState;
    @Shadow
    @Final
    private Matrix3x2fStack pose;

    @Inject(order=1500, at={@At(value="HEAD")}, method={"renderItem(Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/level/Level;Lnet/minecraft/world/item/ItemStack;III)V"})
    private void renderItemHead(LivingEntity livingEntity, Level level, ItemStack itemStack, int i, int j, int k, CallbackInfo ci) {
        if (!itemStack.isEmpty() && GlobalDirt.carriedItem == itemStack) {
            ItemStackRenderState scratchItemStackRenderState = new ItemStackRenderState();
            this.minecraft.getItemModelResolver().updateForTopItem(scratchItemStackRenderState, itemStack, ItemDisplayContext.GUI, level, (ItemOwner)livingEntity, k);
            GlobalDirt.isCurrentItem3d = scratchItemStackRenderState.usesBlockLight();
            if (GuiGraphicsMixin.iteminteractions$canAnimate() && !ItemInteractionsConfig.getAnimationSetting().getId().equals("none")) {
                GuiRendererHelper.renderItem(this.guiRenderState, itemStack, level, livingEntity, k, this.minecraft, i, j, 20000);
                this.pose.pushMatrix();
                this.pose.scale(0.0f, 0.0f);
            }
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"renderItem(Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/level/Level;Lnet/minecraft/world/item/ItemStack;III)V"})
    private void renderItemTail(LivingEntity livingEntity, Level level, ItemStack itemStack, int i, int j, int k, CallbackInfo ci) {
        if (!itemStack.isEmpty() && GlobalDirt.carriedItem == itemStack && GuiGraphicsMixin.iteminteractions$canAnimate() && !ItemInteractionsConfig.getAnimationSetting().getId().equals("none")) {
            this.pose.popMatrix();
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"<init>(Lnet/minecraft/client/Minecraft;Lorg/joml/Matrix3x2fStack;Lnet/minecraft/client/gui/render/state/GuiRenderState;)V"})
    private void setGlobalGuiGraphics(Minecraft minecraft, Matrix3x2fStack matrix3x2fStack, GuiRenderState guiRenderState, CallbackInfo ci) {
        GuiGraphics self = (GuiGraphics)this;
        GlobalDirt.setGlobalGuiGraphics(self);
        GlobalDirt.setGlobalGuiRenderState(guiRenderState);
    }

    @Unique
    private static boolean iteminteractions$canAnimate() {
        if (Minecraft.getInstance().level == null) {
            return true;
        }
        return Minecraft.getInstance().level.tickRateManager().runsNormally() || Minecraft.getInstance().isPaused();
    }
}

