/*
 * Decompiled with CFR 0.152.
 */
package dev.mineland.item_interactions_mod.mixin;

import dev.mineland.item_interactions_mod.CarriedInteractions.GuiParticleSpawnersLogic;
import dev.mineland.item_interactions_mod.GlobalDirt;
import dev.mineland.item_interactions_mod.ItemInteractionsConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AbstractContainerScreen.class})
public abstract class InventoryGuiMixin {
    @Shadow
    protected int topPos;
    @Shadow
    protected int leftPos;
    @Shadow
    private ItemStack draggingItem;
    @Unique
    boolean dead = false;

    @Inject(method={"renderFloatingItem(Lnet/minecraft/client/gui/GuiGraphics;Lnet/minecraft/world/item/ItemStack;IILjava/lang/String;)V"}, at={@At(value="HEAD")})
    protected void mixedRenderFloatingItem(GuiGraphics guiGraphics, ItemStack itemStack, int i, int j, @Nullable String string, CallbackInfo callbackInfo) {
        GlobalDirt.carriedItem = itemStack;
    }

    @Inject(method={"render(Lnet/minecraft/client/gui/GuiGraphics;IIF)V"}, at={@At(value="HEAD")})
    public void renderMixinHead(GuiGraphics guiGraphics, int i, int j, float f, CallbackInfo ci) {
        GlobalDirt.setGlobalGuiGraphics(guiGraphics);
        GlobalDirt.updateTimer();
        GlobalDirt.slotCount = 0;
    }

    @Inject(method={"render(Lnet/minecraft/client/gui/GuiGraphics;IIF)V"}, at={@At(value="TAIL")})
    public void renderMixinTail(GuiGraphics guiGraphics, int i, int j, float f, CallbackInfo ci) {
        GlobalDirt.tailUpdateTimer();
        GlobalDirt.updateMousePositions();
        if (((Boolean)ItemInteractionsConfig.getSetting("debug")).booleanValue()) {
            guiGraphics.drawString(Minecraft.getInstance().font, "msCounter: " + GlobalDirt.msCounter, 0, 50, -1);
            guiGraphics.drawString(Minecraft.getInstance().font, "absSpeed: " + GlobalDirt.absSpeed, 0, 60, GlobalDirt.isShaking ? -224 : -1);
        }
        if (((Boolean)ItemInteractionsConfig.getSetting("gui_particles")).booleanValue()) {
            GuiParticleSpawnersLogic.mainLogic(guiGraphics);
        }
        GlobalDirt.carriedItem = ItemStack.EMPTY;
    }

    @Inject(method={"init()V"}, at={@At(value="HEAD")})
    protected void initHeadMixin(CallbackInfo ci) {
        GlobalDirt.particleList.clear();
        GlobalDirt.slotSpawners.clear();
    }

    @Inject(method={"init()V"}, at={@At(value="TAIL")})
    protected void initMixin(CallbackInfo ci) {
        GlobalDirt.restore();
    }

    @Inject(method={"renderSlot(Lnet/minecraft/client/gui/GuiGraphics;Lnet/minecraft/world/inventory/Slot;)V"}, at={@At(value="TAIL")})
    void checkForParticlesWhenRenderSlot(GuiGraphics guiGraphics, Slot slot, CallbackInfo ci) {
        if (!((Boolean)ItemInteractionsConfig.getSetting("gui_particles")).booleanValue()) {
            return;
        }
        this.dead = GuiParticleSpawnersLogic.checkAndTick(guiGraphics, slot, this.dead, this.leftPos, this.topPos, GlobalDirt.slotCount);
        ++GlobalDirt.slotCount;
    }
}

