/*
 * Decompiled with CFR 0.152.
 */
package dev.mineland.item_interactions_mod.renderState;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.mineland.item_interactions_mod.ItemInteractionsMod;
import dev.mineland.item_interactions_mod.renderState.GuiFloatingItemRenderState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.render.pip.PictureInPictureRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.SubmitNodeStorage;
import net.minecraft.client.renderer.feature.FeatureRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;

public class GuiFloatingItemRenderer
extends PictureInPictureRenderer<GuiFloatingItemRenderState> {
    public GuiFloatingItemRenderer(MultiBufferSource.BufferSource bufferSource) {
        super(bufferSource);
    }

    public Class<GuiFloatingItemRenderState> getRenderStateClass() {
        return GuiFloatingItemRenderState.class;
    }

    protected void renderToTexture(GuiFloatingItemRenderState pictureInPictureRenderState, PoseStack poseStack) {
        Quaternionf quaternionf = pictureInPictureRenderState.overrideCameraAngle();
        if (quaternionf != null) {
            ItemInteractionsMod.infoMessage("Override camera provided");
        }
        PoseStack finalPose = new PoseStack();
        finalPose.last().set(poseStack.last());
        finalPose.pushPose();
        finalPose.scale(1.0f, -1.0f, -1.0f);
        finalPose.translate(0.0f, 2.0f, 0.0f);
        finalPose.pushPose();
        finalPose.mulPose((Matrix4fc)pictureInPictureRenderState.poseStack().last().pose());
        boolean blockLight = pictureInPictureRenderState.renderState().usesBlockLight();
        if (blockLight) {
            Minecraft.getInstance().gameRenderer.getLighting().setupFor(Lighting.Entry.ITEMS_3D);
        } else {
            Minecraft.getInstance().gameRenderer.getLighting().setupFor(Lighting.Entry.ITEMS_FLAT);
        }
        int magicNumber = 0xF000F0;
        int lightLevelMaybe = 0;
        SubmitNodeStorage node = new SubmitNodeStorage();
        pictureInPictureRenderState.renderState().submit(finalPose, (SubmitNodeCollector)node, magicNumber, OverlayTexture.NO_OVERLAY, lightLevelMaybe);
        FeatureRenderDispatcher featureRendererDispatcher = new FeatureRenderDispatcher(node, Minecraft.getInstance().getBlockRenderer(), this.bufferSource, Minecraft.getInstance().getAtlasManager(), Minecraft.getInstance().renderBuffers().outlineBufferSource(), Minecraft.getInstance().renderBuffers().crumblingBufferSource(), Minecraft.getInstance().font);
        featureRendererDispatcher.renderAllFeatures();
    }

    protected String getTextureLabel() {
        return "item_interactions_mod: renderFloatingItem";
    }
}

