/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod;

import ckathode.weaponmod.WMUtil;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class AdvancedExplosion
extends Explosion {
    protected static final Random rand = new Random();
    public final Level worldObj;
    public final DamageSource damageSource;
    public final double explosionX;
    public final double explosionY;
    public final double explosionZ;
    public final Entity exploder;
    public final float explosionSize;
    protected boolean blocksCalculated;

    public AdvancedExplosion(Level world, Entity entity, double x, double y, double z, float size, boolean flame, Explosion.BlockInteraction mode) {
        super(world, entity, x, y, z, size, flame, mode);
        this.worldObj = world;
        this.damageSource = world.damageSources().explosion((Explosion)this);
        this.exploder = entity;
        this.explosionX = x;
        this.explosionY = y;
        this.explosionZ = z;
        this.explosionSize = size;
    }

    public void setAffectedBlockPositions(List<BlockPos> list) {
        this.getToBlow().addAll(list);
        this.blocksCalculated = true;
    }

    public void doEntityExplosion() {
        this.doEntityExplosion(this.damageSource);
    }

    public void doEntityExplosion(DamageSource damagesource) {
        float size = this.explosionSize * 2.0f;
        int k1 = Mth.floor((double)(this.explosionX - (double)size - 1.0));
        int l1 = Mth.floor((double)(this.explosionX + (double)size + 1.0));
        int i2 = Mth.floor((double)(this.explosionY - (double)size - 1.0));
        int i3 = Mth.floor((double)(this.explosionY + (double)size + 1.0));
        int j2 = Mth.floor((double)(this.explosionZ - (double)size - 1.0));
        int j3 = Mth.floor((double)(this.explosionZ + (double)size + 1.0));
        List list = this.worldObj.getEntities(this.exploder, new AABB((double)k1, (double)i2, (double)j2, (double)l1, (double)i3, (double)j3));
        Vec3 vec31 = new Vec3(this.explosionX, this.explosionY, this.explosionZ);
        for (Entity entity : list) {
            double dz;
            double dy;
            double dx;
            double d;
            double dr;
            if (entity.ignoreExplosion((Explosion)this) || !((dr = Math.sqrt(entity.distanceToSqr(this.explosionX, this.explosionY, this.explosionZ)) / (double)size) <= 1.0) || (d = Math.sqrt((dx = entity.getX() - this.explosionX) * dx + (dy = entity.getY() - this.explosionY) * dy + (dz = entity.getZ() - this.explosionZ) * dz)) == 0.0) continue;
            dx /= d;
            dy /= d;
            dz /= d;
            double dens = AdvancedExplosion.getSeenPercent((Vec3)vec31, (Entity)entity);
            double var36 = (1.0 - dr) * dens;
            int damage = (int)((var36 * var36 + var36) / 2.0 * 8.0 * (double)size + 1.0);
            entity.hurt(damagesource, (float)damage);
            entity.setDeltaMovement(entity.getDeltaMovement().add(dx * var36, dy * var36, dz * var36));
        }
    }

    public void doBlockExplosion() {
        if (!this.blocksCalculated) {
            this.calculateBlockExplosion();
        }
        ObjectArrayList positions = new ObjectArrayList((Collection)this.getToBlow());
        ArrayList list = new ArrayList();
        Util.shuffle((List)positions, (RandomSource)WMUtil.RANDOM);
        for (BlockPos blockPos2 : positions) {
            this.worldObj.getBlockState(blockPos2).onExplosionHit(this.worldObj, blockPos2, (Explosion)this, (itemStack, blockPos) -> Explosion.addOrAppendStack((List)list, (ItemStack)itemStack, (BlockPos)blockPos));
        }
        for (Pair pair : list) {
            Block.popResource((Level)this.worldObj, (BlockPos)((BlockPos)pair.getSecond()), (ItemStack)((ItemStack)pair.getFirst()));
        }
    }

    public void doFlaming() {
        if (!this.blocksCalculated) {
            this.calculateBlockExplosion();
        }
        for (BlockPos blockpos : this.getToBlow()) {
            if (rand.nextInt(3) != 0 || !this.worldObj.getBlockState(blockpos).isAir() || !this.worldObj.getBlockState(blockpos.below()).isSolidRender((BlockGetter)this.worldObj, blockpos.below())) continue;
            this.worldObj.setBlockAndUpdate(blockpos, BaseFireBlock.getState((BlockGetter)this.worldObj, (BlockPos)blockpos));
        }
    }

    public void doParticleExplosion(boolean smallparticles, boolean bigparticles) {
        this.worldObj.playSound(null, this.explosionX, this.explosionY, this.explosionZ, (SoundEvent)SoundEvents.GENERIC_EXPLODE.value(), SoundSource.BLOCKS, 4.0f, (1.0f + (WMUtil.RANDOM.nextFloat() - WMUtil.RANDOM.nextFloat()) * 0.2f) * 0.7f);
        if (bigparticles && this.worldObj.isClientSide()) {
            this.worldObj.addParticle((ParticleOptions)ParticleTypes.EXPLOSION, this.explosionX, this.explosionY, this.explosionZ, 0.0, 0.0, 0.0);
        }
        if (!smallparticles) {
            return;
        }
        if (!this.blocksCalculated) {
            this.calculateBlockExplosion();
        }
        for (BlockPos blockpos : this.getToBlow()) {
            double px = (float)blockpos.getX() + WMUtil.RANDOM.nextFloat();
            double py = (float)blockpos.getY() + WMUtil.RANDOM.nextFloat();
            double pz = (float)blockpos.getZ() + WMUtil.RANDOM.nextFloat();
            double dx = px - this.explosionX;
            double dy = py - this.explosionY;
            double dz = pz - this.explosionZ;
            double distance = Math.sqrt(dx * dx + dy * dy + dz * dz);
            dx /= distance;
            dy /= distance;
            dz /= distance;
            double d7 = 0.5 / (distance / (double)this.explosionSize + 0.1);
            dx *= (d7 *= (double)(WMUtil.RANDOM.nextFloat() * WMUtil.RANDOM.nextFloat() + 0.3f));
            dy *= d7;
            dz *= d7;
            if (!this.worldObj.isClientSide()) continue;
            this.worldObj.addParticle((ParticleOptions)ParticleTypes.POOF, (px + this.explosionX) / 2.0, (py + this.explosionY) / 2.0, (pz + this.explosionZ) / 2.0, dx, dy, dz);
            this.worldObj.addParticle((ParticleOptions)ParticleTypes.SMOKE, px, py, pz, dx, dy, dz);
        }
    }

    protected void calculateBlockExplosion() {
        int maxsize = 16;
        HashSet set = Sets.newHashSet();
        for (int j = 0; j < maxsize; ++j) {
            for (int k = 0; k < maxsize; ++k) {
                for (int l = 0; l < maxsize; ++l) {
                    if (j != 0 && j != maxsize - 1 && k != 0 && k != maxsize - 1 && l != 0 && l != maxsize - 1) continue;
                    double rx = (float)j / 15.0f * 2.0f - 1.0f;
                    double ry = (float)k / 15.0f * 2.0f - 1.0f;
                    double rz = (float)l / 15.0f * 2.0f - 1.0f;
                    double rd = Math.sqrt(rx * rx + ry * ry + rz * rz);
                    rx /= rd;
                    ry /= rd;
                    rz /= rd;
                    double dx = this.explosionX;
                    double dy = this.explosionY;
                    double dz = this.explosionZ;
                    float f = 0.3f;
                    for (float strength = this.explosionSize * (0.7f + WMUtil.RANDOM.nextFloat() * 0.6f); strength > 0.0f; strength -= 0.22500001f) {
                        BlockPos blockpos = BlockPos.containing((double)dx, (double)dy, (double)dz);
                        BlockState iblockstate = this.worldObj.getBlockState(blockpos);
                        if (!iblockstate.isAir()) {
                            strength -= (iblockstate.getBlock().getExplosionResistance() + 0.3f) * f;
                        }
                        if (strength > 0.0f) {
                            set.add(blockpos);
                        }
                        dx += rx * 0.3;
                        dy += ry * 0.3;
                        dz += rz * 0.3;
                    }
                }
            }
        }
        this.getToBlow().addAll(set);
        this.blocksCalculated = true;
    }
}

