/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod.entity.projectile;

import ckathode.weaponmod.PhysHelper;
import ckathode.weaponmod.WMDamageSources;
import ckathode.weaponmod.WMRegistries;
import ckathode.weaponmod.WeaponModConfig;
import ckathode.weaponmod.entity.projectile.EntityProjectile;
import dev.architectury.networking.NetworkManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityDynamite
extends EntityProjectile<EntityDynamite> {
    public static final String ID = "dynamite";
    public static final EntityType<EntityDynamite> TYPE = WMRegistries.createEntityType("dynamite", EntityDimensions.fixed((float)0.5f, (float)0.5f).withEyeHeight(0.0f), EntityDynamite::new);
    private int explodefuse;
    private boolean extinguished;

    public EntityDynamite(EntityType<EntityDynamite> entityType, Level world) {
        super(entityType, world);
        this.setPickupStatus(EntityProjectile.PickupStatus.DISALLOWED);
        this.extinguished = false;
        this.explodefuse = this.random.nextInt(30) + 20;
    }

    public EntityDynamite(Level world, double d, double d1, double d2, @Nullable ItemStack firedFromWeapon) {
        super(TYPE, world, firedFromWeapon);
        this.setPickupStatus(EntityProjectile.PickupStatus.DISALLOWED);
        this.extinguished = false;
        this.explodefuse = this.random.nextInt(30) + 20;
        this.setPos(d, d1, d2);
    }

    public EntityDynamite(Level world, LivingEntity shooter, int i, @Nullable ItemStack firedFromWeapon) {
        this(world, shooter.getX(), shooter.getEyeY() - 0.1, shooter.getZ(), firedFromWeapon);
        this.setOwner((Entity)shooter);
        this.explodefuse = i;
    }

    @NotNull
    public Packet<ClientGamePacketListener> getAddEntityPacket(ServerEntity serverEntity) {
        return NetworkManager.createAddEntityPacket((Entity)this, (ServerEntity)serverEntity);
    }

    public void shootFromRotation(Entity entity, float f, float f1, float f2, float f3, float f4) {
        float x = -Mth.sin((float)(f1 * ((float)Math.PI / 180))) * Mth.cos((float)(f * ((float)Math.PI / 180)));
        float y = -Mth.sin((float)(f * ((float)Math.PI / 180)));
        float z = Mth.cos((float)(f1 * ((float)Math.PI / 180))) * Mth.cos((float)(f * ((float)Math.PI / 180)));
        this.shoot(x, y, z, f3, f4);
        Vec3 entityMotion = entity.getDeltaMovement();
        this.setDeltaMovement(this.getDeltaMovement().add(entityMotion.x, entity.onGround() ? 0.0 : entityMotion.y, entityMotion.z));
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.inGround && !this.beenInGround) {
            this.setXRot(this.getXRot() - 50.0f);
            if (this.getXRot() <= -360.0f) {
                this.setXRot(this.getXRot() + 360.0f);
            }
        } else {
            this.xRotO = 180.0f;
            this.setXRot(this.xRotO);
        }
        if (this.isInWater() && !this.extinguished) {
            this.extinguished = true;
            this.playSound(SoundEvents.GENERIC_EXTINGUISH_FIRE, 1.0f, 1.2f / (this.random.nextFloat() * 0.2f + 0.9f));
            for (int k = 0; k < 8; ++k) {
                float f6 = 0.25f;
                Vec3 motion = this.getDeltaMovement();
                Vec3 pos = this.position().subtract(motion.scale((double)f6));
                if (!this.level().isClientSide()) continue;
                this.level().addParticle((ParticleOptions)ParticleTypes.POOF, pos.x, pos.y, pos.z, motion.x, motion.y, motion.z);
            }
        }
        --this.explodefuse;
        if (!this.extinguished) {
            if (this.explodefuse <= 0) {
                this.detonate();
                this.remove(Entity.RemovalReason.DISCARDED);
            } else if (this.level().isClientSide()) {
                this.level().addParticle((ParticleOptions)ParticleTypes.SMOKE, this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    @NotNull
    public DamageSource getDamageSource() {
        return this.damageSources().source(WMDamageSources.WEAPON, (Entity)this, this.getDamagingEntity());
    }

    @Override
    public void onHitEntity(EntityHitResult result) {
        Entity entity = result.getEntity();
        if (entity.hurt(this.getDamageSource(), 1.0f)) {
            this.applyEntityHitEffects(entity);
            this.playHitSound();
            this.lerpMotion(0.0, 0.0, 0.0);
            this.ticksInAir = 0;
        }
    }

    @Override
    public void onHitBlock(BlockHitResult result) {
        BlockPos blockpos = result.getBlockPos();
        this.xTile = blockpos.getX();
        this.yTile = blockpos.getY();
        this.zTile = blockpos.getZ();
        this.inBlockState = this.level().getBlockState(blockpos);
        Vec3 motion = result.getLocation().subtract(this.position());
        this.setDeltaMovement(motion);
        Vec3 newPos = this.position().subtract(motion.normalize().scale(0.05));
        this.setPos(newPos.x, newPos.y, newPos.z);
        this.setDeltaMovement(-0.2 * motion.x, motion.y, -0.2 * motion.z);
        if (result.getDirection() == Direction.UP) {
            this.inGround = true;
            this.beenInGround = true;
        } else {
            this.inGround = false;
            this.playSound(SoundEvents.GENERIC_EXTINGUISH_FIRE, 1.0f, 1.2f / (this.random.nextFloat() * 0.2f + 0.9f));
        }
        if (this.inBlockState != null) {
            this.inBlockState.entityInside(this.level(), blockpos, (Entity)this);
        }
    }

    private void detonate() {
        if (this.level().isClientSide) {
            return;
        }
        if (this.extinguished && (this.ticksInGround >= 200 || this.ticksInAir >= 200)) {
            this.remove(Entity.RemovalReason.DISCARDED);
        }
        float f = 2.0f;
        PhysHelper.createAdvancedExplosion(this.level(), (Entity)this, this.getX(), this.getY(), this.getZ(), f, WeaponModConfig.get().dynamiteDoesBlockDamage, true, false, Explosion.BlockInteraction.DESTROY);
    }

    @Override
    public boolean aimRotation() {
        return false;
    }

    @Override
    public int getMaxArrowShake() {
        return 0;
    }

    @Override
    @NotNull
    protected ItemStack getPickupItem() {
        return this.getDefaultPickupItem();
    }

    @Override
    @NotNull
    protected ItemStack getDefaultPickupItem() {
        return new ItemStack((ItemLike)WMRegistries.ITEM_DYNAMITE.get());
    }

    @Override
    public void playHitSound() {
        this.playSound(SoundEvents.GENERIC_EXTINGUISH_FIRE, 1.0f, 1.2f / (this.random.nextFloat() * 0.2f + 0.9f));
    }

    @Override
    public void addAdditionalSaveData(CompoundTag nbttagcompound) {
        super.addAdditionalSaveData(nbttagcompound);
        nbttagcompound.putByte("fuse", (byte)this.explodefuse);
        nbttagcompound.putBoolean("off", this.extinguished);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag nbttagcompound) {
        super.readAdditionalSaveData(nbttagcompound);
        this.explodefuse = nbttagcompound.getByte("fuse");
        this.extinguished = nbttagcompound.getBoolean("off");
    }
}

