/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod.entity.projectile;

import ckathode.weaponmod.PhysHelper;
import ckathode.weaponmod.WMDamageSources;
import ckathode.weaponmod.WMRegistries;
import ckathode.weaponmod.WeaponModConfig;
import ckathode.weaponmod.entity.projectile.EntityProjectile;
import dev.architectury.networking.NetworkManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityMortarShell
extends EntityProjectile<EntityMortarShell> {
    public static final String ID = "shell";
    public static final EntityType<EntityMortarShell> TYPE = WMRegistries.createEntityType("shell", EntityDimensions.fixed((float)0.5f, (float)0.5f).withEyeHeight(0.0f), EntityMortarShell::new);
    public float explosiveSize = 2.0f;

    public EntityMortarShell(EntityType<EntityMortarShell> entityType, Level world) {
        super(entityType, world);
    }

    public EntityMortarShell(Level world, double d, double d1, double d2, @Nullable ItemStack firedFromWeapon) {
        super(TYPE, world, firedFromWeapon);
        this.setPickupStatus(EntityProjectile.PickupStatus.ALLOWED);
        this.setPos(d, d1, d2);
    }

    public EntityMortarShell(Level world, LivingEntity shooter, @Nullable ItemStack firedFromWeapon) {
        this(world, shooter.getX(), shooter.getEyeY() - 0.1, shooter.getZ(), firedFromWeapon);
        this.setOwner((Entity)shooter);
        this.setPickupStatusFromEntity(shooter);
    }

    @NotNull
    public Packet<ClientGamePacketListener> getAddEntityPacket(ServerEntity serverEntity) {
        return NetworkManager.createAddEntityPacket((Entity)this, (ServerEntity)serverEntity);
    }

    public void shootFromRotation(Entity entity, float f, float f1, float f2, float f3, float f4) {
        float x = -Mth.sin((float)(f1 * ((float)Math.PI / 180))) * Mth.cos((float)(f * ((float)Math.PI / 180)));
        float y = -Mth.sin((float)(f * ((float)Math.PI / 180)));
        float z = Mth.cos((float)(f1 * ((float)Math.PI / 180))) * Mth.cos((float)(f * ((float)Math.PI / 180)));
        this.shoot(x, y, z, f3, f4);
        Vec3 entityMotion = entity.getDeltaMovement();
        this.setDeltaMovement(this.getDeltaMovement().add(entityMotion.x, entity.onGround() ? 0.0 : entityMotion.y, entityMotion.z));
    }

    @Override
    public void tick() {
        super.tick();
        double speed = this.getDeltaMovement().length();
        double amount = 8.0;
        if (speed > 1.0) {
            int i1 = 1;
            while ((double)i1 < amount) {
                Vec3 pos = this.position().add(this.getDeltaMovement().scale((double)i1 / amount));
                if (this.level().isClientSide()) {
                    this.level().addParticle((ParticleOptions)ParticleTypes.SMOKE, pos.x, pos.y, pos.z, 0.0, 0.0, 0.0);
                }
                ++i1;
            }
        }
    }

    public void createCrater() {
        if (this.level().isClientSide || !this.inGround || this.isInWater()) {
            return;
        }
        this.remove(Entity.RemovalReason.DISCARDED);
        Entity shooter = this.getOwner();
        if (!(shooter instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)shooter;
        Registry enchRegistry = this.registryAccess().registryOrThrow(Registries.ENCHANTMENT);
        Holder power = enchRegistry.getHolder(Enchantments.POWER).orElse(null);
        Holder flame = enchRegistry.getHolder(Enchantments.FLAME).orElse(null);
        if (power != null && EnchantmentHelper.getEnchantmentLevel((Holder)power, (LivingEntity)livingEntity) > 0) {
            float f1 = EnchantmentHelper.getEnchantmentLevel((Holder)power, (LivingEntity)livingEntity);
            this.explosiveSize += f1 / 4.0f;
        }
        boolean flag = flame != null && EnchantmentHelper.getEnchantmentLevel((Holder)flame, (LivingEntity)livingEntity) > 0;
        PhysHelper.createAdvancedExplosion(this.level(), (Entity)this, this.getX(), this.getY(), this.getZ(), this.explosiveSize, WeaponModConfig.get().mortarDoesBlockDamage, true, flag, Explosion.BlockInteraction.DESTROY);
    }

    @Override
    @NotNull
    public DamageSource getDamageSource() {
        return this.damageSources().source(WMDamageSources.WEAPON, (Entity)this, this.getDamagingEntity());
    }

    @Override
    public void onHitEntity(EntityHitResult result) {
        this.setDeltaMovement(this.getDeltaMovement().scale(0.5));
        if (result.getEntity().hurt(this.getDamageSource(), 5.0f)) {
            this.playSound(SoundEvents.PLAYER_HURT, 1.0f, 1.2f / (this.random.nextFloat() * 0.4f + 0.7f));
        }
    }

    @Override
    public void onHitBlock(BlockHitResult result) {
        BlockPos blockpos = result.getBlockPos();
        this.xTile = blockpos.getX();
        this.yTile = blockpos.getY();
        this.zTile = blockpos.getZ();
        this.inBlockState = this.level().getBlockState(blockpos);
        this.setDeltaMovement(result.getLocation().subtract(this.position()));
        double f1 = this.getDeltaMovement().length();
        Vec3 pos = this.position().subtract(this.getDeltaMovement().scale(0.05 / f1));
        this.setPos(pos.x, pos.y, pos.z);
        this.inGround = true;
        if (this.inBlockState != null) {
            this.inBlockState.entityInside(this.level(), blockpos, (Entity)this);
        }
        this.createCrater();
    }

    @Override
    public float getAirResistance() {
        return 0.98f;
    }

    @Override
    public double getDefaultGravity() {
        return 0.04f;
    }

    @Override
    @NotNull
    protected ItemStack getDefaultPickupItem() {
        return new ItemStack((ItemLike)WMRegistries.ITEM_MORTAR_SHELL.get());
    }
}

